/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class InheritanceSearchConstInstr
extends Instr
implements ResultInstr {
    Operand currentModule;
    String constName;
    private Variable result;
    private boolean noPrivateConsts;
    private volatile transient Object cachedConstant = null;
    private volatile int hash = -1;
    private volatile Object generation = -1;

    public InheritanceSearchConstInstr(Variable result2, Operand currentModule, String constName, boolean noPrivateConsts) {
        super(Operation.INHERITANCE_SEARCH_CONST);
        assert (result2 != null) : "InheritanceSearchConstInstr result is null";
        this.currentModule = currentModule;
        this.constName = constName;
        this.result = result2;
        this.noPrivateConsts = noPrivateConsts;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.currentModule};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.currentModule = this.currentModule.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new InheritanceSearchConstInstr(ii.getRenamedVariable(this.result), this.currentModule.cloneForInlining(ii), this.constName, this.noPrivateConsts);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.currentModule + ", " + this.constName + ")";
    }

    private Object cache(Ruby runtime, RubyModule module) {
        IRubyObject constant;
        IRubyObject iRubyObject = constant = this.noPrivateConsts ? module.getConstantFromNoConstMissing(this.constName, false) : module.getConstantNoConstMissing(this.constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        } else {
            this.generation = runtime.getConstantInvalidator().getData();
            this.hash = module.hashCode();
            this.cachedConstant = constant;
        }
        return constant;
    }

    private boolean isCached(Ruby runtime, RubyModule target, Object value2) {
        return value2 != null && this.generation == runtime.getConstantInvalidator().getData() && this.hash == target.hashCode();
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        Ruby runtime = context.runtime;
        Object cmVal = this.currentModule.retrieve(context, self, currDynScope, temp);
        if (!(cmVal instanceof RubyModule)) {
            throw runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        Object constant = this.cachedConstant;
        if (!this.isCached(runtime, module, constant)) {
            constant = this.cache(runtime, module);
        }
        return constant;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.InheritanceSearchConstInstr(this);
    }

    public Operand getCurrentModule() {
        return this.currentModule;
    }

    public String getConstName() {
        return this.constName;
    }

    public boolean isNoPrivateConsts() {
        return this.noPrivateConsts;
    }
}

