/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReceiveRestArgBase;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.parser.IRStaticScope;
import org.jruby.parser.StaticScope;

public class IRMethod
extends IRScope {
    public final boolean isInstanceMethod;
    private List<Operand> callArgs;
    private List<String[]> argDesc;

    public IRMethod(IRManager manager, IRScope lexicalParent, String name2, boolean isInstanceMethod, int lineNumber, StaticScope staticScope) {
        super(manager, lexicalParent, name2, lexicalParent.getFileName(), lineNumber, staticScope);
        this.isInstanceMethod = isInstanceMethod;
        this.callArgs = new ArrayList<Operand>();
        this.argDesc = new ArrayList<String[]>();
        if (!this.getManager().isDryRun() && staticScope != null) {
            ((IRStaticScope)staticScope).setIRScope(this);
        }
    }

    @Override
    public String getScopeName() {
        return "Method";
    }

    @Override
    public void addInstr(Instr i2) {
        if (i2 instanceof ReceiveRestArgBase) {
            this.callArgs.add(new Splat(((ReceiveRestArgBase)i2).getResult()));
        } else if (i2 instanceof ReceiveArgBase) {
            this.callArgs.add(((ReceiveArgBase)i2).getResult());
        }
        super.addInstr(i2);
    }

    public void addArgDesc(String type2, String argName) {
        this.argDesc.add(new String[]{type2, argName});
    }

    public List<String[]> getArgDesc() {
        return this.argDesc;
    }

    public Operand[] getCallArgs() {
        return this.callArgs.toArray(new Operand[this.callArgs.size()]);
    }

    @Override
    public LocalVariable findExistingLocalVariable(String name2, int scopeDepth) {
        assert (scopeDepth == 0) : "Local variable depth in IRMethod should always be zero (" + name2 + " had depth of " + scopeDepth + ")";
        return this.localVars.getVariable(name2);
    }

    @Override
    public LocalVariable getNewLocalVariable(String name2, int scopeDepth) {
        assert (scopeDepth == 0) : "Local variable depth in IRMethod should always be zero (" + name2 + " had depth of " + scopeDepth + ")";
        LocalVariable lvar = new LocalVariable(name2, 0, this.localVars.nextSlot);
        this.localVars.putVariable(name2, lvar);
        return lvar;
    }

    @Override
    public LocalVariable getLocalVariable(String name2, int scopeDepth) {
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, scopeDepth);
        }
        return lvar;
    }

    @Override
    public LocalVariable getImplicitBlockArg() {
        return this.getLocalVariable("%block", 0);
    }
}

