/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.AllocatedNativeMemoryIO;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;

class BoundedNativeMemoryIO
extends MemoryIO {
    protected static final com.kenai.jffi.MemoryIO IO = com.kenai.jffi.MemoryIO.getInstance();
    protected static final int LONG_SIZE = Platform.getPlatform().longSize();
    protected static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    private final Ruby runtime;
    final long size;
    final MemoryIO parent;

    BoundedNativeMemoryIO(Ruby runtime, long address2, int size2) {
        super(true, address2);
        this.runtime = runtime;
        this.size = size2;
        this.parent = null;
    }

    BoundedNativeMemoryIO(BoundedNativeMemoryIO parent, long offset2) {
        super(true, parent.address() + offset2);
        this.runtime = parent.runtime;
        this.size = parent.size - offset2;
        this.parent = parent;
    }

    BoundedNativeMemoryIO(Ruby runtime, MemoryIO parent, long offset2, long size2) {
        super(true, parent.address() + offset2);
        this.runtime = runtime;
        this.size = size2;
        this.parent = parent;
        if (!parent.isDirect()) {
            throw new IllegalArgumentException("non-direct memory");
        }
    }

    private final void checkBounds(long off, long len) {
        Util.checkBounds(this.runtime, this.size, off, len);
    }

    @Override
    public Object array() {
        throw this.runtime.newRuntimeError("no array");
    }

    @Override
    public int arrayOffset() {
        throw this.runtime.newRuntimeError("no array");
    }

    @Override
    public int arrayLength() {
        throw this.runtime.newRuntimeError("no array");
    }

    @Override
    public BoundedNativeMemoryIO slice(long offset2) {
        this.checkBounds(offset2, 1L);
        return offset2 == 0L ? this : new BoundedNativeMemoryIO(this, offset2);
    }

    @Override
    public BoundedNativeMemoryIO slice(long offset2, long size2) {
        this.checkBounds(offset2, size2);
        return offset2 == 0L && size2 == this.size ? this : new BoundedNativeMemoryIO(this.runtime, this, offset2, size2);
    }

    @Override
    public MemoryIO dup() {
        AllocatedNativeMemoryIO tmp = AllocatedNativeMemoryIO.allocate(this.runtime, (int)this.size, false);
        IO.memcpy(tmp.address, this.address, this.size);
        return tmp;
    }

    @Override
    public final ByteBuffer asByteBuffer() {
        return IO.newDirectByteBuffer(this.address, (int)this.size);
    }

    Ruby getRuntime() {
        return this.runtime;
    }

    public final boolean equals(Object obj) {
        return obj instanceof MemoryIO && ((MemoryIO)obj).address() == this.address;
    }

    public final int hashCode() {
        int hash2 = 5;
        hash2 = 53 * hash2 + (int)(this.address ^ this.address >>> 32);
        return hash2;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public final byte getByte(long offset2) {
        this.checkBounds(offset2, 1L);
        return IO.getByte(this.address + offset2);
    }

    @Override
    public final short getShort(long offset2) {
        this.checkBounds(offset2, 2L);
        return IO.getShort(this.address + offset2);
    }

    @Override
    public final int getInt(long offset2) {
        this.checkBounds(offset2, 4L);
        return IO.getInt(this.address + offset2);
    }

    @Override
    public final long getLong(long offset2) {
        this.checkBounds(offset2, 8L);
        return IO.getLong(this.address + offset2);
    }

    @Override
    public final long getNativeLong(long offset2) {
        return LONG_SIZE == 32 ? (long)this.getInt(offset2) : this.getLong(offset2);
    }

    @Override
    public final float getFloat(long offset2) {
        this.checkBounds(offset2, 4L);
        return IO.getFloat(this.address + offset2);
    }

    @Override
    public final double getDouble(long offset2) {
        this.checkBounds(offset2, 8L);
        return IO.getDouble(this.address + offset2);
    }

    @Override
    public final long getAddress(long offset2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        return IO.getAddress(this.address + offset2);
    }

    @Override
    public final MemoryIO getMemoryIO(long offset2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        return NativeMemoryIO.wrap(this.runtime, IO.getAddress(this.address + offset2));
    }

    @Override
    public final void putByte(long offset2, byte value2) {
        this.checkBounds(offset2, 1L);
        IO.putByte(this.address + offset2, value2);
    }

    @Override
    public final void putShort(long offset2, short value2) {
        this.checkBounds(offset2, 2L);
        IO.putShort(this.address + offset2, value2);
    }

    @Override
    public final void putInt(long offset2, int value2) {
        this.checkBounds(offset2, 4L);
        IO.putInt(this.address + offset2, value2);
    }

    @Override
    public final void putLong(long offset2, long value2) {
        this.checkBounds(offset2, 8L);
        IO.putLong(this.address + offset2, value2);
    }

    @Override
    public final void putNativeLong(long offset2, long value2) {
        if (LONG_SIZE == 32) {
            this.putInt(offset2, (int)value2);
        } else {
            this.putLong(offset2, value2);
        }
    }

    @Override
    public final void putAddress(long offset2, long value2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        IO.putAddress(this.address + offset2, value2);
    }

    @Override
    public final void putFloat(long offset2, float value2) {
        this.checkBounds(offset2, 4L);
        IO.putFloat(this.address + offset2, value2);
    }

    @Override
    public final void putDouble(long offset2, double value2) {
        this.checkBounds(offset2, 8L);
        IO.putDouble(this.address + offset2, value2);
    }

    @Override
    public final void putMemoryIO(long offset2, MemoryIO value2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        IO.putAddress(this.address + offset2, value2.address());
    }

    @Override
    public final void get(long offset2, byte[] dst, int off, int len) {
        this.checkBounds(offset2, len);
        IO.getByteArray(this.address + offset2, dst, off, len);
    }

    @Override
    public final void put(long offset2, byte[] src, int off, int len) {
        this.checkBounds(offset2, len);
        IO.putByteArray(this.address + offset2, src, off, len);
    }

    @Override
    public final void get(long offset2, short[] dst, int off, int len) {
        this.checkBounds(offset2, len << 1);
        IO.getShortArray(this.address + offset2, dst, off, len);
    }

    @Override
    public final void put(long offset2, short[] src, int off, int len) {
        this.checkBounds(offset2, len << 1);
        IO.putShortArray(this.address + offset2, src, off, len);
    }

    @Override
    public final void get(long offset2, int[] dst, int off, int len) {
        this.checkBounds(offset2, len << 2);
        IO.getIntArray(this.address + offset2, dst, off, len);
    }

    @Override
    public final void put(long offset2, int[] src, int off, int len) {
        this.checkBounds(offset2, len << 2);
        IO.putIntArray(this.address + offset2, src, off, len);
    }

    @Override
    public final void get(long offset2, long[] dst, int off, int len) {
        this.checkBounds(offset2, len << 3);
        IO.getLongArray(this.address + offset2, dst, off, len);
    }

    @Override
    public final void put(long offset2, long[] src, int off, int len) {
        this.checkBounds(offset2, len << 3);
        IO.putLongArray(this.address + offset2, src, off, len);
    }

    @Override
    public final void get(long offset2, float[] dst, int off, int len) {
        this.checkBounds(offset2, len << 2);
        IO.getFloatArray(this.address + offset2, dst, off, len);
    }

    @Override
    public final void put(long offset2, float[] src, int off, int len) {
        this.checkBounds(offset2, len << 2);
        IO.putFloatArray(this.address + offset2, src, off, len);
    }

    @Override
    public final void get(long offset2, double[] dst, int off, int len) {
        this.checkBounds(offset2, len << 3);
        IO.getDoubleArray(this.address + offset2, dst, off, len);
    }

    @Override
    public final void put(long offset2, double[] src, int off, int len) {
        this.checkBounds(offset2, len << 3);
        IO.putDoubleArray(this.address + offset2, src, off, len);
    }

    @Override
    public final int indexOf(long offset2, byte value2) {
        return value2 == 0 ? (int)IO.getStringLength(this.address + offset2) : (int)IO.indexOf(this.address + offset2, value2);
    }

    @Override
    public final int indexOf(long offset2, byte value2, int maxlen) {
        return (int)IO.indexOf(this.address, value2, maxlen);
    }

    @Override
    public final void setMemory(long offset2, long size2, byte value2) {
        this.checkBounds(offset2, size2);
        IO.setMemory(this.address + offset2, size2, value2);
    }

    @Override
    public final byte[] getZeroTerminatedByteArray(long offset2) {
        this.checkBounds(offset2, 1L);
        return IO.getZeroTerminatedByteArray(this.address + offset2);
    }

    @Override
    public final byte[] getZeroTerminatedByteArray(long offset2, int maxlen) {
        this.checkBounds(offset2, 1L);
        return IO.getZeroTerminatedByteArray(this.address + offset2, Math.min(maxlen, (int)(this.size - offset2)));
    }

    @Override
    public void putZeroTerminatedByteArray(long offset2, byte[] bytes2, int off, int len) {
        this.checkBounds(offset2, len + 1);
        IO.putZeroTerminatedByteArray(this.address + offset2, bytes2, off, len);
    }
}

