/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayNode
extends ListNode
implements ILiteralNode {
    private boolean lightweight = false;

    public ArrayNode(ISourcePosition position, Node firstNode) {
        super(position, firstNode);
        assert (firstNode != null) : "ArrayNode.first == null";
    }

    public ArrayNode(ISourcePosition position) {
        super(position);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARRAYNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitArrayNode(this);
    }

    public void setLightweight(boolean lightweight) {
        this.lightweight = lightweight;
    }

    public boolean isLightweight() {
        return this.lightweight;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject[] array = this.interpretPrimitive(runtime, context, self, aBlock);
        return this.lightweight ? runtime.newArrayNoCopyLight(array) : runtime.newArrayNoCopy(array);
    }

    public IRubyObject[] interpretPrimitive(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        int size2 = this.size();
        IRubyObject[] array = new IRubyObject[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            array[i2] = this.get(i2).interpret(runtime, context, self, aBlock);
        }
        return array;
    }
}

