/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.ast.AssignableNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.VCallNode;
import org.jruby.ir.IRScope;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;

public class IRStaticScope
extends StaticScope {
    private static final String[] NO_NAMES = new String[0];
    boolean isBlock;
    boolean isEval;
    boolean isBlockOrEval;
    boolean isArgumentScope;
    IRScope irScope;

    protected IRStaticScope(StaticScope enclosingScope, boolean isBlock, boolean isEval) {
        this(enclosingScope, NO_NAMES, isBlock, isEval);
    }

    protected IRStaticScope(StaticScope enclosingScope, String[] names2, boolean isBlock, boolean isEval) {
        super(enclosingScope, names2);
        this.isBlock = isBlock;
        this.isEval = isEval;
        this.isBlockOrEval = isBlock || isEval;
        this.isArgumentScope = !this.isBlockOrEval;
        this.irScope = null;
    }

    @Override
    public StaticScope getLocalScope() {
        return this.isEval || !this.isBlock ? this : this.enclosingScope.getLocalScope();
    }

    @Override
    public int isDefined(String name2, int depth) {
        if (this.isBlockOrEval) {
            int slot = this.exists(name2);
            if (slot >= 0) {
                return depth << 16 | slot;
            }
            return this.enclosingScope.isDefined(name2, depth + 1);
        }
        return depth << 16 | this.exists(name2);
    }

    @Override
    public boolean isBlockScope() {
        return this.isBlockOrEval;
    }

    @Override
    public boolean isArgumentScope() {
        return this.isArgumentScope;
    }

    @Override
    public void makeArgumentScope() {
        this.isArgumentScope = true;
    }

    @Override
    public String[] getAllNamesInScope() {
        String[] names2 = this.getVariables();
        if (this.isBlockOrEval) {
            String[] ourVariables = names2;
            String[] variables = this.enclosingScope.getAllNamesInScope();
            names2 = new String[variables.length + ourVariables.length];
            System.arraycopy(variables, 0, names2, 0, variables.length);
            System.arraycopy(ourVariables, 0, names2, variables.length, ourVariables.length);
        }
        return names2;
    }

    public AssignableNode addAssign(ISourcePosition position, String name2, Node value2) {
        int slot = this.addVariable(name2);
        return new DAsgnNode(position, name2, slot, value2);
    }

    @Override
    public AssignableNode assign(ISourcePosition position, String name2, Node value2, StaticScope topScope, int depth) {
        int slot = this.exists(name2);
        if (slot >= 0) {
            return this.isBlockOrEval ? new DAsgnNode(position, name2, depth << 16 | slot, value2) : new LocalAsgnNode(position, name2, depth << 16 | slot, value2);
        }
        if (!this.isBlockOrEval && topScope == this) {
            slot = this.addVariable(name2);
            return new LocalAsgnNode(position, name2, slot, value2);
        }
        return this.isBlockOrEval ? this.enclosingScope.assign(position, name2, value2, topScope, depth + 1) : ((IRStaticScope)topScope).addAssign(position, name2, value2);
    }

    @Override
    public Node declare(ISourcePosition position, String name2, int depth) {
        int slot = this.exists(name2);
        if (slot >= 0) {
            return this.isBlockOrEval ? new DVarNode(position, depth << 16 | slot, name2) : new LocalVarNode(position, depth << 16 | slot, name2);
        }
        return this.isBlockOrEval ? this.enclosingScope.declare(position, name2, depth + 1) : new VCallNode(position, name2);
    }

    @Override
    public String toString() {
        return "IRStaticScope" + (this.isBlockOrEval ? "(BLOCK): " : "(LOCAL): ") + super.toString();
    }

    public IRScope getIRScope() {
        return this.irScope;
    }

    public void setIRScope(IRScope irScope) {
        this.irScope = irScope;
    }

    @Override
    public int getNumberOfVariables() {
        return this.irScope == null ? super.getNumberOfVariables() : this.irScope.getUsedVariablesCount();
    }

    @Override
    public StaticScope.Type getType() {
        return this.isBlock ? StaticScope.Type.BLOCK : (this.isEval ? StaticScope.Type.EVAL : StaticScope.Type.LOCAL);
    }
}

