/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanLoader<T> {
    private Yaml loader;

    public JavaBeanLoader(TypeDescription typeDescription) {
        this(typeDescription, BeanAccess.DEFAULT);
    }

    public JavaBeanLoader(TypeDescription typeDescription, BeanAccess beanAccess) {
        this(new LoaderOptions(typeDescription), beanAccess);
    }

    public JavaBeanLoader(LoaderOptions options2, BeanAccess beanAccess) {
        if (options2 == null) {
            throw new NullPointerException("LoaderOptions must be provided.");
        }
        if (options2.getRootTypeDescription() == null) {
            throw new NullPointerException("TypeDescription must be provided.");
        }
        Constructor constructor2 = new Constructor(options2.getRootTypeDescription());
        this.loader = new Yaml(constructor2, options2, new Representer(), new DumperOptions(), new Resolver());
        this.loader.setBeanAccess(beanAccess);
    }

    public <S extends T> JavaBeanLoader(Class<S> clazz, BeanAccess beanAccess) {
        this(new TypeDescription(clazz), beanAccess);
    }

    public <S extends T> JavaBeanLoader(Class<S> clazz) {
        this(clazz, BeanAccess.DEFAULT);
    }

    public T load(String yaml) {
        return (T)this.loader.load(new StringReader(yaml));
    }

    public T load(InputStream io2) {
        return (T)this.loader.load(new UnicodeReader(io2));
    }

    public T load(Reader io2) {
        return (T)this.loader.load(io2);
    }
}

