/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.joda.time.DateTime;
import org.jruby.util.log.Logger;

public class JavaUtilLoggingLogger
implements Logger {
    private final java.util.logging.Logger logger;

    public JavaUtilLoggingLogger(String loggerName) {
        this.logger = java.util.logging.Logger.getLogger(loggerName);
        this.logger.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord lr) {
                StringBuilder sb = new StringBuilder();
                sb.append(new DateTime(lr.getMillis()).toString()).append(": ").append(lr.getLoggerName()).append(": ").append(lr.getMessage()).append("\n");
                return sb.toString();
            }
        });
        this.logger.addHandler(handler);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void warn(String message2, Object ... args2) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(message2 + (args2.length == 0 ? "" : "\n" + Arrays.toString(args2)));
        }
    }

    @Override
    public void warn(Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(this.getLoggingOutput(throwable));
        }
    }

    @Override
    public void warn(String message2, Throwable throwable) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(message2 + "\n" + this.getLoggingOutput(throwable));
        }
    }

    @Override
    public void error(String message2, Object ... args2) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.logger.severe(message2 + (args2.length == 0 ? "" : "\n" + Arrays.toString(args2)));
        }
    }

    @Override
    public void error(Throwable throwable) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.logger.severe(this.getLoggingOutput(throwable));
        }
    }

    @Override
    public void error(String message2, Throwable throwable) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.logger.severe(message2 + "\n" + this.getLoggingOutput(throwable));
        }
    }

    @Override
    public void info(String message2, Object ... args2) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(message2 + (args2.length == 0 ? "" : "\n" + Arrays.toString(args2)));
        }
    }

    @Override
    public void info(Throwable throwable) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(this.getLoggingOutput(throwable));
        }
    }

    @Override
    public void info(String message2, Throwable throwable) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(message2 + "\n" + this.getLoggingOutput(throwable));
        }
    }

    @Override
    public void debug(String message2, Object ... args2) {
        if (this.isDebugEnabled()) {
            this.logger.finest(message2 + (args2.length == 0 ? "" : "\n" + Arrays.toString(args2)));
        }
    }

    @Override
    public void debug(Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.logger.finest(this.getLoggingOutput(throwable));
        }
    }

    @Override
    public void debug(String message2, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.logger.finest(message2 + "\n" + this.getLoggingOutput(throwable));
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void setDebugEnable(boolean debug) {
        this.logger.setLevel(Level.FINEST);
    }

    private String getLoggingOutput(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

