/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

public class TimeOutputFormatter {
    private final String formatter;
    private final int totalPadding;

    public TimeOutputFormatter(String formatter, int totalPadding) {
        this.formatter = formatter;
        this.totalPadding = totalPadding;
    }

    public static TimeOutputFormatter getFormatter(String pattern) {
        int i2;
        int length2 = pattern.length();
        if (length2 <= 1 || pattern.charAt(0) != '%') {
            return null;
        }
        int totalPadding = 0;
        boolean done = false;
        boolean formatterFound = false;
        block7: for (i2 = 1; i2 < length2 && !done; ++i2) {
            char c = pattern.charAt(i2);
            switch (c) {
                case '-': 
                case '0': 
                case '^': 
                case '_': {
                    formatterFound = true;
                    continue block7;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    totalPadding = Character.getNumericValue(c);
                    done = true;
                    continue block7;
                }
                default: {
                    done = true;
                }
            }
        }
        if (totalPadding == 0 && !formatterFound) {
            return null;
        }
        String formatter = i2 > 2 ? pattern.substring(1, i2 - 1) : "";
        if (totalPadding == 0 && i2 > 2) {
            return new TimeOutputFormatter(formatter, 0);
        }
        done = false;
        while (i2 < length2 && !done) {
            char c = pattern.charAt(i2);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    totalPadding = totalPadding * 10 + Character.getNumericValue(c);
                    break;
                }
                default: {
                    done = true;
                }
            }
            ++i2;
        }
        if (totalPadding != 0) {
            return new TimeOutputFormatter(formatter, totalPadding);
        }
        return null;
    }

    public String getFormatter() {
        return (this.formatter != null ? this.formatter : "") + (this.totalPadding > 0 ? Integer.valueOf(this.totalPadding) : "");
    }

    public String format(String sequence) {
        int paddedWith = 32;
        if (this.formatter != null) {
            block6: for (int i2 = 0; i2 < this.formatter.length(); ++i2) {
                switch (this.formatter.charAt(i2)) {
                    case '^': {
                        sequence = sequence.toUpperCase();
                        continue block6;
                    }
                    case '_': {
                        paddedWith = 32;
                        continue block6;
                    }
                    case '0': {
                        paddedWith = 48;
                        continue block6;
                    }
                    case '-': {
                        sequence = sequence.replaceAll("^[0 ]", "");
                    }
                }
            }
        }
        if (this.totalPadding > 0) {
            sequence = this.padding(sequence, (char)paddedWith);
        }
        return sequence;
    }

    private String padding(String sequence, char padder) {
        if (this.formatter != null && this.formatter.contains("-")) {
            return sequence;
        }
        if (sequence != null && sequence.length() < this.totalPadding) {
            StringBuilder seqBuf = new StringBuilder(this.totalPadding);
            for (int i2 = sequence.length(); i2 < this.totalPadding; ++i2) {
                seqBuf.append(padder);
            }
            seqBuf.append(sequence);
            return seqBuf.toString();
        }
        return sequence;
    }
}

