/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.util;

import java.lang.reflect.Array;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayUtils {
    public static IRubyObject arefDirect(Ruby runtime, Object array, JavaUtil.JavaConverter javaConverter, int intIndex) {
        try {
            return JavaUtil.convertJavaArrayElementToRuby(runtime, javaConverter, array, intIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw runtime.newArgumentError("index out of bounds for java array (" + intIndex + " for length " + Array.getLength(array) + ")");
        }
    }

    public static IRubyObject concatArraysDirect(ThreadContext context, Object original, Object additional) {
        int oldLength = Array.getLength(original);
        int addLength = Array.getLength(additional);
        ArrayJavaProxy proxy2 = ArrayUtils.newProxiedArray(context.runtime, original.getClass().getComponentType(), oldLength + addLength);
        Object newArray = proxy2.getObject();
        System.arraycopy(original, 0, newArray, 0, oldLength);
        System.arraycopy(additional, 0, newArray, oldLength, addLength);
        return proxy2;
    }

    public static ArrayJavaProxy newProxiedArray(Ruby runtime, Class componentType, int size2) {
        return ArrayUtils.newProxiedArray(runtime, componentType, JavaUtil.getJavaConverter(componentType), size2);
    }

    public static ArrayJavaProxy newProxiedArray(Ruby runtime, Class componentType, JavaUtil.JavaConverter converter, int size2) {
        Object ary = Array.newInstance(componentType, size2);
        RubyClass newProxyClass = JavaClass.get(runtime, ary.getClass()).getProxyClass();
        ArrayJavaProxy proxy2 = new ArrayJavaProxy(runtime, newProxyClass, ary, converter);
        return proxy2;
    }

    public static IRubyObject emptyJavaArrayDirect(ThreadContext context, Class componentType) {
        Ruby runtime = context.runtime;
        return ArrayUtils.newProxiedArray(runtime, componentType, 0);
    }

    public static IRubyObject javaArraySubarrayDirect(ThreadContext context, Object fromArray, int index2, int size2) {
        int actualLength = Array.getLength(fromArray);
        if (index2 >= actualLength) {
            return context.runtime.getNil();
        }
        if (index2 + size2 > actualLength) {
            size2 = actualLength - index2;
        }
        ArrayJavaProxy proxy2 = ArrayUtils.newProxiedArray(context.runtime, fromArray.getClass().getComponentType(), size2);
        Object newArray = proxy2.getObject();
        System.arraycopy(fromArray, index2, newArray, 0, size2);
        return proxy2;
    }

    public static IRubyObject concatArraysDirect(ThreadContext context, Object original, IRubyObject additional) {
        Ruby runtime = context.runtime;
        int oldLength = Array.getLength(original);
        int addLength = (int)((RubyFixnum)RuntimeHelpers.invoke(context, additional, "length")).getLongValue();
        ArrayJavaProxy proxy2 = ArrayUtils.newProxiedArray(runtime, original.getClass().getComponentType(), oldLength + addLength);
        Object newArray = proxy2.getObject();
        System.arraycopy(original, 0, newArray, 0, oldLength);
        for (int i2 = 0; i2 < addLength; ++i2) {
            RuntimeHelpers.invoke(context, (IRubyObject)proxy2, "[]=", (IRubyObject)runtime.newFixnum(oldLength + i2), RuntimeHelpers.invoke(context, additional, "[]", (IRubyObject)runtime.newFixnum(i2)));
        }
        return proxy2;
    }

    public static IRubyObject asetDirect(Ruby runtime, Object array, JavaUtil.JavaConverter javaConverter, int intIndex, IRubyObject value2) {
        try {
            javaConverter.set(runtime, array, intIndex, value2);
        }
        catch (IndexOutOfBoundsException e) {
            throw runtime.newArgumentError("index out of bounds for java array (" + intIndex + " for length " + Array.getLength(array) + ")");
        }
        catch (ArrayStoreException e) {
            throw runtime.newTypeError("wrong element type " + value2.getClass() + "(array contains " + array.getClass().getComponentType().getName() + ")");
        }
        catch (IllegalArgumentException iae) {
            throw runtime.newArgumentError("wrong element type " + value2.getClass() + "(array contains " + array.getClass().getComponentType().getName() + ")");
        }
        return value2;
    }

    public static void setWithExceptionHandlingDirect(Ruby runtime, Object ary, int intIndex, Object javaObject) {
        try {
            Array.set(ary, intIndex, javaObject);
        }
        catch (IndexOutOfBoundsException e) {
            throw runtime.newArgumentError("index out of bounds for java array (" + intIndex + " for length " + Array.getLength(ary) + ")");
        }
        catch (ArrayStoreException e) {
            throw runtime.newTypeError("wrong element type " + javaObject.getClass() + "(array contains " + ary.getClass().getComponentType().getName() + ")");
        }
        catch (IllegalArgumentException iae) {
            throw runtime.newArgumentError("wrong element type " + javaObject.getClass() + "(array contains " + ary.getClass().getComponentType().getName() + ")");
        }
    }

    public static void copyDataToJavaArrayDirect(ThreadContext context, RubyArray rubyArray, Object javaArray) {
        int javaLength = Array.getLength(javaArray);
        Class<?> targetType = javaArray.getClass().getComponentType();
        int rubyLength = rubyArray.getLength();
        for (int i2 = 0; i2 < rubyLength && i2 < javaLength; ++i2) {
            Array.set(javaArray, i2, rubyArray.entry(i2).toJava(targetType));
        }
    }

    public static void copyDataToJavaArray(ThreadContext context, RubyArray rubyArray, int src, JavaArray javaArray, int dest, int length2) {
        Class targetType = javaArray.getComponentType();
        int destLength = (int)javaArray.length().getLongValue();
        int srcLength = rubyArray.getLength();
        for (int i2 = 0; src + i2 < srcLength && dest + i2 < destLength && i2 < length2; ++i2) {
            javaArray.setWithExceptionHandling(dest + i2, rubyArray.entry(src + i2).toJava(targetType));
        }
    }
}

