/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CompilerPass;

public class OptimizeTempVarsPass
extends CompilerPass {
    boolean optimizedTempVars = false;

    @Override
    public String getLabel() {
        return "Temporary Variable Reduction";
    }

    @Override
    public Object execute(IRScope s2, Object ... data2) {
        for (IRClosure c : s2.getClosures()) {
            this.run(c, true);
        }
        OptimizeTempVarsPass.optimizeTmpVars(s2);
        this.optimizedTempVars = true;
        return null;
    }

    @Override
    public Object previouslyRun(IRScope scope) {
        return this.optimizedTempVars ? new Object() : null;
    }

    @Override
    public void invalidate(IRScope s2) {
    }

    private static void allocVar(Operand oldVar, IRScope s2, List<TemporaryVariable> freeVarsList, Map<Operand, Operand> newVarMap) {
        if (newVarMap.get(oldVar) == null) {
            newVarMap.put(oldVar, freeVarsList.isEmpty() ? s2.getNewTemporaryVariable() : freeVarsList.remove(0));
        }
    }

    private static void freeVar(TemporaryVariable newVar, List<TemporaryVariable> freeVarsList) {
        if (!freeVarsList.contains(newVar)) {
            freeVarsList.add(0, newVar);
        }
    }

    private static void optimizeTmpVars(IRScope s2) {
        if (s2.getCFG() != null) {
            return;
        }
        HashMap<TemporaryVariable, ArrayList<Instr>> tmpVarUses = new HashMap<TemporaryVariable, ArrayList<Instr>>();
        HashMap<TemporaryVariable, ArrayList<Instr>> tmpVarDefs = new HashMap<TemporaryVariable, ArrayList<Instr>>();
        for (Instr i2 : s2.getInstrs()) {
            Variable v;
            for (Variable v2 : i2.getUsedVariables()) {
                if (!(v2 instanceof TemporaryVariable)) continue;
                TemporaryVariable tv = (TemporaryVariable)v2;
                ArrayList<Instr> uses = (ArrayList<Instr>)tmpVarUses.get(tv);
                if (uses == null) {
                    uses = new ArrayList<Instr>();
                    tmpVarUses.put(tv, uses);
                }
                uses.add(i2);
            }
            if (!(i2 instanceof ResultInstr) || !((v = ((ResultInstr)((Object)i2)).getResult()) instanceof TemporaryVariable)) continue;
            TemporaryVariable tv = (TemporaryVariable)v;
            ArrayList<Instr> defs = (ArrayList<Instr>)tmpVarDefs.get(tv);
            if (defs == null) {
                defs = new ArrayList<Instr>();
                tmpVarDefs.put(tv, defs);
            }
            defs.add(i2);
        }
        HashMap removableCopies = new HashMap();
        ListIterator<Instr> instrs = s2.getInstrs().listIterator();
        while (instrs.hasNext()) {
            Instr soleDef;
            CopyInstr ci;
            Operand src;
            Variable v2;
            Instr i3 = instrs.next();
            if (!(i3 instanceof ResultInstr)) continue;
            v2 = ((ResultInstr)((Object)i3)).getResult();
            if (v2 instanceof TemporaryVariable) {
                List uses = (List)tmpVarUses.get((TemporaryVariable)v2);
                List defs = (List)tmpVarDefs.get((TemporaryVariable)v2);
                if (uses == null) {
                    if (i3 instanceof CopyInstr) {
                        i3.markDead();
                        instrs.remove();
                        continue;
                    }
                    if (i3 instanceof CallInstr) {
                        instrs.set(((CallInstr)i3).discardResult());
                        continue;
                    }
                    i3.markUnusedResult();
                    continue;
                }
                if (uses.size() != 1 || defs == null || defs.size() != 1 || !(i3 instanceof CopyInstr)) continue;
                CopyInstr ci2 = (CopyInstr)i3;
                Operand src2 = ci2.getSource();
                i3.markDead();
                instrs.remove();
                HashMap<Operand, Operand> copyMap = new HashMap<Operand, Operand>();
                copyMap.put(v2, src2);
                Instr soleUse = (Instr)uses.get(0);
                soleUse.simplifyOperands(copyMap, true);
                continue;
            }
            if (!(i3 instanceof CopyInstr) || !((src = (ci = (CopyInstr)i3).getSource()) instanceof TemporaryVariable)) continue;
            TemporaryVariable vsrc = (TemporaryVariable)src;
            List uses = (List)tmpVarUses.get(vsrc);
            List defs = (List)tmpVarDefs.get(vsrc);
            if (uses.size() != 1 || defs.size() != 1 || (soleDef = (Instr)defs.get(0)).isDead()) continue;
            ((ResultInstr)((Object)soleDef)).updateResult(ci.getResult());
            ci.markDead();
            instrs.remove();
        }
        HashMap<TemporaryVariable, Integer> lastVarUseOrDef = new HashMap<TemporaryVariable, Integer>();
        int iCount = -1;
        for (Instr i4 : s2.getInstrs()) {
            Variable v;
            ++iCount;
            if (i4 instanceof ResultInstr && (v = ((ResultInstr)((Object)i4)).getResult()) instanceof TemporaryVariable) {
                lastVarUseOrDef.put((TemporaryVariable)v, iCount);
            }
            for (Variable v3 : i4.getUsedVariables()) {
                if (!(v3 instanceof TemporaryVariable)) continue;
                lastVarUseOrDef.put((TemporaryVariable)v3, iCount);
            }
        }
        if (s2.hasLoops()) {
            lastVarUseOrDef.put((TemporaryVariable)s2.getCurrentScopeVariable(), iCount);
            lastVarUseOrDef.put((TemporaryVariable)s2.getCurrentModuleVariable(), iCount);
        }
        HashMap<Operand, Operand> newVarMap = new HashMap<Operand, Operand>();
        ArrayList<TemporaryVariable> freeVarsList = new ArrayList<TemporaryVariable>();
        iCount = -1;
        s2.resetTemporaryVariables();
        for (Instr i5 : s2.getInstrs()) {
            ++iCount;
            Variable result2 = null;
            if (i5 instanceof ResultInstr && (result2 = ((ResultInstr)((Object)i5)).getResult()) instanceof TemporaryVariable) {
                OptimizeTempVarsPass.allocVar(result2, s2, freeVarsList, newVarMap);
            }
            for (Variable v : i5.getUsedVariables()) {
                if (!(v instanceof TemporaryVariable)) continue;
                OptimizeTempVarsPass.allocVar(v, s2, freeVarsList, newVarMap);
            }
            if (result2 instanceof TemporaryVariable && (Integer)lastVarUseOrDef.get((TemporaryVariable)result2) == iCount) {
                OptimizeTempVarsPass.freeVar((TemporaryVariable)newVarMap.get(result2), freeVarsList);
            }
            for (Variable v : i5.getUsedVariables()) {
                TemporaryVariable tv;
                if (!(v instanceof TemporaryVariable) || (Integer)lastVarUseOrDef.get(tv = (TemporaryVariable)v) != iCount) continue;
                OptimizeTempVarsPass.freeVar((TemporaryVariable)newVarMap.get(tv), freeVarsList);
            }
            i5.renameVars(newVarMap);
        }
    }
}

