/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.RubyNil;
import org.jruby.RubyProc;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Interp;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class YieldInstr
extends Instr
implements ResultInstr {
    public final boolean unwrapArray;
    private Operand blockArg;
    private Operand yieldArg;
    private Variable result;

    public YieldInstr(Variable result2, Operand block, Operand arg2, boolean unwrapArray) {
        super(Operation.YIELD);
        assert (result2 != null) : "YieldInstr result is null";
        this.blockArg = block;
        this.yieldArg = arg2 == null ? UndefinedValue.UNDEFINED : arg2;
        this.unwrapArray = unwrapArray;
        this.result = result2;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new YieldInstr(ii.getRenamedVariable(this.result), this.blockArg.cloneForInlining(ii), this.yieldArg.cloneForInlining(ii), this.unwrapArray);
    }

    public Operand getBlockArg() {
        return this.blockArg;
    }

    public Operand getYieldArg() {
        return this.yieldArg;
    }

    @Override
    public String toString() {
        return this.unwrapArray ? super.toString() + "(" + this.blockArg + ", UNWRAP(" + this.yieldArg + "))" : super.toString() + "(" + this.blockArg + ", " + this.yieldArg + ")";
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.blockArg, this.yieldArg};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    public Operand[] getNonBlockOperands() {
        return new Operand[]{this.yieldArg};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.blockArg = this.blockArg.getSimplifiedOperand(valueMap, force);
        this.yieldArg = this.yieldArg.getSimplifiedOperand(valueMap, force);
    }

    @Override
    @Interp
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        Object blk = this.blockArg.retrieve(context, self, currDynScope, temp);
        if (blk instanceof RubyProc) {
            blk = ((RubyProc)blk).getBlock();
        }
        if (blk instanceof RubyNil) {
            blk = Block.NULL_BLOCK;
        }
        Block b = (Block)blk;
        if (!context.runtime.is1_9()) {
            b.type = Block.Type.NORMAL;
        }
        if (this.yieldArg == UndefinedValue.UNDEFINED) {
            return b.yieldSpecific(context);
        }
        IRubyObject yieldVal = (IRubyObject)this.yieldArg.retrieve(context, self, currDynScope, temp);
        return this.unwrapArray && yieldVal instanceof RubyArray ? b.yieldArray(context, yieldVal, null, null) : b.yield(context, yieldVal);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.YieldInstr(this);
    }
}

