/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.MultipleAsgnBase;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class OptArgMultipleAsgnInstr
extends MultipleAsgnBase {
    private final int minArgsLength;

    public OptArgMultipleAsgnInstr(Variable result2, Operand array, int index2, int minArgsLength) {
        super(Operation.MASGN_OPT, result2, array, index2);
        this.minArgsLength = minArgsLength;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.array + "," + this.index + "," + this.minArgsLength + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new OptArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), this.array.cloneForInlining(ii), this.index, this.minArgsLength);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        RubyArray rubyArray = (RubyArray)this.array.retrieve(context, self, currDynScope, temp);
        int n = rubyArray.getLength();
        return this.minArgsLength <= n ? rubyArray.entry(this.index) : UndefinedValue.UNDEFINED;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.OptArgMultipleAsgnInstr(this);
    }
}

