/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class JittedMethod
extends DynamicMethod
implements MethodArgs,
PositionAware {
    private final StaticScope staticScope;
    private final Script jitCompiledScript;
    private final ISourcePosition position;
    private final Arity arity;
    private final DefaultMethod realMethod;

    public JittedMethod(RubyModule implementationClass, StaticScope staticScope, Script jitCompiledScript, String name2, CallConfiguration jitCallConfig, Visibility visibility, Arity arity2, ISourcePosition position, DefaultMethod realMethod) {
        super(implementationClass, visibility, jitCallConfig, name2);
        this.position = position;
        this.jitCompiledScript = jitCompiledScript;
        this.staticScope = staticScope;
        this.arity = arity2;
        this.realMethod = realMethod;
        int argCount = arity2.getValue();
        if (argCount < 0 || argCount > 3) {
            argCount = 4;
        }
        this.nativeCall = new DynamicMethod.NativeCall(jitCompiledScript.getClass(), "__file__", IRubyObject.class, StandardASMCompiler.getStaticMethodArgs(jitCompiledScript.getClass(), argCount), true);
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    public DynamicMethod getRealMethod() {
        return this.realMethod;
    }

    public Object getScriptObject() {
        return this.jitCompiledScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            this.pre(context, self, name2, block, args2.length);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, args2, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            this.pre(context, self, name2, Block.NULL_BLOCK, args2.length);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, args2, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            this.pre(context, self, name2, Block.NULL_BLOCK, 0);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            this.pre(context, self, name2, block, 0);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            this.pre(context, self, name2, Block.NULL_BLOCK, 1);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            this.pre(context, self, name2, block, 1);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            this.pre(context, self, name2, Block.NULL_BLOCK, 2);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            this.pre(context, self, name2, block, 2);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            this.pre(context, self, name2, Block.NULL_BLOCK, 3);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, arg2, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            this.pre(context, self, name2, block, 3);
            IRubyObject iRubyObject = this.jitCompiledScript.__file__(context, self, arg0, arg1, arg2, block);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            IRubyObject iRubyObject = this.handleReturn(context, rj, callNumber);
            return iRubyObject;
        }
        catch (JumpException.RedoJump rj) {
            IRubyObject iRubyObject = this.handleRedo(runtime);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = this.handleBreak(context, runtime, bj, callNumber);
            return iRubyObject;
        }
        finally {
            this.post(runtime, context, name2);
        }
    }

    protected void pre(ThreadContext context, IRubyObject self, String name2, Block block, int argsLength) {
        this.callConfig.pre(context, self, this.getImplementationClass(), name2, block, this.staticScope);
        this.getArity().checkArity(context.runtime, argsLength);
    }

    protected void post(Ruby runtime, ThreadContext context, String name2) {
        this.callConfig.post(context);
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    @Override
    public String getFile() {
        return this.position.getFile();
    }

    @Override
    public int getLine() {
        return this.position.getLine();
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    @Override
    public ArgsNode getArgsNode() {
        return this.realMethod.getArgsNode();
    }

    @Override
    public DynamicMethod dup() {
        return new JittedMethod(this.getImplementationClass(), this.staticScope, this.jitCompiledScript, this.name, this.callConfig, this.getVisibility(), this.arity, this.position, this.realMethod);
    }
}

