/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import java.util.ArrayList;
import org.jcodings.Encoding;
import org.joda.time.DateTime;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.zlib.JZlibRubyGzipReader;
import org.jruby.ext.zlib.JZlibRubyGzipWriter;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CharsetTranscoder;

@JRubyClass(name={"Zlib::GzipFile"})
public class RubyGzipFile
extends RubyObject {
    protected static final ObjectAllocator GZIPFILE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyGzipFile(runtime, klass);
        }
    };
    protected boolean closed = false;
    protected boolean finished = false;
    protected byte osCode = (byte)-1;
    protected int level = -1;
    protected RubyString nullFreeOrigName;
    protected RubyString nullFreeComment;
    protected IRubyObject realIo;
    protected RubyTime mtime;
    protected Encoding readEncoding;
    protected Encoding writeEncoding;
    protected boolean sync = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IRubyObject wrapBlock(ThreadContext context, RubyGzipFile instance, Block block) {
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, instance);
                return iRubyObject;
            }
            finally {
                if (!instance.isClosed()) {
                    instance.close();
                }
            }
        }
        return instance;
    }

    static IRubyObject[] argsWithIo(IRubyObject io2, IRubyObject[] args2) {
        ArrayList<IRubyObject> newArgs = new ArrayList<IRubyObject>();
        newArgs.add(io2);
        for (IRubyObject arg2 : args2) {
            if (arg2 == null) break;
            newArgs.add(arg2);
        }
        return newArgs.toArray(new IRubyObject[0]);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject wrap(ThreadContext context, IRubyObject recv2, IRubyObject io2, Block block) {
        Ruby runtime = recv2.getRuntime();
        RubyGzipFile instance = recv2 == runtime.getModule("Zlib").getClass("GzipWriter") ? JZlibRubyGzipWriter.newInstance(recv2, new IRubyObject[]{io2}, block) : JZlibRubyGzipReader.newInstance(recv2, new IRubyObject[]{io2}, block);
        return RubyGzipFile.wrapBlock(context, instance, block);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static RubyGzipFile newInstance(IRubyObject recv2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        RubyGzipFile result2 = (RubyGzipFile)klass.allocate();
        result2.callInit(new IRubyObject[0], block);
        return result2;
    }

    public RubyGzipFile(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
        this.mtime = RubyTime.newTime(runtime, new DateTime());
        this.readEncoding = null;
        this.writeEncoding = null;
    }

    protected RubyString newStr(Ruby runtime, ByteList value2) {
        if (runtime.is1_9()) {
            if (this.writeEncoding == null) {
                Encoding encoding2 = this.readEncoding == null ? runtime.getEncodingService().getAscii8bitEncoding() : this.readEncoding;
                return RubyString.newString(runtime, value2, encoding2);
            }
            return RubyString.newStringNoCopy(runtime, CharsetTranscoder.transcode(runtime.getCurrentContext(), value2, this.readEncoding, this.writeEncoding, runtime.getNil()));
        }
        return RubyString.newString(runtime, value2);
    }

    @JRubyMethod(name={"os_code"})
    public IRubyObject os_code() {
        return this.getRuntime().newFixnum(this.osCode & 0xFF);
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        return this.closed ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    protected boolean isClosed() {
        return this.closed;
    }

    @JRubyMethod(name={"orig_name"})
    public IRubyObject orig_name() {
        if (this.closed) {
            throw RubyZlib.newGzipFileError(this.getRuntime(), "closed gzip stream");
        }
        return this.nullFreeOrigName == null ? this.getRuntime().getNil() : this.nullFreeOrigName;
    }

    @JRubyMethod(name={"to_io"})
    public IRubyObject to_io() {
        return this.realIo;
    }

    @JRubyMethod(name={"comment"})
    public IRubyObject comment() {
        if (this.closed) {
            throw RubyZlib.newGzipFileError(this.getRuntime(), "closed gzip stream");
        }
        return this.nullFreeComment == null ? this.getRuntime().getNil() : this.nullFreeComment;
    }

    @JRubyMethod(name={"crc"})
    public IRubyObject crc() {
        return this.getRuntime().newFixnum(0);
    }

    @JRubyMethod(name={"mtime"})
    public IRubyObject mtime() {
        return this.mtime;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync() {
        return this.sync ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"finish"})
    public IRubyObject finish() {
        if (!this.finished) {
            // empty if block
        }
        this.finished = true;
        return this.realIo;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        return null;
    }

    @JRubyMethod(name={"level"})
    public IRubyObject level() {
        return this.getRuntime().newFixnum(this.level);
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject set_sync(IRubyObject arg2) {
        this.sync = ((RubyBoolean)arg2).isTrue();
        return this.sync ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyClass(name={"Zlib::GzipFile::LengthError"}, parent="Zlib::GzipFile::Error")
    public static class LengthError
    extends Error {
    }

    @JRubyClass(name={"Zlib::GzipFile::NoFooter"}, parent="Zlib::GzipFile::Error")
    public static class NoFooter
    extends Error {
    }

    @JRubyClass(name={"Zlib::GzipFile::CRCError"}, parent="Zlib::GzipFile::Error")
    public static class CRCError
    extends Error {
    }

    @JRubyClass(name={"Zlib::GzipFile::Error"}, parent="Zlib::Error")
    public static class Error {
    }
}

