/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.OpenFile;

public class IOModule {
    public static void createIOModule(Ruby runtime, RubyModule ffi2) {
        RubyModule module = ffi2.defineModuleUnder("IO");
        module.defineAnnotatedMethods(IOModule.class);
    }

    @JRubyMethod(name={"native_read"}, module=true)
    public static final IRubyObject native_read(ThreadContext context, IRubyObject self, IRubyObject src, IRubyObject dst, IRubyObject rbLength) {
        if (!(src instanceof RubyIO)) {
            throw context.runtime.newTypeError("wrong argument (expected IO)");
        }
        if (!(dst instanceof AbstractMemory)) {
            throw context.runtime.newTypeError("wrong argument (expected FFI memory)");
        }
        Ruby runtime = context.runtime;
        try {
            OpenFile openFile = ((RubyIO)src).getOpenFile();
            openFile.checkClosed(runtime);
            openFile.checkReadable(runtime);
            ChannelStream stream = (ChannelStream)openFile.getMainStreamSafe();
            ByteBuffer buffer = ((AbstractMemory)dst).getMemoryIO().asByteBuffer();
            int count2 = RubyNumeric.num2int(rbLength);
            if (count2 > buffer.remaining()) {
                throw runtime.newIndexError("read count too big for output buffer");
            }
            if (count2 < buffer.remaining()) {
                buffer = buffer.duplicate();
                buffer.limit(count2);
            }
            return runtime.newFixnum(stream.read(buffer));
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        catch (EOFException e) {
            return runtime.newFixnum(-1);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }
}

