/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DataConverter {
    public static RubyModule createDataConverterModule(Ruby runtime, RubyModule module) {
        RubyModule result2 = module.defineModuleUnder("DataConverter");
        result2.defineAnnotatedMethods(DataConverter.class);
        result2.defineAnnotatedConstants(DataConverter.class);
        return result2;
    }

    private static RubyModule module(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw obj.getRuntime().newTypeError("not a module");
        }
        return (RubyModule)obj;
    }

    @JRubyMethod(name={"native_type"}, module=true, optional=1)
    public static IRubyObject native_type(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        RubyModule m = DataConverter.module(self);
        if (args2.length == 0) {
            if (!m.hasInternalVariable("native_type")) {
                throw context.runtime.newNotImplementedError("native_type method not overridden and no native_type set");
            }
            return (Type)m.getInternalVariable("native_type");
        }
        if (args2.length == 1) {
            Type type2 = Util.findType(context, args2[0]);
            m.setInternalVariable("native_type", type2);
            return type2;
        }
        throw context.runtime.newArgumentError("incorrect arguments");
    }

    @JRubyMethod(name={"to_native"}, module=true)
    public static IRubyObject to_native(ThreadContext context, IRubyObject self, IRubyObject value2, IRubyObject ctx) {
        return value2;
    }

    @JRubyMethod(name={"from_native"}, module=true)
    public static IRubyObject from_native(ThreadContext context, IRubyObject self, IRubyObject value2, IRubyObject ctx) {
        return value2;
    }

    @JRubyMethod(name={"reference_required?"}, module=true)
    public static IRubyObject reference_required_p(ThreadContext context, IRubyObject self) {
        Object ref = DataConverter.module(self).getInternalVariable("reference_required");
        return context.runtime.newBoolean(!(ref instanceof IRubyObject) || ((IRubyObject)ref).isTrue());
    }

    @JRubyMethod(name={"reference_required"}, module=true, optional=1)
    public static IRubyObject reference_required(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        DataConverter.module(self).setInternalVariable("reference_required", context.runtime.newBoolean(args2.length < 1 || args2[0].isTrue()));
        return self;
    }
}

