/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.SplatNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class MultipleAsgnNode
extends AssignableNode {
    private final ListNode pre;
    private final Node rest;

    public MultipleAsgnNode(ISourcePosition position, ListNode pre, Node rest2) {
        super(position);
        this.pre = pre;
        this.rest = rest2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MULTIPLEASGNNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public ListNode getHeadNode() {
        return this.pre;
    }

    public ListNode getPre() {
        return this.pre;
    }

    public int getPreCount() {
        return this.pre == null ? 0 : this.pre.size();
    }

    public Node getArgsNode() {
        return this.rest;
    }

    public Node getRest() {
        return this.rest;
    }

    @Override
    public Arity getArity() {
        if (this.rest != null) {
            return Arity.required(this.pre == null ? 0 : this.pre.size());
        }
        return Arity.fixed(this.pre.size());
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.pre, this.rest, this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        switch (this.getValueNode().getNodeType()) {
            case ARRAYNODE: {
                ArrayNode iVisited2 = (ArrayNode)this.getValueNode();
                return ASTInterpreter.multipleAsgnArrayNode(runtime, context, this, iVisited2, self, aBlock);
            }
            case SPLATNODE: {
                SplatNode splatNode = (SplatNode)this.getValueNode();
                RubyArray rubyArray = (RubyArray)splatNode.interpret(runtime, context, self, aBlock);
                return AssignmentVisitor.multiAssign(runtime, context, self, this, rubyArray, false);
            }
        }
        IRubyObject value2 = this.getValueNode().interpret(runtime, context, self, aBlock);
        if (!(value2 instanceof RubyArray)) {
            value2 = RubyArray.newArray(runtime, value2);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, this, (RubyArray)value2, false);
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value2, Block block, boolean checkArity) {
        if (!(value2 instanceof RubyArray)) {
            value2 = ArgsUtil.convertToRubyArray(runtime, value2, this.pre != null);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, this, (RubyArray)value2, checkArity);
    }
}

