/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import jnr.posix.FileStat;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.JarFileStat;
import org.jruby.util.ResourceException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ModeFlags;

public class URLResource
implements FileResource {
    public static String URI = "uri:";
    public static String CLASSLOADER = "classloader:/";
    public static String URI_CLASSLOADER = URI + CLASSLOADER;
    private final String uri;
    private final String[] list;
    private final URL url;
    private final String pathname;
    private final JarFileStat fileStat;

    URLResource(String uri, URL url, String[] files) {
        this(uri, url, null, files);
    }

    URLResource(String uri, String pathname2, String[] files) {
        this(uri, null, pathname2, files);
    }

    private URLResource(String uri, URL url, String pathname2, String[] files) {
        this.uri = uri;
        this.list = files;
        this.url = url;
        this.pathname = pathname2;
        this.fileStat = new JarFileStat(this);
    }

    @Override
    public String absolutePath() {
        return this.uri;
    }

    @Override
    public String canonicalPath() {
        return this.uri;
    }

    @Override
    public boolean exists() {
        return this.url != null || this.pathname != null || this.list != null;
    }

    @Override
    public boolean isDirectory() {
        return this.list != null;
    }

    @Override
    public boolean isFile() {
        return this.list == null && (this.url != null || this.pathname != null);
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public String[] list() {
        return this.list;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public FileStat stat() {
        return this.fileStat;
    }

    @Override
    public FileStat lstat() {
        return this.stat();
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        new RuntimeException().printStackTrace();
        return null;
    }

    @Override
    public InputStream openInputStream() {
        try {
            if (this.pathname != null) {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(this.pathname);
            }
            return this.url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ChannelDescriptor openDescriptor(ModeFlags flags, int perm) throws ResourceException {
        return new ChannelDescriptor(this.openInputStream(), flags);
    }

    public static FileResource createClassloaderURI(String pathname2) {
        InputStream is;
        if (pathname2.startsWith("/")) {
            pathname2 = pathname2.substring(1);
        }
        if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(pathname2)) != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String[] files = URLResource.listClassLoaderFiles(pathname2);
        return new URLResource(URI_CLASSLOADER + pathname2, is == null ? null : pathname2, files);
    }

    public static FileResource create(String pathname2) {
        if (!pathname2.startsWith(URI)) {
            return null;
        }
        if ((pathname2 = pathname2.substring(URI.length())).startsWith(CLASSLOADER)) {
            return URLResource.createClassloaderURI(pathname2.substring(CLASSLOADER.length()));
        }
        return URLResource.createRegularURI(pathname2);
    }

    private static FileResource createRegularURI(String pathname2) {
        URL url;
        try {
            pathname2 = pathname2.replaceFirst(":/([^/])", "://$1");
            url = new URL(pathname2);
            if (url.getProtocol().startsWith("http")) {
                return null;
            }
        }
        catch (MalformedURLException e) {
            return new URLResource(URI + pathname2, (URL)null, null);
        }
        String[] files = URLResource.listFiles(pathname2);
        if (files != null) {
            return new URLResource(URI + pathname2, (URL)null, files);
        }
        try {
            url.openStream().close();
            return new URLResource(URI + pathname2, url, null);
        }
        catch (IOException e) {
            return new URLResource(URI + pathname2, (URL)null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] listFilesFromInputStream(InputStream is) {
        BufferedReader reader = null;
        try {
            LinkedList<String> files = new LinkedList<String>();
            reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                files.add(line);
                line = reader.readLine();
            }
            String[] stringArray = files.toArray(new String[files.size()]);
            return stringArray;
        }
        catch (IOException e) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private static String[] listClassLoaderFiles(String pathname2) {
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(pathname2 + "/.jrubydir");
            if (!urls.hasMoreElements()) {
                return null;
            }
            LinkedHashSet<String> result2 = new LinkedHashSet<String>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                for (String entry : URLResource.listFilesFromInputStream(url.openStream())) {
                    if (result2.contains(entry)) continue;
                    result2.add(entry);
                }
            }
            return result2.toArray(new String[result2.size()]);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String[] listFiles(String pathname2) {
        try {
            return URLResource.listFilesFromInputStream(new URL(pathname2.replace("file://", "file:/") + "/.jrubydir").openStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL getResourceURL(String location) {
        if (location.startsWith(URI + CLASSLOADER)) {
            return Thread.currentThread().getContextClassLoader().getResource(location.substring(URI_CLASSLOADER.length()));
        }
        try {
            return new URL(location.replaceFirst("^" + URI, ""));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("BUG in " + URLResource.class);
        }
    }
}

