/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.JRubyNonExistentFile;
import org.jruby.util.JarDirectoryResource;
import org.jruby.util.JarFileResource;
import org.jruby.util.JarFileStat;

public abstract class JarResource
implements FileResource {
    private static Pattern PREFIX_MATCH = Pattern.compile("^(?:jar:)?(?:file:)?(.*)$");
    protected final JarFile jar;
    private final JarFileStat fileStat;

    public static JarResource create(String pathname2) {
        JarResource resource2;
        JarFile jar;
        Matcher matcher = PREFIX_MATCH.matcher(pathname2);
        String sanitized = matcher.matches() ? matcher.group(1) : pathname2;
        int bang = sanitized.indexOf(33);
        if (bang < 0) {
            return null;
        }
        try {
            jar = new JarFile(sanitized.substring(0, bang));
        }
        catch (IOException e) {
            return null;
        }
        String slashPath = sanitized.substring(bang + 1);
        if (!slashPath.startsWith("/")) {
            slashPath = "/" + slashPath;
        }
        if ((resource2 = JarResource.createJarResource(jar, slashPath)) == null) {
            resource2 = JarResource.createJarResource(jar, slashPath.substring(1));
        }
        return resource2;
    }

    private static JarResource createJarResource(JarFile jar, String path2) {
        JarResource resource2 = JarDirectoryResource.create(jar, path2);
        if (resource2 == null) {
            resource2 = JarFileResource.create(jar, path2);
        }
        return resource2;
    }

    protected JarResource(JarFile jar) {
        this.jar = jar;
        this.fileStat = new JarFileStat(this);
    }

    @Override
    public String absolutePath() {
        return this.jar.getName() + "!" + this.entryName();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public FileStat stat(POSIX posix) {
        return this.fileStat;
    }

    @Override
    public FileStat lstat(POSIX posix) {
        return this.stat(posix);
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        return JRubyNonExistentFile.NOT_EXIST;
    }

    protected abstract String entryName();
}

