/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.exceptions.MainExitException;
import org.jruby.runtime.profile.ProfileOutput;
import org.jruby.util.JRubyFile;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.OutputStrings;

public class ArgumentProcessor {
    private List<Argument> arguments;
    private int argumentIndex = 0;
    private boolean processArgv;
    RubyInstanceConfig config;
    private boolean endOfArguments = false;
    private int characterIndex = 0;

    public ArgumentProcessor(String[] arguments, RubyInstanceConfig config) {
        this(arguments, true, false, config);
    }

    public ArgumentProcessor(String[] arguments, boolean processArgv, boolean dashed, RubyInstanceConfig config) {
        this.config = config;
        this.arguments = new ArrayList<Argument>();
        if (arguments != null && arguments.length > 0) {
            for (String argument : arguments) {
                this.arguments.add(new Argument(argument, dashed));
            }
        }
        this.processArgv = processArgv;
    }

    public void processArguments() {
        this.processArguments(true);
    }

    public void processArguments(boolean inline) {
        while (this.argumentIndex < this.arguments.size() && this.isInterpreterArgument(this.arguments.get((int)this.argumentIndex).originalValue)) {
            this.processArgument();
            ++this.argumentIndex;
        }
        if (inline && !this.config.isInlineScript() && this.config.getScriptFileName() == null && this.argumentIndex < this.arguments.size()) {
            this.config.setScriptFileName(this.arguments.get((int)this.argumentIndex).originalValue);
            ++this.argumentIndex;
        }
        if (this.processArgv) {
            this.processArgv();
        }
    }

    private void processArgv() {
        ArrayList<String> arglist = new ArrayList<String>();
        while (this.argumentIndex < this.arguments.size()) {
            String arg2 = this.arguments.get((int)this.argumentIndex).originalValue;
            if (this.config.isArgvGlobalsOn() && arg2.startsWith("-")) {
                if ((arg2 = arg2.substring(1)).indexOf(61) > 0) {
                    String[] keyvalue = arg2.split("=", 2);
                    String globalName = keyvalue[0].replaceAll("-", "_");
                    this.config.getOptionGlobals().put(globalName, keyvalue[1]);
                } else {
                    this.config.getOptionGlobals().put(arg2, null);
                }
            } else {
                this.config.setArgvGlobalsOn(false);
                arglist.add(arg2);
            }
            ++this.argumentIndex;
        }
        arglist.addAll(Arrays.asList(this.config.getArgv()));
        this.config.setArgv(arglist.toArray(new String[arglist.size()]));
    }

    private boolean isInterpreterArgument(String argument) {
        return argument.length() > 0 && (argument.charAt(0) == '-' || argument.charAt(0) == '+') && !this.endOfArguments;
    }

    private String getArgumentError(String additionalError) {
        return "jruby: invalid argument\n" + additionalError + "\n";
    }

    private void processArgument() {
        String argument = this.arguments.get((int)this.argumentIndex).dashedValue;
        this.characterIndex = 1;
        block41: while (this.characterIndex < argument.length()) {
            switch (argument.charAt(this.characterIndex)) {
                case '0': {
                    String temp = this.grabOptionalValue();
                    if (null == temp) {
                        this.config.setRecordSeparator("\u0000");
                        break block41;
                    }
                    if (temp.equals("0")) {
                        this.config.setRecordSeparator("\n\n");
                        break block41;
                    }
                    if (temp.equals("777")) {
                        this.config.setRecordSeparator("\uffff");
                        break block41;
                    }
                    try {
                        int val = Integer.parseInt(temp, 8);
                        this.config.setRecordSeparator("" + (char)val);
                        break block41;
                    }
                    catch (Exception e) {
                        MainExitException mee = new MainExitException(1, this.getArgumentError(" -0 must be followed by either 0, 777, or a valid octal value"));
                        mee.setUsageError(true);
                        throw mee;
                    }
                }
                case 'a': {
                    this.config.setSplit(true);
                    break;
                }
                case 'c': {
                    this.config.setShouldCheckSyntax(true);
                    break;
                }
                case 'C': {
                    try {
                        String saved = this.grabValue(this.getArgumentError(" -C must be followed by a directory expression"));
                        File base = new File(this.config.getCurrentDirectory());
                        File newDir = new File(saved);
                        if (newDir.isAbsolute()) {
                            this.config.setCurrentDirectory(newDir.getCanonicalPath());
                        } else {
                            this.config.setCurrentDirectory(new File(base, newDir.getPath()).getCanonicalPath());
                        }
                        if (!new File(this.config.getCurrentDirectory()).isDirectory()) {
                            MainExitException mee = new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                            throw mee;
                        }
                        break block41;
                    }
                    catch (IOException e) {
                        MainExitException mee = new MainExitException(1, this.getArgumentError(" -C must be followed by a valid directory"));
                        throw mee;
                    }
                }
                case 'd': {
                    this.config.setDebug(true);
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    break;
                }
                case 'e': {
                    this.config.getInlineScript().append(this.grabValue(this.getArgumentError(" -e must be followed by an expression to evaluate")));
                    this.config.getInlineScript().append('\n');
                    this.config.setHasInlineScript(true);
                    break block41;
                }
                case 'E': {
                    this.processEncodingOption(this.grabValue(this.getArgumentError("unknown encoding name")));
                    break block41;
                }
                case 'F': {
                    this.config.setInputFieldSeparator(this.grabValue(this.getArgumentError(" -F must be followed by a pattern for input field separation")));
                    break block41;
                }
                case 'h': {
                    this.config.setShouldPrintUsage(true);
                    this.config.setShouldRunInterpreter(false);
                    break;
                }
                case 'i': {
                    this.config.setInPlaceBackupExtension(this.grabOptionalValue());
                    if (this.config.getInPlaceBackupExtension() != null) break block41;
                    this.config.setInPlaceBackupExtension("");
                    break block41;
                }
                case 'I': {
                    String s2 = this.grabValue(this.getArgumentError("-I must be followed by a directory name to add to lib path"));
                    String[] ls = s2.split(File.pathSeparator);
                    this.config.getLoadPaths().addAll(Arrays.asList(ls));
                    break block41;
                }
                case 'J': {
                    this.grabOptionalValue();
                    this.config.getError().println("warning: " + argument + " argument ignored (launched in same VM?)");
                    break block41;
                }
                case 'K': {
                    String eArg = this.grabValue(this.getArgumentError("provide a value for -K"));
                    this.config.setKCode(KCode.create(null, eArg));
                    this.config.setSourceEncoding(this.config.getKCode().getEncoding().toString());
                    if (this.config.getExternalEncoding() != null) break;
                    this.config.setExternalEncoding(this.config.getKCode().getEncoding().toString());
                    break;
                }
                case 'l': {
                    this.config.setProcessLineEnds(true);
                    break;
                }
                case 'n': {
                    this.config.setAssumeLoop(true);
                    this.config.setKernelGsubDefined(true);
                    break;
                }
                case 'p': {
                    this.config.setAssumePrinting(true);
                    this.config.setAssumeLoop(true);
                    this.config.setKernelGsubDefined(true);
                    break;
                }
                case 'r': {
                    this.config.getRequiredLibraries().add(this.grabValue(this.getArgumentError("-r must be followed by a package to require")));
                    break block41;
                }
                case 's': {
                    this.config.setArgvGlobalsOn(true);
                    break;
                }
                case 'G': {
                    this.config.setLoadGemfile(true);
                    break;
                }
                case 'S': {
                    this.runBinScript();
                    break block41;
                }
                case 'T': {
                    String temp = this.grabOptionalValue();
                    break block41;
                }
                case 'U': {
                    this.config.setInternalEncoding("UTF-8");
                    break;
                }
                case 'v': {
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    this.config.setShowVersion(true);
                    break;
                }
                case 'w': {
                    this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                    break;
                }
                case 'W': {
                    String temp = this.grabOptionalValue();
                    if (temp == null) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        break block41;
                    }
                    if (temp.equals("0")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.NIL);
                        break block41;
                    }
                    if (temp.equals("1")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.FALSE);
                        break block41;
                    }
                    if (temp.equals("2")) {
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        break block41;
                    }
                    MainExitException mee = new MainExitException(1, this.getArgumentError(" -W must be followed by either 0, 1, 2 or nothing"));
                    mee.setUsageError(true);
                    throw mee;
                }
                case 'x': {
                    MainExitException mee;
                    try {
                        String saved = this.grabOptionalValue();
                        if (saved != null) {
                            File base = new File(this.config.getCurrentDirectory());
                            File newDir = new File(saved);
                            if (newDir.isAbsolute()) {
                                this.config.setCurrentDirectory(newDir.getCanonicalPath());
                            } else {
                                this.config.setCurrentDirectory(new File(base, newDir.getPath()).getCanonicalPath());
                            }
                            if (!new File(this.config.getCurrentDirectory()).isDirectory()) {
                                MainExitException mee2 = new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                                throw mee2;
                            }
                        }
                        this.config.setXFlag(true);
                        break block41;
                    }
                    catch (IOException e) {
                        mee = new MainExitException(1, this.getArgumentError(" -x must be followed by a valid directory"));
                        throw mee;
                    }
                }
                case 'X': {
                    String extendedOption = this.grabOptionalValue();
                    if (extendedOption == null) {
                        if (SafePropertyAccessor.getBoolean("jruby.launcher.nopreamble", false)) {
                            throw new MainExitException(0, OutputStrings.getExtendedHelp());
                        }
                        throw new MainExitException(0, "jruby: missing argument\n" + OutputStrings.getExtendedHelp());
                    }
                    if (extendedOption.equals("-O")) {
                        this.config.setObjectSpaceEnabled(false);
                        break block41;
                    }
                    if (extendedOption.equals("+O")) {
                        this.config.setObjectSpaceEnabled(true);
                        break block41;
                    }
                    if (extendedOption.equals("-C")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        break block41;
                    }
                    if (extendedOption.equals("-CIR")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFFIR);
                        break block41;
                    }
                    if (extendedOption.equals("+C")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
                        break block41;
                    }
                    if (extendedOption.equals("+CIR")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.FORCEIR);
                        break block41;
                    }
                    MainExitException mee = new MainExitException(1, "jruby: invalid extended option " + extendedOption + " (-X will list valid options)\n");
                    mee.setUsageError(true);
                    throw mee;
                }
                case 'y': {
                    this.config.setParserDebug(true);
                    break block41;
                }
                case '-': {
                    if (argument.equals("--command") || argument.equals("--bin")) {
                        this.characterIndex = argument.length();
                        this.runBinScript();
                        break;
                    }
                    if (argument.equals("--compat")) {
                        this.characterIndex = argument.length();
                        this.config.setCompatVersion(CompatVersion.getVersionFromString(this.grabValue(this.getArgumentError("--compat must be RUBY1_8 or RUBY1_9"))));
                        break block41;
                    }
                    if (argument.equals("--copyright")) {
                        this.config.setShowCopyright(true);
                        this.config.setShouldRunInterpreter(false);
                        break block41;
                    }
                    if (argument.equals("--debug")) {
                        RubyInstanceConfig.FULL_TRACE_ENABLED = true;
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
                        break block41;
                    }
                    if (argument.equals("--jdb")) {
                        this.config.setDebug(true);
                        this.config.setVerbosity(RubyInstanceConfig.Verbosity.TRUE);
                        break;
                    }
                    if (argument.equals("--help")) {
                        this.config.setShouldPrintUsage(true);
                        this.config.setShouldRunInterpreter(false);
                        break;
                    }
                    if (argument.equals("--properties")) {
                        this.config.setShouldPrintProperties(true);
                        this.config.setShouldRunInterpreter(false);
                        break;
                    }
                    if (argument.equals("--version")) {
                        this.config.setShowVersion(true);
                        this.config.setShouldRunInterpreter(false);
                        break block41;
                    }
                    if (argument.equals("--bytecode")) {
                        this.config.setShowBytecode(true);
                        break block41;
                    }
                    if (argument.equals("--fast")) {
                        this.config.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
                        break block41;
                    }
                    if (argument.startsWith("--profile")) {
                        this.characterIndex = argument.length();
                        int dotIndex = argument.indexOf(".");
                        if (dotIndex == -1) {
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.FLAT);
                            break block41;
                        }
                        String profilingMode = argument.substring(dotIndex + 1, argument.length());
                        if (profilingMode.equals("out")) {
                            String outputFile = this.grabValue(this.getArgumentError("--profile.out requires an output file argument"));
                            try {
                                this.config.setProfileOutput(new ProfileOutput(new File(outputFile)));
                                break block41;
                            }
                            catch (FileNotFoundException e) {
                                throw new MainExitException(1, String.format("jruby: %s", e.getMessage()));
                            }
                        }
                        try {
                            this.config.setProfilingMode(RubyInstanceConfig.ProfilingMode.valueOf(profilingMode.toUpperCase()));
                            break block41;
                        }
                        catch (IllegalArgumentException e) {
                            throw new MainExitException(1, String.format("jruby: unknown profiler mode \"%s\"", profilingMode));
                        }
                    }
                    if (argument.equals("--1.9")) {
                        this.config.setCompatVersion(CompatVersion.RUBY1_9);
                        break block41;
                    }
                    if (argument.equals("--2.0")) {
                        this.config.setCompatVersion(CompatVersion.RUBY2_0);
                        break block41;
                    }
                    if (argument.equals("--1.8")) {
                        this.config.setCompatVersion(CompatVersion.RUBY1_8);
                        break block41;
                    }
                    if (argument.equals("--disable-gems")) {
                        this.config.setDisableGems(true);
                        break block41;
                    }
                    if (argument.equals("--gemfile")) {
                        this.config.setLoadGemfile(true);
                        break block41;
                    }
                    if (argument.equals("--dump")) {
                        this.characterIndex = argument.length();
                        String error2 = "--dump only supports [version, copyright, usage, yydebug, syntax, insns] on JRuby";
                        String dumpArg = this.grabValue(this.getArgumentError(error2));
                        if (dumpArg.equals("version")) {
                            this.config.setShowVersion(true);
                            this.config.setShouldRunInterpreter(false);
                            break block41;
                        }
                        if (dumpArg.equals("copyright")) {
                            this.config.setShowCopyright(true);
                            this.config.setShouldRunInterpreter(false);
                            break block41;
                        }
                        if (dumpArg.equals("usage")) {
                            this.config.setShouldPrintUsage(true);
                            this.config.setShouldRunInterpreter(false);
                            break block41;
                        }
                        if (dumpArg.equals("yydebug")) {
                            this.config.setParserDebug(true);
                            break block41;
                        }
                        if (dumpArg.equals("syntax")) {
                            this.config.setShouldCheckSyntax(true);
                            break;
                        }
                        if (dumpArg.equals("insns")) {
                            this.config.setShowBytecode(true);
                            break;
                        }
                        MainExitException mee = new MainExitException(1, error2);
                        mee.setUsageError(true);
                        throw mee;
                    }
                    if (argument.equals("--")) {
                        this.endOfArguments = true;
                        break;
                    }
                }
                default: {
                    throw new MainExitException(1, "jruby: unknown option " + argument);
                }
            }
            ++this.characterIndex;
        }
    }

    private void processEncodingOption(String value2) {
        String[] encodings = value2.split(":", 3);
        switch (encodings.length) {
            case 3: {
                throw new MainExitException(1, "extra argument for -E: " + encodings[2]);
            }
            case 2: {
                this.config.setInternalEncoding(encodings[1]);
            }
            case 1: {
                this.config.setExternalEncoding(encodings[0]);
            }
        }
    }

    private void runBinScript() {
        String scriptName = this.grabValue("jruby: provide a bin script to execute");
        if (scriptName.equals("irb")) {
            scriptName = "jirb";
        }
        this.config.setScriptFileName(this.resolveScript(scriptName));
        if (this.config.getScriptFileName() == null) {
            this.config.setScriptFileName(scriptName);
            this.config.getRequiredLibraries().add("jruby/commands");
            this.config.getInlineScript().append("JRuby::Commands.").append(scriptName);
            this.config.getInlineScript().append("\n");
            this.config.setHasInlineScript(true);
        }
        this.endOfArguments = true;
    }

    private String resolveScript(String scriptName) {
        JRubyFile fullName = null;
        try {
            fullName = JRubyFile.create(this.config.getCurrentDirectory(), scriptName);
            if (((File)fullName).exists() && ((File)fullName).isFile()) {
                if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
                    this.config.getError().println("Found: " + ((File)fullName).getAbsolutePath());
                }
                return scriptName;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            fullName = JRubyFile.create(this.config.getJRubyHome(), "bin/" + scriptName);
            if (((File)fullName).exists() && ((File)fullName).isFile()) {
                if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
                    this.config.getError().println("Found: " + ((File)fullName).getAbsolutePath());
                }
                return ((File)fullName).getAbsolutePath();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Ruby.getClassLoader().getResourceAsStream("bin/" + scriptName) != null) {
            return "classpath:bin/" + scriptName;
        }
        try {
            Object pathObj = this.config.getEnvironment().get("PATH");
            String path2 = pathObj.toString();
            if (path2 != null) {
                String[] paths = path2.split(System.getProperty("path.separator"));
                for (int i2 = 0; i2 < paths.length; ++i2) {
                    fullName = JRubyFile.create(new File(paths[i2]).getAbsolutePath(), scriptName);
                    if (!((File)fullName).exists() || !((File)fullName).isFile()) continue;
                    if (RubyInstanceConfig.DEBUG_SCRIPT_RESOLUTION) {
                        this.config.getError().println("Found: " + ((File)fullName).getAbsolutePath());
                    }
                    return ((File)fullName).getAbsolutePath();
                }
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (this.config.isDebug()) {
            this.config.getError().println("warning: could not resolve -S script on filesystem: " + scriptName);
        }
        return null;
    }

    private String grabValue(String errorMessage) {
        String optValue = this.grabOptionalValue();
        if (optValue != null) {
            return optValue;
        }
        ++this.argumentIndex;
        if (this.argumentIndex < this.arguments.size()) {
            return this.arguments.get((int)this.argumentIndex).originalValue;
        }
        MainExitException mee = new MainExitException(1, errorMessage);
        mee.setUsageError(true);
        throw mee;
    }

    private String grabOptionalValue() {
        ++this.characterIndex;
        String argValue = this.arguments.get((int)this.argumentIndex).originalValue;
        if (this.characterIndex < argValue.length()) {
            return argValue.substring(this.characterIndex);
        }
        return null;
    }

    private final class Argument {
        public final String originalValue;
        public final String dashedValue;

        public Argument(String value2, boolean dashed) {
            this.originalValue = value2;
            this.dashedValue = dashed && !value2.startsWith("-") ? "-" + value2 : value2;
        }

        public String toString() {
            return this.dashedValue;
        }
    }
}

