/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jruby.CompatVersion;
import org.jruby.IncludedModuleWrapper;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyMethod;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.AnnotationHelper;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.anno.TypePopulator;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.compiler.ASTInspector;
import org.jruby.embed.Extension;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.AttrReaderMethod;
import org.jruby.internal.runtime.methods.AttrWriterMethod;
import org.jruby.internal.runtime.methods.CacheableMethod;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.FullFunctionCallbackMethod;
import org.jruby.internal.runtime.methods.InterpretedMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.internal.runtime.methods.ProfilingDynamicMethod;
import org.jruby.internal.runtime.methods.SimpleCallbackMethod;
import org.jruby.internal.runtime.methods.SynchronizedDynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.ivars.MethodData;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ClassProvider;
import org.jruby.util.IdUtil;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.WeakHashSet;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Module"})
public class RubyModule
extends RubyObject {
    private static final Logger LOG;
    private static final boolean DEBUG = false;
    protected static final String ERR_INSECURE_SET_CONSTANT = "Insecure: can't modify constant";
    protected static final String ERR_FROZEN_CONST_TYPE = "class/module ";
    public static final Set<String> SCOPE_CAPTURING_METHODS;
    public static final ObjectAllocator MODULE_ALLOCATOR;
    protected static final CacheEntryFactory NormalCacheEntryFactory;
    private volatile CacheEntryFactory cacheEntryFactory;
    protected static final String ERR_INSECURE_SET_CLASS_VAR = "Insecure: can't modify class variable";
    protected static final String ERR_FROZEN_CVAR_TYPE = "class/module ";
    public KindOf kindOf = KindOf.DEFAULT_KIND_OF;
    public final int id;
    public RubyModule parent;
    protected String baseName;
    private String anonymousName;
    private String cachedName;
    private volatile Map<String, ConstantEntry> constants = Collections.EMPTY_MAP;
    private volatile Map<String, Autoload> autoloads = Collections.EMPTY_MAP;
    private volatile Map<String, DynamicMethod> methods = Collections.EMPTY_MAP;
    protected Map<String, CacheEntry> cachedMethods = Collections.EMPTY_MAP;
    protected int generation;
    protected Integer generationObject;
    protected volatile Set<RubyClass> includingHierarchies = Collections.EMPTY_SET;
    private volatile transient Set<ClassProvider> classProviders = Collections.EMPTY_SET;
    protected RubyClass superClass;
    public int index;
    private volatile Map<String, IRubyObject> classVariables = Collections.EMPTY_MAP;
    private static final AtomicReferenceFieldUpdater CLASSVARS_UPDATER;
    protected final Invalidator methodInvalidator;
    private boolean javaProxy = false;

    public static RubyClass createModuleClass(Ruby runtime, RubyClass moduleClass) {
        moduleClass.index = 12;
        moduleClass.setReifiedClass(RubyModule.class);
        moduleClass.kindOf = new JavaClassKindOf(RubyModule.class);
        moduleClass.defineAnnotatedMethods(RubyModule.class);
        moduleClass.defineAnnotatedMethods(ModuleKernelMethods.class);
        return moduleClass;
    }

    public void checkValidBindTargetFrom(ThreadContext context, RubyModule originModule) throws RaiseException {
        if (!this.hasModuleInHierarchy(originModule)) {
            if (originModule instanceof MetaClass) {
                throw context.runtime.newTypeError("can't bind singleton method to a different class");
            }
            throw context.runtime.newTypeError("bind argument must be an instance of " + originModule.getName());
        }
    }

    @Override
    public int getNativeTypeIndex() {
        return 12;
    }

    @Override
    public boolean isModule() {
        return true;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isInstance(IRubyObject object) {
        return this.kindOf.isKindOf(object, this);
    }

    public Map<String, ConstantEntry> getConstantMap() {
        return this.constants;
    }

    public synchronized Map<String, ConstantEntry> getConstantMapForWrite() {
        return this.constants == Collections.EMPTY_MAP ? (this.constants = new ConcurrentHashMap<String, ConstantEntry>(4, 0.9f, 1)) : this.constants;
    }

    private Map<String, Autoload> getAutoloadMap() {
        return this.autoloads;
    }

    private synchronized Map<String, Autoload> getAutoloadMapForWrite() {
        return this.autoloads == Collections.EMPTY_MAP ? (this.autoloads = new ConcurrentHashMap<String, Autoload>(4, 0.9f, 1)) : this.autoloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncludingHierarchy(IncludedModuleWrapper hierarchy) {
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> oldIncludingHierarchies = this.includingHierarchies;
            if (oldIncludingHierarchies == Collections.EMPTY_SET) {
                this.includingHierarchies = oldIncludingHierarchies = new WeakHashSet<RubyClass>(4);
            }
            oldIncludingHierarchies.add(hierarchy);
        }
    }

    protected RubyModule(Ruby runtime, RubyClass metaClass, boolean objectSpace) {
        super(runtime, metaClass, objectSpace);
        this.id = runtime.allocModuleId();
        runtime.addModule(this);
        this.setFlag(4096, !this.isClass());
        this.generation = runtime.getNextModuleGeneration();
        this.generationObject = this.generation;
        this.cacheEntryFactory = runtime.getInstanceConfig().isProfiling() ? new ProfilingCacheEntryFactory(NormalCacheEntryFactory) : NormalCacheEntryFactory;
        this.methodInvalidator = OptoFactory.newMethodInvalidator(this);
    }

    protected RubyModule(Ruby runtime, RubyClass metaClass) {
        this(runtime, metaClass, runtime.isObjectSpaceEnabled());
    }

    protected RubyModule(Ruby runtime) {
        this(runtime, runtime.getModule());
    }

    public boolean needsImplementer() {
        return this.getFlag(4096);
    }

    public static RubyModule newModule(Ruby runtime) {
        return new RubyModule(runtime);
    }

    public static RubyModule newModule(Ruby runtime, String name2, RubyModule parent, boolean setParent) {
        RubyModule module = RubyModule.newModule(runtime);
        module.setBaseName(name2);
        if (setParent) {
            module.setParent(parent);
        }
        parent.setConstant(name2, module);
        return module;
    }

    public synchronized void addClassProvider(ClassProvider provider) {
        if (!this.classProviders.contains(provider)) {
            HashSet<ClassProvider> cp = new HashSet<ClassProvider>(this.classProviders);
            cp.add(provider);
            this.classProviders = cp;
        }
    }

    public synchronized void removeClassProvider(ClassProvider provider) {
        HashSet<ClassProvider> cp = new HashSet<ClassProvider>(this.classProviders);
        cp.remove(provider);
        this.classProviders = cp;
    }

    private void checkForCyclicInclude(RubyModule m) throws RaiseException {
        if (this.getNonIncludedClass() == m.getNonIncludedClass()) {
            throw this.getRuntime().newArgumentError("cyclic include detected");
        }
    }

    private RubyClass searchProvidersForClass(String name2, RubyClass superClazz) {
        for (ClassProvider classProvider : this.classProviders) {
            RubyClass clazz = classProvider.defineClassUnder(this, name2, superClazz);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    private RubyModule searchProvidersForModule(String name2) {
        for (ClassProvider classProvider : this.classProviders) {
            RubyModule module = classProvider.defineModuleUnder(this, name2);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(RubyClass superClass) {
        this.superClass = superClass;
        if (superClass != null && superClass.isSynchronized()) {
            this.becomeSynchronized();
        }
    }

    public RubyModule getParent() {
        return this.parent;
    }

    public void setParent(RubyModule parent) {
        this.parent = parent;
    }

    public Map<String, DynamicMethod> getMethods() {
        return this.methods;
    }

    public synchronized Map<String, DynamicMethod> getMethodsForWrite() {
        Map<String, DynamicMethod> myMethods = this.methods;
        return myMethods == Collections.EMPTY_MAP ? (this.methods = new ConcurrentHashMap<String, DynamicMethod>(0, 0.9f, 1)) : myMethods;
    }

    private void putMethod(String name2, DynamicMethod method2) {
        this.getMethodsForWrite().put(name2, method2);
        this.getRuntime().addProfiledMethod(name2, method2);
    }

    public boolean isIncluded() {
        return false;
    }

    public RubyModule getNonIncludedClass() {
        return this;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String name2) {
        this.baseName = name2;
    }

    public String getName() {
        if (this.cachedName != null) {
            return this.cachedName;
        }
        return this.calculateName();
    }

    public String getSimpleName() {
        if (this.baseName != null) {
            return this.baseName;
        }
        return this.calculateAnonymousName();
    }

    private String calculateName() {
        boolean cache = true;
        if (this.getBaseName() == null) {
            return this.calculateAnonymousName();
        }
        Ruby runtime = this.getRuntime();
        String name2 = this.getBaseName();
        RubyClass objectClass = runtime.getObject();
        int parentCount = 0;
        for (RubyModule p2 = this.getParent(); p2 != null && p2 != objectClass; p2 = p2.getParent()) {
            ++parentCount;
        }
        String[] parentNames = new String[parentCount];
        int i2 = parentCount - 1;
        int totalLength = name2.length() + parentCount * 2;
        RubyModule p3 = this.getParent();
        while (p3 != null && p3 != objectClass) {
            String pName = p3.getBaseName();
            if (pName == null) {
                cache = false;
                pName = p3.getName();
            }
            parentNames[i2] = pName;
            totalLength += pName.length();
            p3 = p3.getParent();
            --i2;
        }
        StringBuilder builder = new StringBuilder(totalLength);
        for (String parentName : parentNames) {
            builder.append(parentName).append("::");
        }
        builder.append(name2);
        String fullName = builder.toString();
        if (cache) {
            this.cachedName = fullName;
        }
        return fullName;
    }

    private String calculateAnonymousName() {
        if (this.anonymousName == null) {
            StringBuilder anonBase = new StringBuilder("#<" + this.metaClass.getRealClass().getName() + ":0x");
            anonBase.append(Integer.toHexString(System.identityHashCode(this))).append('>');
            this.anonymousName = anonBase.toString();
        }
        return this.anonymousName;
    }

    @Deprecated
    public IncludedModuleWrapper newIncludeClass(RubyClass superClazz) {
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(this.getRuntime(), superClazz, this);
        if (this.getSuperClass() != null) {
            includedModule.includeModule(this.getSuperClass());
        }
        return includedModule;
    }

    public RubyClass getClass(String name2) {
        IRubyObject module = this.getConstantAt(name2);
        if (module instanceof RubyClass) {
            return (RubyClass)module;
        }
        return null;
    }

    @Deprecated
    public RubyClass fastGetClass(String internedName) {
        return this.getClass(internedName);
    }

    public synchronized void includeModule(IRubyObject arg2) {
        assert (arg2 != null);
        this.testFrozen("module");
        if (!(arg2 instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("Wrong argument type " + arg2.getMetaClass().getName() + " (expected Module).");
        }
        RubyModule module = (RubyModule)arg2;
        this.checkForCyclicInclude(module);
        this.infectBy(module);
        this.doIncludeModule(module);
        this.invalidateCoreClasses();
        this.invalidateCacheDescendants();
        this.invalidateConstantCacheForModuleInclusion(module);
    }

    public void defineAnnotatedMethod(Class clazz, String name2) {
        boolean foundMethod = false;
        for (Method method2 : clazz.getDeclaredMethods()) {
            if (!method2.getName().equals(name2) || !this.defineAnnotatedMethod(method2, MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader()))) continue;
            foundMethod = true;
        }
        if (!foundMethod) {
            throw new RuntimeException("No JRubyMethod present for method " + name2 + "on class " + clazz.getName());
        }
    }

    public void defineAnnotatedConstants(Class clazz) {
        Field[] declaredFields;
        for (Field field2 : declaredFields = clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field2.getModifiers())) continue;
            this.defineAnnotatedConstant(field2);
        }
    }

    public boolean defineAnnotatedConstant(Field field2) {
        IRubyObject realVal;
        JRubyConstant jrubyConstant = field2.getAnnotation(JRubyConstant.class);
        if (jrubyConstant == null) {
            return false;
        }
        String[] names2 = jrubyConstant.value();
        if (names2.length == 0) {
            names2 = new String[]{field2.getName()};
        }
        Class<?> tp = field2.getType();
        try {
            realVal = tp == Integer.class || tp == Integer.TYPE || tp == Short.class || tp == Short.TYPE || tp == Byte.class || tp == Byte.TYPE ? RubyNumeric.int2fix(this.getRuntime(), field2.getInt(null)) : (tp == Boolean.class || tp == Boolean.TYPE ? (field2.getBoolean(null) ? this.getRuntime().getTrue() : this.getRuntime().getFalse()) : this.getRuntime().getNil());
        }
        catch (Exception e) {
            realVal = this.getRuntime().getNil();
        }
        for (String name2 : names2) {
            this.setConstant(name2, realVal);
        }
        return true;
    }

    @Extension
    public void defineAnnotatedMethods(Class clazz) {
        this.defineAnnotatedMethodsIndividually(clazz);
    }

    public void defineAnnotatedMethodsIndividually(Class clazz) {
        TypePopulator populator;
        if (RubyInstanceConfig.FULL_TRACE_ENABLED || RubyInstanceConfig.REFLECTED_HANDLES) {
            populator = TypePopulator.DEFAULT;
        } else {
            try {
                String qualifiedName = "org.jruby.gen." + clazz.getCanonicalName().replace('.', '$');
                Class<?> populatorClass = Class.forName(qualifiedName + "$POPULATOR");
                populator = (TypePopulator)populatorClass.newInstance();
            }
            catch (Throwable t) {
                populator = TypePopulator.DEFAULT;
            }
        }
        populator.populate(this, clazz);
    }

    public boolean defineAnnotatedMethod(String name2, List<JavaMethodDescriptor> methods2, MethodFactory methodFactory) {
        JavaMethodDescriptor desc = methods2.get(0);
        if (methods2.size() == 1) {
            return this.defineAnnotatedMethod(name2, desc, methodFactory);
        }
        CompatVersion compatVersion = this.getRuntime().getInstanceConfig().getCompatVersion();
        if (CompatVersion.shouldBindMethod(compatVersion, desc.anno.compat())) {
            DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, methods2);
            RubyModule.define(this, desc, name2, dynamicMethod);
            return true;
        }
        return false;
    }

    public boolean defineAnnotatedMethod(Method method2, MethodFactory methodFactory) {
        JRubyMethod jrubyMethod = method2.getAnnotation(JRubyMethod.class);
        if (jrubyMethod == null) {
            return false;
        }
        CompatVersion compatVersion = this.getRuntime().getInstanceConfig().getCompatVersion();
        if (CompatVersion.shouldBindMethod(compatVersion, jrubyMethod.compat())) {
            JavaMethodDescriptor desc = new JavaMethodDescriptor(method2);
            DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc);
            RubyModule.define(this, desc, method2.getName(), dynamicMethod);
            return true;
        }
        return false;
    }

    public boolean defineAnnotatedMethod(String name2, JavaMethodDescriptor desc, MethodFactory methodFactory) {
        JRubyMethod jrubyMethod = desc.anno;
        if (jrubyMethod == null) {
            return false;
        }
        CompatVersion compatVersion = this.getRuntime().getInstanceConfig().getCompatVersion();
        if (CompatVersion.shouldBindMethod(compatVersion, jrubyMethod.compat())) {
            DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc);
            RubyModule.define(this, desc, name2, dynamicMethod);
            return true;
        }
        return false;
    }

    public void undefineMethod(String name2) {
        this.addMethod(name2, UndefinedMethod.getInstance());
    }

    public void undef(ThreadContext context, String name2) {
        DynamicMethod method2;
        Ruby runtime = context.runtime;
        this.testFrozen("module");
        if (name2.equals("__id__") || name2.equals("__send__")) {
            runtime.getWarnings().warn(IRubyWarnings.ID.UNDEFINING_BAD, "undefining `" + name2 + "' may cause serious problem");
        }
        if ((method2 = this.searchMethod(name2)).isUndefined()) {
            String s0 = " class";
            RubyModule c = this;
            if (c.isSingleton()) {
                IRubyObject obj = ((MetaClass)c).getAttached();
                if (obj != null && obj instanceof RubyModule) {
                    c = (RubyModule)obj;
                    s0 = "";
                }
            } else if (c.isModule()) {
                s0 = " module";
            }
            throw runtime.newNameError("Undefined method " + name2 + " for" + s0 + " '" + c.getName() + "'", name2);
        }
        this.addMethod(name2, UndefinedMethod.getInstance());
        if (this.isSingleton()) {
            IRubyObject singleton = ((MetaClass)this).getAttached();
            singleton.callMethod(context, "singleton_method_undefined", runtime.newSymbol(name2));
        } else {
            this.callMethod(context, "method_undefined", (IRubyObject)runtime.newSymbol(name2));
        }
    }

    @JRubyMethod(name={"include?"}, required=1)
    public IRubyObject include_p(ThreadContext context, IRubyObject arg2) {
        if (!arg2.isModule()) {
            throw context.runtime.newTypeError(arg2, context.runtime.getModule());
        }
        RubyModule moduleToCompare = (RubyModule)arg2;
        for (RubyClass p2 = this.getSuperClass(); p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isSame(moduleToCompare)) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public void addMethod(String name2, DynamicMethod method2) {
        this.testFrozen("class/module");
        this.addMethodInternal(name2, method2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethodInternal(String name2, DynamicMethod method2) {
        Map<String, DynamicMethod> map = this.getMethodsForWrite();
        synchronized (map) {
            this.addMethodAtBootTimeOnly(name2, method2);
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
    }

    public void addMethodAtBootTimeOnly(String name2, DynamicMethod method2) {
        this.getMethodsForWrite().put(name2, method2);
        this.getRuntime().addProfiledMethod(name2, method2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethod(ThreadContext context, String name2) {
        Ruby runtime = context.runtime;
        this.testFrozen("class/module");
        Map<String, DynamicMethod> map = this.getMethodsForWrite();
        synchronized (map) {
            DynamicMethod method2 = this.getMethodsForWrite().remove(name2);
            if (method2 == null) {
                throw runtime.newNameError("method '" + name2 + "' not defined in " + this.getName(), name2);
            }
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
        if (this.isSingleton()) {
            IRubyObject singleton = ((MetaClass)this).getAttached();
            singleton.callMethod(context, "singleton_method_removed", runtime.newSymbol(name2));
        } else {
            this.callMethod(context, "method_removed", (IRubyObject)runtime.newSymbol(name2));
        }
    }

    public DynamicMethod searchMethod(String name2) {
        return this.searchWithCache((String)name2).method;
    }

    public CacheEntry searchWithCache(String name2) {
        CacheEntry entry = this.cacheHit(name2);
        if (entry != null) {
            return entry;
        }
        int token = this.getGeneration();
        DynamicMethod method2 = this.searchMethodInner(name2);
        if (method2 instanceof CacheableMethod) {
            method2 = ((CacheableMethod)((Object)method2)).getMethodForCaching();
        }
        return method2 != null ? this.addToCache(name2, method2, token) : this.addToCache(name2, UndefinedMethod.getInstance(), token);
    }

    @Deprecated
    public final int getCacheToken() {
        return this.generation;
    }

    public final int getGeneration() {
        return this.generation;
    }

    public final Integer getGenerationObject() {
        return this.generationObject;
    }

    private final Map<String, CacheEntry> getCachedMethods() {
        return this.cachedMethods;
    }

    private final Map<String, CacheEntry> getCachedMethodsForWrite() {
        Map<String, CacheEntry> myCachedMethods = this.cachedMethods;
        return myCachedMethods == Collections.EMPTY_MAP ? (this.cachedMethods = new ConcurrentHashMap<String, CacheEntry>(0, 0.75f, 1)) : myCachedMethods;
    }

    private CacheEntry cacheHit(String name2) {
        CacheEntry cacheEntry = this.getCachedMethods().get(name2);
        if (cacheEntry != null && cacheEntry.token == this.getGeneration()) {
            return cacheEntry;
        }
        return null;
    }

    private void invalidateConstantCacheForModuleInclusion(RubyModule module) {
        for (RubyModule mod : this.gatherModules(module)) {
            for (String key2 : mod.getConstantMap().keySet()) {
                this.invalidateConstantCache(key2);
            }
        }
    }

    public void becomeSynchronized() {
        this.cacheEntryFactory = new SynchronizedCacheEntryFactory(this.cacheEntryFactory);
    }

    public boolean isSynchronized() {
        return this.cacheEntryFactory.hasCacheEntryFactory(SynchronizedCacheEntryFactory.class);
    }

    private CacheEntry addToCache(String name2, DynamicMethod method2, int token) {
        CacheEntry entry = this.cacheEntryFactory.newCacheEntry(method2, token);
        this.getCachedMethodsForWrite().put(name2, entry);
        return entry;
    }

    public DynamicMethod searchMethodInner(String name2) {
        DynamicMethod method2 = this.getMethods().get(name2);
        if (method2 != null) {
            return method2;
        }
        return this.superClass == null ? null : this.superClass.searchMethodInner(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCacheDescendants() {
        if (this.includingHierarchies.isEmpty()) {
            this.methodInvalidator.invalidate();
            return;
        }
        ArrayList<Invalidator> invalidators = new ArrayList<Invalidator>();
        invalidators.add(this.methodInvalidator);
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            for (RubyClass includingHierarchy : this.includingHierarchies) {
                includingHierarchy.addInvalidatorsAndFlush(invalidators);
            }
        }
        this.methodInvalidator.invalidateAll(invalidators);
    }

    protected void invalidateCoreClasses() {
        if (!this.getRuntime().isBooting()) {
            if (this == this.getRuntime().getFixnum()) {
                this.getRuntime().reopenFixnum();
            } else if (this == this.getRuntime().getFloat()) {
                this.getRuntime().reopenFloat();
            }
        }
    }

    public Invalidator getInvalidator() {
        return this.methodInvalidator;
    }

    public void updateGeneration() {
        this.generation = this.getRuntime().getNextModuleGeneration();
        this.generationObject = this.generation;
    }

    @Deprecated
    protected void invalidateCacheDescendantsInner() {
        this.methodInvalidator.invalidate();
    }

    protected void invalidateConstantCache(String constantName) {
        this.getRuntime().getConstantInvalidator(constantName).invalidate();
    }

    public DynamicMethod retrieveMethod(String name2) {
        return this.getMethods().get(name2);
    }

    public RubyModule findImplementer(RubyModule clazz) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.isSame(clazz)) continue;
            return module;
        }
        return null;
    }

    public void addModuleFunction(String name2, DynamicMethod method2) {
        this.addMethod(name2, method2);
        this.getSingletonClass().addMethod(name2, method2);
    }

    public synchronized void defineAlias(String name2, String oldName) {
        this.testFrozen("module");
        if (oldName.equals(name2)) {
            return;
        }
        DynamicMethod method2 = this.searchForAliasMethod(this.getRuntime(), oldName);
        this.putMethod(name2, new AliasMethod(this, method2, oldName));
        this.invalidateCoreClasses();
        this.invalidateCacheDescendants();
    }

    public synchronized void defineAliases(List<String> aliases2, String oldName) {
        this.testFrozen("module");
        DynamicMethod method2 = this.searchForAliasMethod(this.getRuntime(), oldName);
        for (String name2 : aliases2) {
            if (oldName.equals(name2)) continue;
            this.putMethod(name2, new AliasMethod(this, method2, oldName));
        }
        this.invalidateCoreClasses();
        this.invalidateCacheDescendants();
    }

    private DynamicMethod searchForAliasMethod(Ruby runtime, String name2) {
        if (SCOPE_CAPTURING_METHODS.contains(name2)) {
            runtime.getWarnings().warn("`" + name2 + "' should not be aliased");
        }
        return this.deepMethodSearch(name2, runtime);
    }

    public RubyClass defineOrGetClassUnder(String name2, RubyClass superClazz) {
        RubyClass clazz;
        Ruby runtime = this.getRuntime();
        IRubyObject classObj = this.getConstantAtSpecial(name2);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw runtime.newTypeError(name2 + " is not a class");
            }
            clazz = (RubyClass)classObj;
            if (superClazz != null) {
                RubyClass tmp;
                for (tmp = clazz.getSuperClass(); tmp != null && tmp.isIncluded(); tmp = tmp.getSuperClass()) {
                }
                if (tmp != null) {
                    tmp = tmp.getRealClass();
                }
                if (tmp != superClazz) {
                    throw runtime.newTypeError("superclass mismatch for class " + name2);
                }
            }
        } else if (this.classProviders == null || (clazz = this.searchProvidersForClass(name2, superClazz)) == null) {
            if (superClazz == null) {
                superClazz = runtime.getObject();
            }
            ObjectAllocator allocator = superClazz == runtime.getObject() ? (RubyInstanceConfig.REIFY_RUBY_CLASSES ? REIFYING_OBJECT_ALLOCATOR : (Options.REIFY_VARIABLES.load().booleanValue() ? IVAR_INSPECTING_OBJECT_ALLOCATOR : OBJECT_ALLOCATOR)) : superClazz.getAllocator();
            clazz = RubyClass.newClass(runtime, superClazz, name2, allocator, this, true);
        }
        return clazz;
    }

    public RubyModule defineOrGetModuleUnder(String name2) {
        RubyModule module;
        Ruby runtime = this.getRuntime();
        IRubyObject moduleObj = this.getConstantAtSpecial(name2);
        if (moduleObj != null) {
            if (!moduleObj.isModule()) {
                throw runtime.newTypeError(name2 + " is not a module");
            }
            module = (RubyModule)moduleObj;
        } else if (this.classProviders == null || (module = this.searchProvidersForModule(name2)) == null) {
            module = RubyModule.newModule(runtime, name2, this, true);
        }
        return module;
    }

    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator) {
        return this.getRuntime().defineClassUnder(name2, superClass, allocator, this);
    }

    public RubyModule defineModuleUnder(String name2) {
        return this.getRuntime().defineModuleUnder(name2, this);
    }

    private void addAccessor(ThreadContext context, String internedName, Visibility visibility, boolean readable, boolean writeable) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        Ruby runtime = context.runtime;
        if (visibility != Visibility.PRIVATE && visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        if (!IdUtil.isLocal(internedName) && !IdUtil.isConstant(internedName)) {
            throw runtime.newNameError("invalid attribute name", internedName);
        }
        String variableName = ("@" + internedName).intern();
        if (readable) {
            this.addMethod(internedName, new AttrReaderMethod(this, visibility, CallConfiguration.FrameNoneScopeNone, variableName));
            this.callMethod(context, "method_added", (IRubyObject)runtime.fastNewSymbol(internedName));
        }
        if (writeable) {
            internedName = (internedName + "=").intern();
            this.addMethod(internedName, new AttrWriterMethod(this, visibility, CallConfiguration.FrameNoneScopeNone, variableName));
            this.callMethod(context, "method_added", (IRubyObject)runtime.fastNewSymbol(internedName));
        }
    }

    public void setMethodVisibility(IRubyObject[] methods2, Visibility visibility) {
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            this.exportMethod(methods2[i2].asJavaString(), visibility);
        }
    }

    public void exportMethod(String name2, Visibility visibility) {
        Ruby runtime = this.getRuntime();
        DynamicMethod method2 = this.deepMethodSearch(name2, runtime);
        if (method2.getVisibility() != visibility) {
            if (this == method2.getImplementationClass()) {
                method2.setVisibility(visibility);
            } else {
                this.addMethod(name2, new WrapperMethod(this, method2, visibility));
            }
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
    }

    private DynamicMethod deepMethodSearch(String name2, Ruby runtime) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (method2.isUndefined() && this.isModule()) {
            method2 = runtime.getObject().searchMethod(name2);
        }
        if (method2.isUndefined()) {
            throw runtime.newNameError("undefined method '" + name2 + "' for " + (this.isModule() ? "module" : "class") + " '" + this.getName() + "'", name2);
        }
        return method2;
    }

    public boolean isMethodBound(String name2, boolean checkVisibility) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (!method2.isUndefined()) {
            return !checkVisibility || method2.getVisibility() != Visibility.PRIVATE;
        }
        return false;
    }

    public boolean isMethodBound(String name2, boolean checkVisibility, boolean checkRespondTo) {
        if (!checkRespondTo) {
            return this.isMethodBound(name2, checkVisibility);
        }
        DynamicMethod method2 = this.searchMethod(name2);
        if (!method2.isUndefined() && !method2.isNotImplemented()) {
            return !checkVisibility || method2.getVisibility() != Visibility.PRIVATE;
        }
        return false;
    }

    public IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility) {
        return this.newMethod(receiver2, methodName, bound, visibility, false, true);
    }

    public IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility, boolean respondToMissing) {
        return this.newMethod(receiver2, methodName, bound, visibility, respondToMissing, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility, boolean respondToMissing, boolean priv) {
        DynamicMethod method2 = this.searchMethod(methodName);
        if (method2.isUndefined() || visibility != null && method2.getVisibility() != visibility) {
            if (!respondToMissing) throw this.getRuntime().newNameError("undefined method `" + methodName + "' for class `" + this.getName() + "'", methodName);
            if (!receiver2.respondsToMissing(methodName, priv)) throw this.getRuntime().newNameError("undefined method `" + methodName + "' for class `" + this.getName() + "'", methodName);
            method2 = new RespondToMissingMethod(this, Visibility.PUBLIC, methodName);
        }
        RubyModule implementationModule = method2.getImplementationClass();
        RubyModule originModule = this;
        while (originModule != implementationModule && originModule.isSingleton()) {
            originModule = ((MetaClass)originModule).getRealClass();
        }
        RubyMethod newMethod = bound ? RubyMethod.newMethod(implementationModule, methodName, originModule, methodName, method2, receiver2) : RubyUnboundMethod.newUnboundMethod(implementationModule, methodName, originModule, methodName, method2);
        newMethod.infectBy(this);
        return newMethod;
    }

    @JRubyMethod(name={"define_method"}, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, Block block) {
        Ruby runtime = context.runtime;
        String name2 = TypeConverter.convertToIdentifier(arg0);
        DynamicMethod newMethod = null;
        Visibility visibility = Visibility.PUBLIC;
        RubySymbol.newSymbol(runtime, arg0);
        if (!block.isGiven()) {
            throw this.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        block = block.cloneBlockAndFrame();
        RubyProc proc2 = runtime.newProc(Block.Type.LAMBDA, block);
        proc2.getBlock().type = Block.Type.LAMBDA;
        newMethod = this.createProcMethod(name2, visibility, proc2);
        Helpers.addInstanceMethod(this, name2, newMethod, visibility, context, runtime);
        return proc2;
    }

    @JRubyMethod(name={"define_method"}, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyObject body;
        Ruby runtime = context.runtime;
        String name2 = TypeConverter.convertToIdentifier(arg0);
        DynamicMethod newMethod = null;
        Visibility visibility = Visibility.PUBLIC;
        RubySymbol.newSymbol(runtime, arg0);
        if (runtime.getProc().isInstance(arg1)) {
            RubyProc proc2;
            body = proc2 = (RubyProc)arg1;
            newMethod = this.createProcMethod(name2, visibility, proc2);
        } else if (runtime.getMethod().isInstance(arg1)) {
            RubyMethod method2 = (RubyMethod)arg1;
            body = method2;
            this.checkValidBindTargetFrom(context, (RubyModule)method2.owner(context));
            newMethod = method2.unbind().getMethod().dup();
            newMethod.setImplementationClass(this);
        } else {
            throw runtime.newTypeError("wrong argument type " + arg1.getType().getName() + " (expected Proc/Method)");
        }
        Helpers.addInstanceMethod(this, name2, newMethod, visibility, context, runtime);
        return body;
    }

    @Deprecated
    public IRubyObject define_method(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.define_method(context, args2[0], block);
            }
            case 2: {
                return this.define_method(context, args2[0], args2[1], block);
            }
        }
        throw context.runtime.newArgumentError("wrong number of arguments (" + args2.length + " for 2)");
    }

    private DynamicMethod createProcMethod(String name2, Visibility visibility, RubyProc proc2) {
        Block block = proc2.getBlock();
        block.getBinding().getFrame().setKlazz(this);
        block.getBinding().getFrame().setName(name2);
        block.getBinding().setMethod(name2);
        StaticScope scope = block.getBody().getStaticScope();
        scope.makeArgumentScope();
        Arity arity2 = block.arity();
        scope.setRequiredArgs(arity2.required());
        if (!arity2.isFixed()) {
            scope.setRestArg(arity2.required());
        }
        return new ProcMethod(this, proc2, visibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public IRubyObject executeUnder(ThreadContext context, Callback method2, IRubyObject[] args2, Block block) {
        context.preExecuteUnder(this, block);
        try {
            IRubyObject iRubyObject = method2.execute(this, args2, block);
            return iRubyObject;
        }
        finally {
            context.postExecuteUnder();
        }
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name() {
        Ruby runtime = this.getRuntime();
        if (this.getBaseName() == null) {
            return RubyString.newEmptyString(runtime);
        }
        return runtime.newString(this.getName());
    }

    @JRubyMethod(name={"name"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject name19() {
        Ruby runtime = this.getRuntime();
        if (this.getBaseName() == null) {
            return runtime.getNil();
        }
        return runtime.newString(this.getName());
    }

    protected IRubyObject cloneMethods(RubyModule clone) {
        RubyModule realType = this.getNonIncludedClass();
        for (Map.Entry<String, DynamicMethod> entry : this.getMethods().entrySet()) {
            DynamicMethod method2 = entry.getValue();
            if (method2.getImplementationClass() != realType && !method2.isUndefined()) continue;
            DynamicMethod clonedMethod = method2.dup();
            clonedMethod.setImplementationClass(clone);
            clone.putMethod(entry.getKey(), clonedMethod);
        }
        return clone;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        super.initialize_copy(original);
        RubyModule originalModule = (RubyModule)original;
        if (!this.getMetaClass().isSingleton()) {
            this.setMetaClass(originalModule.getSingletonClassClone());
        }
        this.setSuperClass(originalModule.getSuperClass());
        if (originalModule.hasVariables()) {
            this.syncVariables(originalModule);
        }
        this.syncConstants(originalModule);
        originalModule.cloneMethods(this);
        return this;
    }

    public void syncConstants(RubyModule other) {
        if (other.getConstantMap() != Collections.EMPTY_MAP) {
            this.getConstantMapForWrite().putAll(other.getConstantMap());
        }
    }

    public void syncClassVariables(RubyModule other) {
        if (other.getClassVariablesForRead() != Collections.EMPTY_MAP) {
            this.getClassVariables().putAll(other.getClassVariablesForRead());
        }
    }

    @JRubyMethod(name={"included_modules"})
    public RubyArray included_modules(ThreadContext context) {
        RubyArray ary = context.runtime.newArray();
        for (RubyClass p2 = this.getSuperClass(); p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isIncluded()) continue;
            ary.append(p2.getNonIncludedClass());
        }
        return ary;
    }

    @JRubyMethod(name={"ancestors"})
    public RubyArray ancestors(ThreadContext context) {
        return context.runtime.newArray(this.getAncestorList());
    }

    @Deprecated
    public RubyArray ancestors() {
        return this.getRuntime().newArray(this.getAncestorList());
    }

    public List<IRubyObject> getAncestorList() {
        ArrayList<IRubyObject> list2 = new ArrayList<IRubyObject>();
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (module.isSingleton()) continue;
            list2.add(module.getNonIncludedClass());
        }
        return list2;
    }

    public boolean hasModuleInHierarchy(RubyModule type2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (module.getNonIncludedClass() != type2) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.id);
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.isSingleton()) {
            IRubyObject attached = ((MetaClass)this).getAttached();
            StringBuilder buffer = new StringBuilder("#<Class:");
            if (attached != null) {
                if (attached instanceof RubyClass || attached instanceof RubyModule) {
                    buffer.append(attached.inspect());
                } else {
                    buffer.append(attached.anyToString());
                }
            }
            buffer.append(">");
            return this.getRuntime().newString(buffer.toString());
        }
        return this.getRuntime().newString(this.getName());
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject obj) {
        return context.runtime.newBoolean(this.isInstance(obj));
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return super.op_equal(context, other);
    }

    @Override
    @JRubyMethod(name={"freeze"})
    public final IRubyObject freeze(ThreadContext context) {
        this.to_s();
        return super.freeze(context);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        if (this.isKindOfModule((RubyModule)obj)) {
            return this.getRuntime().getTrue();
        }
        if (((RubyModule)obj).isKindOfModule(this)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(IRubyObject obj) {
        return obj == this ? this.getRuntime().getFalse() : this.op_le(obj);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        return ((RubyModule)obj).op_le(this);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(IRubyObject obj) {
        return this == obj ? this.getRuntime().getFalse() : this.op_ge(obj);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().newFixnum(0);
        }
        if (!(obj instanceof RubyModule)) {
            return this.getRuntime().getNil();
        }
        RubyModule module = (RubyModule)obj;
        if (module.isKindOfModule(this)) {
            return this.getRuntime().newFixnum(1);
        }
        if (this.isKindOfModule(module)) {
            return this.getRuntime().newFixnum(-1);
        }
        return this.getRuntime().getNil();
    }

    public boolean isKindOfModule(RubyModule type2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.isSame(type2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSame(RubyModule module) {
        return this == module;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        if (block.isGiven()) {
            this.module_exec(context, new IRubyObject[]{this}, block);
        }
        return this.getRuntime().getNil();
    }

    public void addReadWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, name2.intern(), Visibility.PUBLIC, true, true);
    }

    public void addReadAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, name2.intern(), Visibility.PUBLIC, true, false);
    }

    public void addWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, name2.intern(), Visibility.PUBLIC, false, true);
    }

    @JRubyMethod(name={"attr"}, required=1, optional=1, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY}, compat=CompatVersion.RUBY1_8)
    public IRubyObject attr(ThreadContext context, IRubyObject[] args2) {
        boolean writeable = args2.length > 1 ? args2[1].isTrue() : false;
        Visibility visibility = context.getCurrentVisibility();
        this.addAccessor(context, args2[0].asJavaString().intern(), visibility, true, writeable);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"attr"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY}, compat=CompatVersion.RUBY1_9)
    public IRubyObject attr19(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (args2.length == 2 && (args2[1] == runtime.getTrue() || args2[1] == runtime.getFalse())) {
            runtime.getWarnings().warn(IRubyWarnings.ID.OBSOLETE_ARGUMENT, "optional boolean argument is obsoleted");
            this.addAccessor(context, args2[0].asJavaString().intern(), context.getCurrentVisibility(), args2[0].isTrue(), true);
            return runtime.getNil();
        }
        return this.attr_reader(context, args2);
    }

    @Deprecated
    public IRubyObject attr_reader(IRubyObject[] args2) {
        return this.attr_reader(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_reader"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_reader(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, args2[i2].asJavaString().intern(), visibility, true, false);
        }
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"attr_writer"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_writer(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, args2[i2].asJavaString().intern(), visibility, false, true);
        }
        return context.runtime.getNil();
    }

    @Deprecated
    public IRubyObject attr_accessor(IRubyObject[] args2) {
        return this.attr_accessor(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_accessor"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_accessor(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, args2[i2].asJavaString().intern(), visibility, true, true);
        }
        return context.runtime.getNil();
    }

    private RubyArray instance_methods(IRubyObject[] args2, Visibility visibility, boolean not, boolean useSymbols) {
        boolean includeSuper = args2.length > 0 ? args2[0].isTrue() : true;
        Ruby runtime = this.getRuntime();
        RubyArray ary = runtime.newArray();
        HashSet<String> seen = new HashSet<String>();
        this.populateInstanceMethodNames(seen, ary, visibility, not, useSymbols, includeSuper);
        return ary;
    }

    public void populateInstanceMethodNames(Set<String> seen, RubyArray ary, Visibility visibility, boolean not, boolean useSymbols, boolean includeSuper) {
        Ruby runtime = this.getRuntime();
        for (RubyModule type2 = this; type2 != null; type2 = type2.getSuperClass()) {
            RubyModule realType = type2.getNonIncludedClass();
            for (Map.Entry<String, DynamicMethod> entry : type2.getMethods().entrySet()) {
                String methodName = entry.getKey();
                if (seen.contains(methodName)) continue;
                seen.add(methodName);
                DynamicMethod method2 = entry.getValue();
                if (method2.getImplementationClass() != realType || (not || method2.getVisibility() != visibility) && (!not || method2.getVisibility() == visibility) || method2.isUndefined()) continue;
                ary.append(useSymbols ? runtime.newSymbol(methodName) : runtime.newString(methodName));
            }
            if (!includeSuper) break;
        }
    }

    @JRubyMethod(name={"instance_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public RubyArray instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PRIVATE, true, false);
    }

    @JRubyMethod(name={"instance_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyArray instance_methods19(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PRIVATE, true, true);
    }

    @JRubyMethod(name={"public_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public RubyArray public_instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PUBLIC, false, false);
    }

    @JRubyMethod(name={"public_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyArray public_instance_methods19(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PUBLIC, false, true);
    }

    @JRubyMethod(name={"instance_method"}, required=1)
    public IRubyObject instance_method(IRubyObject symbol) {
        return this.newMethod(null, symbol.asJavaString(), false, null);
    }

    @JRubyMethod(name={"protected_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public RubyArray protected_instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PROTECTED, false, false);
    }

    @JRubyMethod(name={"protected_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyArray protected_instance_methods19(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PROTECTED, false, true);
    }

    @JRubyMethod(name={"private_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public RubyArray private_instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PRIVATE, false, false);
    }

    @JRubyMethod(name={"private_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyArray private_instance_methods19(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PRIVATE, false, true);
    }

    @JRubyMethod(name={"append_features"}, required=1, visibility=Visibility.PRIVATE)
    public RubyModule append_features(IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(module, this.getRuntime().getClassClass());
        }
        ((RubyModule)module).includeModule(this);
        return this;
    }

    @JRubyMethod(name={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject extend_object(IRubyObject obj) {
        obj.getSingletonClass().includeModule(this);
        return obj;
    }

    @JRubyMethod(name={"include"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule include(IRubyObject[] modules) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        int i2 = modules.length;
        while (--i2 >= 0) {
            IRubyObject obj = modules[i2];
            if (obj.isModule()) continue;
            throw context.runtime.newTypeError(obj, context.runtime.getModule());
        }
        for (i2 = modules.length - 1; i2 >= 0; --i2) {
            modules[i2].callMethod(context, "append_features", this);
            modules[i2].callMethod(context, "included", this);
        }
        return this;
    }

    @JRubyMethod(name={"included"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject included(ThreadContext context, IRubyObject other) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"extended"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject extended(ThreadContext context, IRubyObject other, Block block) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"mix"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY2_0)
    public IRubyObject mix(ThreadContext context, IRubyObject mod) {
        Ruby runtime = context.runtime;
        if (!mod.isModule()) {
            throw runtime.newTypeError(mod, runtime.getModule());
        }
        for (Map.Entry<String, DynamicMethod> entry : ((RubyModule)mod).methods.entrySet()) {
            if (!this.methods.containsKey(entry.getKey())) continue;
            throw runtime.newArgumentError("method would conflict - " + entry.getKey());
        }
        for (Map.Entry<String, DynamicMethod> entry : ((RubyModule)mod).methods.entrySet()) {
            this.getMethodsForWrite().put(entry.getKey(), entry.getValue().dup());
        }
        return mod;
    }

    @JRubyMethod(name={"mix"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY2_0)
    public IRubyObject mix(ThreadContext context, IRubyObject mod, IRubyObject hash0) {
        Ruby runtime = context.runtime;
        RubyHash methodNames = null;
        if (!mod.isModule()) {
            throw runtime.newTypeError(mod, runtime.getModule());
        }
        if (!(hash0 instanceof RubyHash)) {
            throw runtime.newTypeError(hash0, runtime.getHash());
        }
        methodNames = (RubyHash)hash0;
        for (Map.Entry entry : methodNames.directEntrySet()) {
            String name2 = entry.getValue().toString();
            if (!this.methods.containsKey(entry.getValue().toString())) continue;
            throw runtime.newArgumentError("constant would conflict - " + name2);
        }
        for (Map.Entry entry : ((RubyModule)mod).methods.entrySet()) {
            if (!this.methods.containsKey(entry.getKey())) continue;
            throw runtime.newArgumentError("method would conflict - " + (String)entry.getKey());
        }
        for (Map.Entry entry : ((RubyModule)mod).methods.entrySet()) {
            String name2 = (String)entry.getKey();
            IRubyObject mapped = methodNames.fastARef(runtime.newSymbol(name2));
            if (mapped != NEVER) {
                if (mapped == context.nil) continue;
                name2 = mapped.toString();
            }
            this.getMethodsForWrite().put(name2, ((DynamicMethod)entry.getValue()).dup());
        }
        return mod;
    }

    private void setVisibility(ThreadContext context, IRubyObject[] args2, Visibility visibility) {
        if (args2.length == 0) {
            context.setCurrentVisibility(visibility);
        } else {
            this.setMethodVisibility(args2, visibility);
        }
    }

    @JRubyMethod(name={"public"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbPublic(ThreadContext context, IRubyObject[] args2) {
        this.setVisibility(context, args2, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"protected"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbProtected(ThreadContext context, IRubyObject[] args2) {
        this.setVisibility(context, args2, Visibility.PROTECTED);
        return this;
    }

    @JRubyMethod(name={"private"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbPrivate(ThreadContext context, IRubyObject[] args2) {
        this.setVisibility(context, args2, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"module_function"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule module_function(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (args2.length == 0) {
            context.setCurrentVisibility(Visibility.MODULE_FUNCTION);
        } else {
            this.setMethodVisibility(args2, Visibility.PRIVATE);
            for (int i2 = 0; i2 < args2.length; ++i2) {
                String name2 = args2[i2].asJavaString().intern();
                DynamicMethod method2 = this.deepMethodSearch(name2, runtime);
                this.getSingletonClass().addMethod(name2, new WrapperMethod((RubyModule)this.getSingletonClass(), method2, Visibility.PUBLIC));
                this.callMethod(context, "singleton_method_added", (IRubyObject)context.runtime.fastNewSymbol(name2));
            }
        }
        return this;
    }

    @JRubyMethod(name={"method_added"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_added(ThreadContext context, IRubyObject nothing) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"method_removed"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_removed(ThreadContext context, IRubyObject nothing) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"method_undefined"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_undefined(ThreadContext context, IRubyObject nothing) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"method_defined?"}, required=1)
    public RubyBoolean method_defined_p(ThreadContext context, IRubyObject symbol) {
        return this.isMethodBound(symbol.asJavaString(), true) ? context.runtime.getTrue() : context.runtime.getFalse();
    }

    @JRubyMethod(name={"public_method_defined?"}, required=1)
    public IRubyObject public_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(symbol.asJavaString());
        return context.runtime.newBoolean(!method2.isUndefined() && method2.getVisibility() == Visibility.PUBLIC);
    }

    @JRubyMethod(name={"protected_method_defined?"}, required=1)
    public IRubyObject protected_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(symbol.asJavaString());
        return context.runtime.newBoolean(!method2.isUndefined() && method2.getVisibility() == Visibility.PROTECTED);
    }

    @JRubyMethod(name={"private_method_defined?"}, required=1)
    public IRubyObject private_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(symbol.asJavaString());
        return context.runtime.newBoolean(!method2.isUndefined() && method2.getVisibility() == Visibility.PRIVATE);
    }

    @JRubyMethod(name={"public_class_method"}, rest=true)
    public RubyModule public_class_method(IRubyObject[] args2) {
        this.getMetaClass().setMethodVisibility(args2, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"private_class_method"}, rest=true)
    public RubyModule private_class_method(IRubyObject[] args2) {
        this.getMetaClass().setMethodVisibility(args2, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"alias_method"}, required=2, visibility=Visibility.PRIVATE)
    public RubyModule alias_method(ThreadContext context, IRubyObject newId, IRubyObject oldId) {
        RubySymbol newSym;
        String newName = newId.asJavaString();
        this.defineAlias(newName, oldId.asJavaString());
        RubySymbol rubySymbol = newSym = newId instanceof RubySymbol ? (RubySymbol)newId : context.runtime.newSymbol(newName);
        if (this.isSingleton()) {
            ((MetaClass)this).getAttached().callMethod(context, "singleton_method_added", newSym);
        } else {
            this.callMethod(context, "method_added", (IRubyObject)newSym);
        }
        return this;
    }

    @JRubyMethod(name={"undef_method"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule undef_method(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.undef(context, args2[i2].asJavaString());
        }
        return this;
    }

    @JRubyMethod(name={"module_eval", "class_eval"})
    public IRubyObject module_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this, block);
    }

    @JRubyMethod(name={"module_eval", "class_eval"})
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this, arg0, block);
    }

    @JRubyMethod(name={"module_eval", "class_eval"})
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this, arg0, arg1, block);
    }

    @JRubyMethod(name={"module_eval", "class_eval"})
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this, arg0, arg1, arg2, block);
    }

    @Deprecated
    public IRubyObject module_eval(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.specificEval(context, this, args2, block);
    }

    @JRubyMethod(name={"module_exec", "class_exec"})
    public IRubyObject module_exec(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, this, IRubyObject.NULL_ARRAY, block);
        }
        throw context.runtime.newLocalJumpErrorNoBlock();
    }

    @JRubyMethod(name={"module_exec", "class_exec"}, rest=true)
    public IRubyObject module_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, this, args2, block);
        }
        throw context.runtime.newLocalJumpErrorNoBlock();
    }

    @JRubyMethod(name={"remove_method"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule remove_method(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.removeMethod(context, args2[i2].asJavaString());
        }
        return this;
    }

    public static void marshalTo(RubyModule module, MarshalStream output) throws IOException {
        output.registerLinkTarget(module);
        output.writeString(MarshalStream.getPathFromClass(module));
    }

    public static RubyModule unmarshalFrom(UnmarshalStream input) throws IOException {
        String name2 = RubyString.byteListToString(input.unmarshalString());
        RubyModule result2 = UnmarshalStream.getModuleFromPath(input.getRuntime(), name2);
        input.registerLinkTarget(result2);
        return result2;
    }

    @JRubyMethod(name={"nesting"}, reads={FrameField.SCOPE}, meta=true)
    public static RubyArray nesting(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby runtime = context.runtime;
        RubyClass object = runtime.getObject();
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyArray result2 = runtime.newArray();
        StaticScope current2 = scope;
        while (current2.getModule() != object) {
            result2.append(current2.getModule());
            current2 = current2.getPreviousCRefScope();
        }
        return result2;
    }

    private void doIncludeModule(RubyModule baseModule) {
        List<RubyModule> modulesToInclude = this.gatherModules(baseModule);
        RubyModule currentInclusionPoint = this;
        block0: for (RubyModule nextModule : modulesToInclude) {
            this.checkForCyclicInclude(nextModule);
            boolean superclassSeen = false;
            for (RubyClass nextClass = this.getSuperClass(); nextClass != null; nextClass = nextClass.getSuperClass()) {
                if (this.doesTheClassWrapTheModule(nextClass, nextModule)) {
                    if (superclassSeen) continue block0;
                    currentInclusionPoint = nextClass;
                    continue block0;
                }
                superclassSeen = true;
            }
            currentInclusionPoint = this.proceedWithInclude(currentInclusionPoint, nextModule);
        }
    }

    private boolean doesTheClassWrapTheModule(RubyClass theClass, RubyModule theModule) {
        return theClass.isIncluded() && theClass.getNonIncludedClass() == theModule.getNonIncludedClass();
    }

    private List<RubyModule> gatherModules(RubyModule baseModule) {
        ArrayList<RubyModule> modulesToInclude = new ArrayList<RubyModule>();
        while (baseModule != null) {
            modulesToInclude.add(baseModule);
            baseModule = baseModule.getSuperClass();
        }
        return modulesToInclude;
    }

    private RubyModule proceedWithInclude(RubyModule insertAbove, RubyModule moduleToInclude) {
        IncludedModuleWrapper wrapper = new IncludedModuleWrapper(this.getRuntime(), insertAbove.getSuperClass(), moduleToInclude.getNonIncludedClass());
        if (insertAbove instanceof RubyClass) {
            RubyClass insertAboveClass = (RubyClass)insertAbove;
            if (insertAboveClass.getSuperClass() != null) {
                insertAboveClass.getSuperClass().replaceSubclass(insertAboveClass, wrapper);
            }
            wrapper.addSubclass(insertAboveClass);
        }
        insertAbove.setSuperClass(wrapper);
        insertAbove = insertAbove.getSuperClass();
        return insertAbove;
    }

    @JRubyMethod(name={"class_variable_defined?"}, required=1)
    public IRubyObject class_variable_defined_p(ThreadContext context, IRubyObject var) {
        String internedName = this.validateClassVariable(var.asJavaString().intern());
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(internedName)) continue;
            return context.runtime.getTrue();
        } while ((module = module.getSuperClass()) != null);
        return context.runtime.getFalse();
    }

    @JRubyMethod(name={"class_variable_get"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject class_variable_get(IRubyObject var) {
        return this.getClassVar(this.validateClassVariable(var.asJavaString()).intern());
    }

    @JRubyMethod(name={"class_variable_get"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject class_variable_get19(IRubyObject var) {
        return this.class_variable_get(var);
    }

    @JRubyMethod(name={"class_variable_set"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject class_variable_set(IRubyObject var, IRubyObject value2) {
        return this.setClassVar(this.validateClassVariable(var.asJavaString()).intern(), value2);
    }

    @JRubyMethod(name={"class_variable_set"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject class_variable_set19(IRubyObject var, IRubyObject value2) {
        return this.class_variable_set(var, value2);
    }

    @JRubyMethod(name={"remove_class_variable"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject remove_class_variable(ThreadContext context, IRubyObject name2) {
        return this.removeClassVariable(name2.asJavaString());
    }

    @JRubyMethod(name={"remove_class_variable"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject remove_class_variable19(ThreadContext context, IRubyObject name2) {
        return this.remove_class_variable(context, name2);
    }

    @JRubyMethod(name={"class_variables"}, compat=CompatVersion.RUBY1_8)
    public RubyArray class_variables(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyArray ary = runtime.newArray();
        Collection<String> names2 = this.classVariablesCommon();
        ary.addAll(names2);
        return ary;
    }

    @JRubyMethod(name={"class_variables"}, compat=CompatVersion.RUBY1_9)
    public RubyArray class_variables19(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyArray ary = runtime.newArray();
        Collection<String> names2 = this.classVariablesCommon();
        for (String name2 : names2) {
            ary.add(runtime.newSymbol(name2));
        }
        return ary;
    }

    private Collection<String> classVariablesCommon() {
        HashSet<String> names2 = new HashSet<String>();
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            names2.addAll(p2.getClassVariableNameList());
        }
        return names2;
    }

    @JRubyMethod(name={"const_defined?"}, required=1, compat=CompatVersion.RUBY1_8)
    public RubyBoolean const_defined_p(ThreadContext context, IRubyObject symbol) {
        return context.runtime.newBoolean(this.fastIsConstantDefined(this.validateConstant(symbol.asJavaString()).intern()));
    }

    @JRubyMethod(name={"const_defined?"}, required=1, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyBoolean const_defined_p19(ThreadContext context, IRubyObject[] args2) {
        IRubyObject symbol = args2[0];
        boolean inherit = args2.length == 1 || !args2[1].isNil() && args2[1].isTrue();
        return context.runtime.newBoolean(this.fastIsConstantDefined19(this.validateConstant(symbol.asJavaString()).intern(), inherit));
    }

    @JRubyMethod(name={"const_get"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject const_get(IRubyObject symbol) {
        return this.getConstant(this.validateConstant(symbol.asJavaString()));
    }

    @JRubyMethod(name={"const_get"}, required=1, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject const_get_1_9(ThreadContext context, IRubyObject[] args2) {
        IRubyObject symbol = args2[0];
        boolean inherit = args2.length == 1 || !args2[1].isNil() && args2[1].isTrue();
        return this.getConstant(this.validateConstant(symbol.asJavaString()), inherit, inherit);
    }

    @JRubyMethod(name={"const_get"}, required=1, optional=1, compat=CompatVersion.RUBY2_0)
    public IRubyObject const_get_2_0(ThreadContext context, IRubyObject[] args2) {
        int sep;
        String symbol = args2[0].asJavaString();
        boolean inherit = args2.length == 1 || !args2[1].isNil() && args2[1].isTrue();
        RubyModule mod = this;
        while ((sep = symbol.indexOf("::")) != -1) {
            String segment = symbol.substring(0, sep);
            symbol = symbol.substring(sep + 2);
            IRubyObject obj = mod.getConstant(this.validateConstant(segment), inherit, inherit);
            if (obj instanceof RubyModule) {
                mod = (RubyModule)obj;
                continue;
            }
            throw this.getRuntime().newTypeError(segment + " does not refer to class/module");
        }
        return mod.getConstant(this.validateConstant(symbol), inherit, inherit);
    }

    @JRubyMethod(name={"const_set"}, required=2)
    public IRubyObject const_set(IRubyObject symbol, IRubyObject value2) {
        IRubyObject constant = this.setConstant(this.validateConstant(symbol.asJavaString()).intern(), value2);
        if (constant instanceof RubyModule) {
            ((RubyModule)constant).calculateName();
        }
        return constant;
    }

    @JRubyMethod(name={"remove_const"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject remove_const(ThreadContext context, IRubyObject rubyName) {
        String name2 = this.validateConstant(rubyName.asJavaString());
        IRubyObject value2 = this.deleteConstant(name2);
        if (value2 != null) {
            this.invalidateConstantCache(name2);
            if (value2 != UNDEF) {
                return value2;
            }
            this.removeAutoload(name2);
            return context.runtime.getNil();
        }
        if (this.hasConstantInHierarchy(name2)) {
            throw this.cannotRemoveError(name2);
        }
        throw context.runtime.newNameError("constant " + name2 + " not defined for " + this.getName(), name2);
    }

    private boolean hasConstantInHierarchy(String name2) {
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.hasConstant(name2)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"const_missing"}, required=1)
    public IRubyObject const_missing(ThreadContext context, IRubyObject rubyName, Block block) {
        Ruby runtime = context.runtime;
        String name2 = this != runtime.getObject() ? this.getName() + "::" + rubyName.asJavaString() : rubyName.asJavaString();
        throw runtime.newNameErrorObject("uninitialized constant " + name2, runtime.newSymbol(name2));
    }

    @JRubyMethod(name={"constants"}, compat=CompatVersion.RUBY1_8)
    public RubyArray constants(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyArray array = runtime.newArray();
        Collection<String> constantNames = this.constantsCommon(runtime, true, true);
        array.addAll(constantNames);
        return array;
    }

    @JRubyMethod(name={"constants"}, compat=CompatVersion.RUBY1_9)
    public RubyArray constants19(ThreadContext context) {
        return this.constantsCommon19(context, true, true);
    }

    @JRubyMethod(name={"constants"}, compat=CompatVersion.RUBY1_9)
    public RubyArray constants19(ThreadContext context, IRubyObject allConstants) {
        return this.constantsCommon19(context, false, allConstants.isTrue());
    }

    public RubyArray constantsCommon19(ThreadContext context, boolean replaceModule, boolean allConstants) {
        Ruby runtime = context.runtime;
        RubyArray array = runtime.newArray();
        Collection<String> constantNames = this.constantsCommon(runtime, replaceModule, allConstants, false);
        for (String name2 : constantNames) {
            array.add(runtime.newSymbol(name2));
        }
        return array;
    }

    public Collection<String> constantsCommon(Ruby runtime, boolean replaceModule, boolean allConstants) {
        return this.constantsCommon(runtime, replaceModule, allConstants, true);
    }

    public Collection<String> constantsCommon(Ruby runtime, boolean replaceModule, boolean allConstants, boolean includePrivate) {
        RubyClass objectClass = runtime.getObject();
        Collection<Object> constantNames = new HashSet();
        if (allConstants) {
            if (replaceModule && runtime.getModule() == this || objectClass == this) {
                constantNames = objectClass.getConstantNames(includePrivate);
            } else {
                HashSet<String> names2 = new HashSet<String>();
                for (RubyModule module = this; module != null && module != objectClass; module = module.getSuperClass()) {
                    names2.addAll(module.getConstantNames(includePrivate));
                }
                constantNames = names2;
            }
        } else {
            constantNames = replaceModule && runtime.getModule() == this || objectClass == this ? objectClass.getConstantNames(includePrivate) : this.getConstantNames(includePrivate);
        }
        return constantNames;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject private_constant(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        this.setConstantVisibility(context, this.validateConstant(name2), true);
        this.invalidateConstantCache(name2);
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9, required=1, rest=true)
    public IRubyObject private_constant(ThreadContext context, IRubyObject[] rubyNames) {
        for (IRubyObject rubyName : rubyNames) {
            String name2 = rubyName.asJavaString();
            this.setConstantVisibility(context, this.validateConstant(name2), true);
            this.invalidateConstantCache(name2);
        }
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject public_constant(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        this.setConstantVisibility(context, this.validateConstant(name2), false);
        this.invalidateConstantCache(name2);
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9, required=1, rest=true)
    public IRubyObject public_constant(ThreadContext context, IRubyObject[] rubyNames) {
        for (IRubyObject rubyName : rubyNames) {
            String name2 = rubyName.asJavaString();
            this.setConstantVisibility(context, this.validateConstant(name2), false);
            this.invalidateConstantCache(name2);
        }
        return this;
    }

    private void setConstantVisibility(ThreadContext context, String name2, boolean hidden) {
        ConstantEntry entry = this.getConstantMap().get(name2);
        if (entry == null) {
            throw context.runtime.newNameError("constant " + this.getName() + "::" + name2 + " not defined", name2);
        }
        this.getConstantMapForWrite().put(name2, new ConstantEntry(entry.value, hidden));
    }

    public IRubyObject setClassVar(String name2, IRubyObject value2) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            return module.storeClassVariable(name2, value2);
        } while ((module = module.getSuperClass()) != null);
        return this.storeClassVariable(name2, value2);
    }

    @Deprecated
    public IRubyObject fastSetClassVar(String internedName, IRubyObject value2) {
        return this.setClassVar(internedName, value2);
    }

    public IRubyObject getClassVar(String name2) {
        assert (IdUtil.isClassVariable(name2));
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.fetchClassVariable(name2)) == null) continue;
            return value2;
        } while ((module = module.getSuperClass()) != null);
        throw this.getRuntime().newNameError("uninitialized class variable " + name2 + " in " + this.getName(), name2);
    }

    @Deprecated
    public IRubyObject fastGetClassVar(String internedName) {
        return this.getClassVar(internedName);
    }

    public boolean isClassVarDefined(String name2) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    @Deprecated
    public boolean fastIsClassVarDefined(String internedName) {
        return this.isClassVarDefined(internedName);
    }

    @Deprecated
    public IRubyObject removeCvar(IRubyObject name2) {
        return this.removeClassVariable(name2.asJavaString());
    }

    public IRubyObject removeClassVariable(String name2) {
        String javaName = this.validateClassVariable(name2);
        IRubyObject value2 = this.deleteClassVariable(javaName);
        if (value2 != null) {
            return value2;
        }
        if (this.isClassVarDefined(javaName)) {
            throw this.cannotRemoveError(javaName);
        }
        throw this.getRuntime().newNameError("class variable " + javaName + " not defined for " + this.getName(), javaName);
    }

    public IRubyObject getConstantAtSpecial(String name2) {
        IRubyObject value2 = this == this.getRuntime().getObject() ? this.getConstantNoConstMissing(name2) : this.fetchConstant(name2);
        return value2 == UNDEF ? this.resolveUndefConstant(name2) : value2;
    }

    public IRubyObject getConstantAt(String name2) {
        return this.getConstantAt(name2, true);
    }

    public IRubyObject getConstantAt(String name2, boolean includePrivate) {
        IRubyObject value2 = this.fetchConstant(name2, includePrivate);
        return value2 == UNDEF ? this.resolveUndefConstant(name2) : value2;
    }

    @Deprecated
    public IRubyObject fastGetConstantAt(String internedName) {
        return this.getConstantAt(internedName);
    }

    public IRubyObject getConstant(String name2) {
        return this.getConstant(name2, true);
    }

    public IRubyObject getConstant(String name2, boolean inherit) {
        return this.getConstant(name2, inherit, true);
    }

    public IRubyObject getConstant(String name2, boolean inherit, boolean includeObject) {
        IRubyObject value2 = this.getConstantNoConstMissing(name2, inherit, includeObject);
        Ruby runtime = this.getRuntime();
        return value2 == null ? this.callMethod(runtime.getCurrentContext(), "const_missing", (IRubyObject)runtime.newSymbol(name2)) : value2;
    }

    @Deprecated
    public IRubyObject fastGetConstant(String internedName) {
        return this.getConstant(internedName);
    }

    @Deprecated
    public IRubyObject fastGetConstant(String internedName, boolean inherit) {
        return this.getConstant(internedName, inherit);
    }

    public IRubyObject getConstantNoConstMissing(String name2) {
        return this.getConstantNoConstMissing(name2, true);
    }

    public IRubyObject getConstantNoConstMissing(String name2, boolean inherit) {
        return this.getConstantNoConstMissing(name2, inherit, true);
    }

    public IRubyObject getConstantNoConstMissing(String name2, boolean inherit, boolean includeObject) {
        assert (IdUtil.isConstant(name2));
        IRubyObject constant = this.iterateConstantNoConstMissing(name2, this, inherit);
        if (constant == null && !this.isClass() && includeObject) {
            constant = this.iterateConstantNoConstMissing(name2, this.getRuntime().getObject(), inherit);
        }
        return constant;
    }

    private IRubyObject iterateConstantNoConstMissing(String name2, RubyModule init, boolean inherit) {
        for (RubyModule p2 = init; p2 != null; p2 = p2.getSuperClass()) {
            IRubyObject value2 = p2.getConstantAt(name2);
            if (value2 != null) {
                return value2 == UNDEF ? null : value2;
            }
            if (!inherit) break;
        }
        return null;
    }

    public IRubyObject getConstantFrom(String name2) {
        IRubyObject value2 = this.getConstantFromNoConstMissing(name2);
        return value2 != null ? value2 : this.getConstantFromConstMissing(name2);
    }

    @Deprecated
    public IRubyObject fastGetConstantFrom(String internedName) {
        return this.getConstantFrom(internedName);
    }

    public IRubyObject getConstantFromNoConstMissing(String name2) {
        return this.getConstantFromNoConstMissing(name2, true);
    }

    public IRubyObject getConstantFromNoConstMissing(String name2, boolean includePrivate) {
        assert (name2 == name2.intern()) : name2 + " is not interned";
        assert (IdUtil.isConstant(name2));
        Ruby runtime = this.getRuntime();
        RubyClass objectClass = runtime.getObject();
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            IRubyObject value2 = p2.fetchConstant(name2, false);
            if (value2 == null) continue;
            if (value2 == UNDEF) {
                return p2.resolveUndefConstant(name2);
            }
            if (p2 == objectClass && this != objectClass) {
                String badCName = this.getName() + "::" + name2;
                runtime.getWarnings().warn(IRubyWarnings.ID.CONSTANT_BAD_REFERENCE, "toplevel constant " + name2 + " referenced by " + badCName);
            }
            return value2;
        }
        return null;
    }

    @Deprecated
    public IRubyObject fastGetConstantFromNoConstMissing(String internedName) {
        return this.getConstantFromNoConstMissing(internedName);
    }

    public IRubyObject getConstantFromConstMissing(String name2) {
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", (IRubyObject)this.getRuntime().fastNewSymbol(name2));
    }

    @Deprecated
    public IRubyObject fastGetConstantFromConstMissing(String internedName) {
        return this.getConstantFromConstMissing(internedName);
    }

    public IRubyObject resolveUndefConstant(String name2) {
        return this.getAutoloadConstant(name2);
    }

    public IRubyObject setConstantQuiet(String name2, IRubyObject value2) {
        return this.setConstantCommon(name2, value2, false);
    }

    public IRubyObject setConstant(String name2, IRubyObject value2) {
        return this.setConstantCommon(name2, value2, true);
    }

    private IRubyObject setConstantCommon(String name2, IRubyObject value2, boolean warn2) {
        RubyModule module;
        IRubyObject oldValue = this.fetchConstant(name2);
        if (oldValue != null) {
            if (oldValue == UNDEF) {
                this.setAutoloadConstant(name2, value2);
            } else {
                if (warn2) {
                    this.getRuntime().getWarnings().warn(IRubyWarnings.ID.CONSTANT_ALREADY_INITIALIZED, "already initialized constant " + name2);
                }
                this.storeConstant(name2, value2);
            }
        } else {
            this.storeConstant(name2, value2);
        }
        this.invalidateConstantCache(name2);
        if (value2 instanceof RubyModule && (module = (RubyModule)value2) != this && module.getBaseName() == null) {
            module.setBaseName(name2);
            module.setParent(this);
        }
        return value2;
    }

    @Deprecated
    public IRubyObject fastSetConstant(String internedName, IRubyObject value2) {
        return this.setConstant(internedName, value2);
    }

    @Extension
    public void defineConstant(String name2, IRubyObject value2) {
        assert (value2 != null);
        if (!IdUtil.isValidConstantName(name2)) {
            throw this.getRuntime().newNameError("bad constant name " + name2, name2);
        }
        this.setConstant(name2, value2);
    }

    public boolean isConstantDefined(String name2) {
        assert (IdUtil.isConstant(name2));
        boolean isObject = this == this.getRuntime().getObject();
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.constantTableFetch(name2)) == null) continue;
            if (value2 != UNDEF) {
                return true;
            }
            return this.getAutoloadMap().get(name2) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsConstantDefined(String internedName) {
        assert (internedName.equals(internedName.intern())) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        boolean isObject = this == this.getRuntime().getObject();
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.constantTableFetch(internedName)) == null) continue;
            if (value2 != UNDEF) {
                return true;
            }
            return this.getAutoloadMap().get(internedName) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsConstantDefined19(String internedName) {
        return this.fastIsConstantDefined19(internedName, true);
    }

    public boolean fastIsConstantDefined19(String internedName, boolean inherit) {
        assert (internedName.equals(internedName.intern())) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            IRubyObject value2 = module.constantTableFetch(internedName);
            if (value2 != null) {
                if (value2 != UNDEF) {
                    return true;
                }
                return this.getAutoloadMap().get(internedName) != null;
            }
            if (!inherit) break;
        }
        return false;
    }

    private RaiseException cannotRemoveError(String id2) {
        return this.getRuntime().newNameError("cannot remove " + id2 + " for " + this.getName(), id2);
    }

    public boolean hasInternalModuleVariable(String name2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasInternalVariable(name2)) continue;
            return true;
        }
        return false;
    }

    public IRubyObject searchInternalModuleVariable(String name2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            IRubyObject value2 = (IRubyObject)module.getInternalVariable(name2);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public void setInternalModuleVariable(String name2, IRubyObject value2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasInternalVariable(name2)) continue;
            module.setInternalVariable(name2, value2);
            return;
        }
        this.setInternalVariable(name2, value2);
    }

    protected Map<String, IRubyObject> getClassVariables() {
        if (CLASSVARS_UPDATER == null) {
            return this.getClassVariablesForWriteSynchronized();
        }
        return this.getClassVariablesForWriteAtomic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IRubyObject> getClassVariablesForWriteSynchronized() {
        Map<String, IRubyObject> myClassVars = this.classVariables;
        if (myClassVars == Collections.EMPTY_MAP) {
            RubyModule rubyModule = this;
            synchronized (rubyModule) {
                myClassVars = this.classVariables;
                if (myClassVars == Collections.EMPTY_MAP) {
                    this.classVariables = new ConcurrentHashMap<String, IRubyObject>(4, 0.75f, 2);
                    return this.classVariables;
                }
                return myClassVars;
            }
        }
        return myClassVars;
    }

    private Map<String, IRubyObject> getClassVariablesForWriteAtomic() {
        ConcurrentHashMap<String, IRubyObject> newClassVars;
        Map<String, IRubyObject> myClassVars;
        do {
            if ((myClassVars = this.classVariables) != Collections.EMPTY_MAP) {
                return myClassVars;
            }
            newClassVars = new ConcurrentHashMap<String, IRubyObject>(4, 0.75f, 2);
        } while (!CLASSVARS_UPDATER.compareAndSet(this, myClassVars, newClassVars));
        return newClassVars;
    }

    protected Map<String, IRubyObject> getClassVariablesForRead() {
        return this.classVariables;
    }

    public boolean hasClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.getClassVariablesForRead().containsKey(name2);
    }

    @Deprecated
    public boolean fastHasClassVariable(String internedName) {
        return this.hasClassVariable(internedName);
    }

    public IRubyObject fetchClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.getClassVariablesForRead().get(name2);
    }

    @Deprecated
    public IRubyObject fastFetchClassVariable(String internedName) {
        return this.fetchClassVariable(internedName);
    }

    public IRubyObject storeClassVariable(String name2, IRubyObject value2) {
        assert (IdUtil.isClassVariable(name2) && value2 != null);
        this.ensureClassVariablesSettable();
        this.getClassVariables().put(name2, value2);
        return value2;
    }

    @Deprecated
    public IRubyObject fastStoreClassVariable(String internedName, IRubyObject value2) {
        return this.storeClassVariable(internedName, value2);
    }

    public IRubyObject deleteClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        this.ensureClassVariablesSettable();
        return this.getClassVariablesForRead().remove(name2);
    }

    public List<String> getClassVariableNameList() {
        return new ArrayList<String>(this.getClassVariablesForRead().keySet());
    }

    protected final String validateClassVariable(String name2) {
        if (IdUtil.isValidClassVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`" + name2 + "' is not allowed as a class variable name", name2);
    }

    protected final void ensureClassVariablesSettable() {
        Ruby runtime = this.getRuntime();
        if (!this.isFrozen()) {
            return;
        }
        if (this instanceof RubyModule) {
            throw runtime.newFrozenError("class/module ");
        }
        throw runtime.newFrozenError("");
    }

    public boolean hasConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        return this.constantTableContains(name2);
    }

    @Deprecated
    public boolean fastHasConstant(String internedName) {
        return this.hasConstant(internedName);
    }

    public IRubyObject fetchConstant(String name2) {
        return this.fetchConstant(name2, true);
    }

    public IRubyObject fetchConstant(String name2, boolean includePrivate) {
        assert (IdUtil.isConstant(name2));
        ConstantEntry entry = this.constantEntryFetch(name2);
        if (entry == null) {
            return null;
        }
        if (entry.hidden && !includePrivate) {
            throw this.getRuntime().newNameError("private constant " + this.getName() + "::" + name2 + " referenced", name2);
        }
        return entry.value;
    }

    @Deprecated
    public IRubyObject fastFetchConstant(String internedName) {
        return this.fetchConstant(internedName);
    }

    public IRubyObject storeConstant(String name2, IRubyObject value2) {
        assert (IdUtil.isConstant(name2)) : name2 + " is not a valid constant name";
        assert (value2 != null) : "value is null";
        this.ensureConstantsSettable();
        return this.constantTableStore(name2, value2);
    }

    @Deprecated
    public IRubyObject fastStoreConstant(String internedName, IRubyObject value2) {
        return this.storeConstant(internedName, value2);
    }

    public IRubyObject deleteConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        this.ensureConstantsSettable();
        return this.constantTableRemove(name2);
    }

    @Deprecated
    public List<Variable<IRubyObject>> getStoredConstantList() {
        return null;
    }

    @Deprecated
    public List<String> getStoredConstantNameList() {
        return new ArrayList<String>(this.getConstantMap().keySet());
    }

    public Collection<String> getConstantNames() {
        return this.getConstantMap().keySet();
    }

    public Collection<String> getConstantNames(boolean includePrivate) {
        if (includePrivate) {
            return this.getConstantNames();
        }
        if (this.getConstantMap().size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> publicNames = new HashSet<String>(this.getConstantMap().size());
        for (Map.Entry<String, ConstantEntry> entry : this.getConstantMap().entrySet()) {
            if (entry.getValue().hidden) continue;
            publicNames.add(entry.getKey());
        }
        return publicNames;
    }

    protected final String validateConstant(String name2) {
        if (this.getRuntime().is1_9() ? IdUtil.isValidConstantName19(name2) : IdUtil.isValidConstantName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("wrong constant name " + name2, name2);
    }

    protected final void ensureConstantsSettable() {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError("class/module ");
        }
    }

    protected boolean constantTableContains(String name2) {
        return this.getConstantMap().containsKey(name2);
    }

    protected IRubyObject constantTableFetch(String name2) {
        ConstantEntry entry = this.getConstantMap().get(name2);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    protected ConstantEntry constantEntryFetch(String name2) {
        return this.getConstantMap().get(name2);
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2) {
        Map<String, ConstantEntry> constMap = this.getConstantMapForWrite();
        boolean hidden = false;
        ConstantEntry entry = constMap.get(name2);
        if (entry != null) {
            hidden = entry.hidden;
        }
        constMap.put(name2, new ConstantEntry(value2, hidden));
        return value2;
    }

    protected IRubyObject constantTableRemove(String name2) {
        ConstantEntry entry = this.getConstantMapForWrite().remove(name2);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    protected void defineAutoload(String name2, IAutoloadMethod loadMethod) {
        Autoload existingAutoload = this.getAutoloadMap().get(name2);
        if (existingAutoload == null || existingAutoload.getValue() == null) {
            this.storeConstant(name2, RubyObject.UNDEF);
            this.getAutoloadMapForWrite().put(name2, new Autoload(loadMethod));
        }
    }

    protected IRubyObject finishAutoload(String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 != null) {
            IRubyObject value2 = autoload2.getValue();
            if (value2 != null) {
                this.storeConstant(name2, value2);
            }
            this.removeAutoload(name2);
            return value2;
        }
        return null;
    }

    public IRubyObject getAutoloadConstant(String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 == null) {
            return null;
        }
        return autoload2.getConstant(this.getRuntime().getCurrentContext());
    }

    private void setAutoloadConstant(String name2, IRubyObject value2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 != null) {
            if (!autoload2.setConstant(this.getRuntime().getCurrentContext(), value2)) {
                this.storeConstant(name2, value2);
                this.removeAutoload(name2);
            }
        } else {
            this.storeConstant(name2, value2);
        }
    }

    private void removeAutoload(String name2) {
        this.getAutoloadMapForWrite().remove(name2);
    }

    protected String getAutoloadFile(String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 != null) {
            return autoload2.getFile();
        }
        return null;
    }

    private static void define(RubyModule module, JavaMethodDescriptor desc, String simpleName, DynamicMethod dynamicMethod) {
        block22: {
            String baseName;
            RubyClass singletonClass;
            JRubyMethod jrubyMethod;
            block21: {
                String baseName2;
                jrubyMethod = desc.anno;
                boolean frame = false;
                boolean scope = false;
                if (jrubyMethod.frame()) {
                    frame = true;
                }
                if (jrubyMethod.scope()) {
                    scope = true;
                }
                for (FrameField field2 : jrubyMethod.reads()) {
                    frame |= field2.needsFrame();
                    scope |= field2.needsScope();
                }
                for (FrameField field2 : jrubyMethod.writes()) {
                    frame |= field2.needsFrame();
                    scope |= field2.needsScope();
                }
                if (frame) {
                    HashSet<String> frameAwareMethods = new HashSet<String>();
                    AnnotationHelper.addMethodNamesToSet(frameAwareMethods, jrubyMethod, simpleName);
                    ASTInspector.FRAME_AWARE_METHODS.addAll(frameAwareMethods);
                }
                if (scope) {
                    HashSet<String> scopeAwareMethods = new HashSet<String>();
                    AnnotationHelper.addMethodNamesToSet(scopeAwareMethods, jrubyMethod, simpleName);
                    ASTInspector.SCOPE_AWARE_METHODS.addAll(scopeAwareMethods);
                }
                if (!jrubyMethod.meta()) break block21;
                singletonClass = module.getSingletonClass();
                dynamicMethod.setImplementationClass(singletonClass);
                if (jrubyMethod.name().length == 0) {
                    baseName2 = desc.name;
                    singletonClass.addMethod(baseName2, dynamicMethod);
                } else {
                    baseName2 = jrubyMethod.name()[0];
                    String[] arr$ = jrubyMethod.name();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String name2 = arr$[i$];
                        singletonClass.addMethod(name2, dynamicMethod);
                    }
                }
                if (jrubyMethod.alias().length <= 0) break block22;
                for (String alias2 : jrubyMethod.alias()) {
                    singletonClass.defineAlias(alias2, baseName2);
                }
                break block22;
            }
            if (jrubyMethod.name().length == 0) {
                baseName = desc.name;
                module.addMethod(baseName, dynamicMethod);
            } else {
                baseName = jrubyMethod.name()[0];
                String[] arr$ = jrubyMethod.name();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String name3 = arr$[i$];
                    module.addMethod(name3, dynamicMethod);
                }
            }
            if (jrubyMethod.alias().length > 0) {
                for (String alias3 : jrubyMethod.alias()) {
                    module.defineAlias(alias3, baseName);
                }
            }
            if (jrubyMethod.module()) {
                singletonClass = module.getSingletonClass();
                DynamicMethod moduleMethod = dynamicMethod.dup();
                moduleMethod.setVisibility(Visibility.PUBLIC);
                if (jrubyMethod.name().length == 0) {
                    baseName = desc.name;
                    singletonClass.addMethod(desc.name, moduleMethod);
                } else {
                    baseName = jrubyMethod.name()[0];
                    for (String name4 : jrubyMethod.name()) {
                        singletonClass.addMethod(name4, moduleMethod);
                    }
                }
                if (jrubyMethod.alias().length > 0) {
                    for (String alias4 : jrubyMethod.alias()) {
                        singletonClass.defineAlias(alias4, baseName);
                    }
                }
            }
        }
    }

    @Deprecated
    public IRubyObject initialize(Block block) {
        return this.initialize(this.getRuntime().getCurrentContext());
    }

    public void setJavaProxy(boolean javaProxy) {
        this.javaProxy = javaProxy;
    }

    public boolean getJavaProxy() {
        return this.javaProxy;
    }

    public boolean getCacheProxy() {
        return this.getFlag(32);
    }

    public void setCacheProxy(boolean cacheProxy) {
        this.setFlag(32, cacheProxy);
    }

    public void visitInterpretedMethods(NodeVisitor visitor) {
        RubyModule cls = this;
        while (cls != null) {
            RubyModule.visitMethods(visitor, cls);
            if (!(cls instanceof RubyClass)) break;
            cls = ((RubyClass)cls).getSuperClass();
        }
    }

    public Set<String> discoverInstanceVariables() {
        HashSet<String> set = new HashSet<String>();
        RubyModule cls = this;
        while (cls != null) {
            for (DynamicMethod method2 : cls.getNonIncludedClass().getMethods().values()) {
                MethodData methodData = method2.getMethodData();
                set.addAll(methodData.getIvarNames());
            }
            if (!(cls instanceof RubyClass)) break;
            cls = ((RubyClass)cls).getSuperClass();
        }
        return set;
    }

    private static void visitMethods(NodeVisitor visitor, RubyModule mod) {
        for (DynamicMethod method2 : mod.getNonIncludedClass().getMethods().values()) {
            DynamicMethod realMethod = method2.getRealMethod();
            if (method2 instanceof DefaultMethod) {
                for (Node node : ((DefaultMethod)realMethod).getArgsNode().childNodes()) {
                    node.accept(visitor);
                }
                for (Node node : ((DefaultMethod)realMethod).getBodyNode().childNodes()) {
                    node.accept(visitor);
                }
                continue;
            }
            if (!(method2 instanceof InterpretedMethod)) continue;
            for (Node node : ((InterpretedMethod)realMethod).getArgsNode().childNodes()) {
                node.accept(visitor);
            }
            for (Node node : ((InterpretedMethod)realMethod).getBodyNode().childNodes()) {
                node.accept(visitor);
            }
        }
    }

    @Deprecated
    public void checkMethodBound(ThreadContext context, IRubyObject[] args2, Visibility visibility) {
    }

    @Deprecated
    public void defineMethod(String name2, Callback method2) {
        Visibility visibility = name2.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name2, new FullFunctionCallbackMethod(this, method2, visibility));
    }

    @Deprecated
    public void defineFastMethod(String name2, Callback method2) {
        Visibility visibility = name2.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, visibility));
    }

    @Deprecated
    public void defineFastMethod(String name2, Callback method2, Visibility visibility) {
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, visibility));
    }

    @Deprecated
    public void definePrivateMethod(String name2, Callback method2) {
        this.addMethod(name2, new FullFunctionCallbackMethod(this, method2, Visibility.PRIVATE));
    }

    @Deprecated
    public void defineFastPrivateMethod(String name2, Callback method2) {
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, Visibility.PRIVATE));
    }

    @Deprecated
    public void defineFastProtectedMethod(String name2, Callback method2) {
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, Visibility.PROTECTED));
    }

    @Deprecated
    public void defineModuleFunction(String name2, Callback method2) {
        this.definePrivateMethod(name2, method2);
        this.getSingletonClass().defineMethod(name2, method2);
    }

    @Deprecated
    public void definePublicModuleFunction(String name2, Callback method2) {
        this.defineMethod(name2, method2);
        this.getSingletonClass().defineMethod(name2, method2);
    }

    @Deprecated
    public void defineFastModuleFunction(String name2, Callback method2) {
        this.defineFastPrivateMethod(name2, method2);
        this.getSingletonClass().defineFastMethod(name2, method2);
    }

    @Deprecated
    public void defineFastPublicModuleFunction(String name2, Callback method2) {
        this.defineFastMethod(name2, method2);
        this.getSingletonClass().defineFastMethod(name2, method2);
    }

    static {
        AtomicReferenceFieldUpdater<RubyModule, Map> updater;
        block2: {
            LOG = LoggerFactory.getLogger("RubyModule");
            SCOPE_CAPTURING_METHODS = new HashSet<String>(Arrays.asList("eval", "module_eval", "class_eval", "instance_eval", "module_exec", "class_exec", "instance_exec", "binding", "local_variables"));
            MODULE_ALLOCATOR = new ObjectAllocator(){

                @Override
                public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                    return new RubyModule(runtime, klass);
                }
            };
            NormalCacheEntryFactory = new CacheEntryFactory(){

                @Override
                public CacheEntry newCacheEntry(DynamicMethod method2, int token) {
                    return new CacheEntry(method2, token);
                }
            };
            updater = null;
            try {
                updater = AtomicReferenceFieldUpdater.newUpdater(RubyModule.class, Map.class, "classVariables");
            }
            catch (RuntimeException re) {
                if (re.getCause() instanceof AccessControlException) break block2;
                throw re;
            }
        }
        CLASSVARS_UPDATER = updater;
    }

    private class Autoload {
        private volatile ThreadContext ctx = null;
        private final Object ctxLock = new Object();
        private volatile IRubyObject value = null;
        private final IAutoloadMethod loadMethod;

        Autoload(IAutoloadMethod loadMethod) {
            this.loadMethod = loadMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IRubyObject getConstant(ThreadContext ctx) {
            Object object = this.ctxLock;
            synchronized (object) {
                if (this.ctx == null) {
                    this.ctx = ctx;
                } else if (this.isSelf(ctx)) {
                    return this.getValue();
                }
                this.getLoadMethod().load(ctx.runtime);
            }
            return this.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setConstant(ThreadContext ctx, IRubyObject newValue) {
            Object object = this.ctxLock;
            synchronized (object) {
                boolean isSelf = this.isSelf(ctx);
                if (isSelf) {
                    this.value = newValue;
                }
                return isSelf;
            }
        }

        IRubyObject getValue() {
            return this.value;
        }

        String getFile() {
            return this.getLoadMethod().file();
        }

        private IAutoloadMethod getLoadMethod() {
            return this.loadMethod;
        }

        private boolean isSelf(ThreadContext rhs) {
            return this.ctx != null && this.ctx.getThread() == rhs.getThread();
        }
    }

    public static class ConstantEntry {
        public final IRubyObject value;
        public final boolean hidden;

        public ConstantEntry(IRubyObject value2, boolean hidden) {
            this.value = value2;
            this.hidden = hidden;
        }

        public ConstantEntry dup() {
            return new ConstantEntry(this.value, this.hidden);
        }
    }

    public static class RespondToMissingMethod
    extends JavaMethod.JavaMethodNBlock {
        final CallSite site;

        public RespondToMissingMethod(RubyModule implClass, Visibility vis, String methodName) {
            super(implClass, vis);
            this.site = new FunctionalCachingCallSite(methodName);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return this.site.call(context, self2, self2, args2, block);
        }

        public boolean equals(Object other) {
            if (!(other instanceof RespondToMissingMethod)) {
                return false;
            }
            RespondToMissingMethod rtmm = (RespondToMissingMethod)other;
            return this.site.methodName.equals(rtmm.site.methodName) && this.getImplementationClass() == rtmm.getImplementationClass();
        }
    }

    protected static class ProfilingCacheEntryFactory
    extends WrapperCacheEntryFactory {
        public ProfilingCacheEntryFactory(CacheEntryFactory previous) {
            super(previous);
        }

        @Override
        public CacheEntry newCacheEntry(DynamicMethod method2, int token) {
            if (method2.isUndefined()) {
                return new CacheEntry(method2, token);
            }
            CacheEntry delegated = this.previous.newCacheEntry(method2, token);
            return new CacheEntry(new ProfilingDynamicMethod(delegated.method), delegated.token);
        }
    }

    protected static class SynchronizedCacheEntryFactory
    extends WrapperCacheEntryFactory {
        public SynchronizedCacheEntryFactory(CacheEntryFactory previous) {
            super(previous);
        }

        @Override
        public CacheEntry newCacheEntry(DynamicMethod method2, int token) {
            if (method2.isUndefined()) {
                return new CacheEntry(method2, token);
            }
            CacheEntry delegated = this.previous.newCacheEntry(method2, token);
            return new CacheEntry(new SynchronizedDynamicMethod(delegated.method), delegated.token);
        }
    }

    protected static abstract class WrapperCacheEntryFactory
    extends CacheEntryFactory {
        protected final CacheEntryFactory previous;

        public WrapperCacheEntryFactory(CacheEntryFactory previous) {
            this.previous = previous;
        }

        public CacheEntryFactory getPrevious() {
            return this.previous;
        }
    }

    protected static abstract class CacheEntryFactory {
        protected CacheEntryFactory() {
        }

        public abstract CacheEntry newCacheEntry(DynamicMethod var1, int var2);

        public boolean hasCacheEntryFactory(Class cacheEntryFactoryClass) {
            CacheEntryFactory current2 = this;
            while (current2 instanceof WrapperCacheEntryFactory) {
                if (cacheEntryFactoryClass.isAssignableFrom(current2.getClass())) {
                    return true;
                }
                current2 = ((WrapperCacheEntryFactory)current2).getPrevious();
            }
            return cacheEntryFactoryClass.isAssignableFrom(current2.getClass());
        }
    }

    public static class MethodClumper {
        Map<String, List<JavaMethodDescriptor>> annotatedMethods = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> staticAnnotatedMethods = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> annotatedMethods1_8 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> staticAnnotatedMethods1_8 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> annotatedMethods1_9 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> staticAnnotatedMethods1_9 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> annotatedMethods2_0 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> staticAnnotatedMethods2_0 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> allAnnotatedMethods = new HashMap<String, List<JavaMethodDescriptor>>();

        public void clump(Class cls) {
            Method[] declaredMethods;
            for (Method method2 : declaredMethods = cls.getDeclaredMethods()) {
                JRubyMethod anno = method2.getAnnotation(JRubyMethod.class);
                if (anno == null || method2.isBridge()) continue;
                JavaMethodDescriptor desc = new JavaMethodDescriptor(method2);
                String name2 = anno.name().length == 0 ? method2.getName() : anno.name()[0];
                Map<String, List<JavaMethodDescriptor>> methodsHash = null;
                methodsHash = desc.isStatic ? (anno.compat() == CompatVersion.RUBY1_8 ? this.staticAnnotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? this.staticAnnotatedMethods1_9 : (anno.compat() == CompatVersion.RUBY2_0 ? this.staticAnnotatedMethods2_0 : this.staticAnnotatedMethods))) : (anno.compat() == CompatVersion.RUBY1_8 ? this.annotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? this.annotatedMethods1_9 : (anno.compat() == CompatVersion.RUBY2_0 ? this.annotatedMethods2_0 : this.annotatedMethods)));
                List<JavaMethodDescriptor> methodDescs = methodsHash.get(name2);
                if (methodDescs == null) {
                    methodDescs = new ArrayList<JavaMethodDescriptor>();
                    methodsHash.put(name2, methodDescs);
                }
                methodDescs.add(desc);
                methodDescs = this.allAnnotatedMethods.get(name2);
                if (methodDescs == null) {
                    methodDescs = new ArrayList<JavaMethodDescriptor>();
                    this.allAnnotatedMethods.put(name2, methodDescs);
                }
                methodDescs.add(desc);
            }
        }

        public Map<String, List<JavaMethodDescriptor>> getAllAnnotatedMethods() {
            return this.allAnnotatedMethods;
        }

        public Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods() {
            return this.annotatedMethods;
        }

        public Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods1_8() {
            return this.annotatedMethods1_8;
        }

        public Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods1_9() {
            return this.annotatedMethods1_9;
        }

        public Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods2_0() {
            return this.annotatedMethods2_0;
        }

        public Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods() {
            return this.staticAnnotatedMethods;
        }

        public Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods1_8() {
            return this.staticAnnotatedMethods1_8;
        }

        public Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods1_9() {
            return this.staticAnnotatedMethods1_9;
        }

        public Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods2_0() {
            return this.staticAnnotatedMethods2_0;
        }
    }

    public static final class JavaClassKindOf
    extends KindOf {
        private final Class klass;

        public JavaClassKindOf(Class klass) {
            this.klass = klass;
        }

        @Override
        public boolean isKindOf(IRubyObject obj, RubyModule type2) {
            return this.klass.isInstance(obj);
        }
    }

    public static class KindOf {
        public static final KindOf DEFAULT_KIND_OF = new KindOf();

        public boolean isKindOf(IRubyObject obj, RubyModule type2) {
            return obj.getMetaClass().hasModuleInHierarchy(type2);
        }
    }

    public static class ModuleKernelMethods {
        @JRubyMethod
        public static IRubyObject autoload(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
            return RubyKernel.autoload(recv2, arg0, arg1);
        }

        @JRubyMethod(name={"autoload?"})
        public static IRubyObject autoload_p(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
            return RubyKernel.autoload_p(context, recv2, arg0);
        }
    }
}

