/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.io.PrintStream;
import java.text.DecimalFormat;
import org.jruby.MetaClass;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.profile.FlatProfilePrinter;
import org.jruby.runtime.profile.GraphProfilePrinter;
import org.jruby.runtime.profile.HtmlProfilePrinter;
import org.jruby.runtime.profile.Invocation;
import org.jruby.runtime.profile.JsonProfilePrinter;
import org.jruby.runtime.profile.MethodData;
import org.jruby.runtime.profile.ProfileData;
import org.jruby.runtime.profile.ProfiledMethod;
import org.jruby.util.collections.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProfilePrinter {
    private final ProfileData profileData;
    private final Invocation topInvocation;
    private static final String PROFILER_START_METHOD = "JRuby::Profiler.start";
    private static final String PROFILER_STOP_METHOD = "JRuby::Profiler.stop";
    static final String PROFILER_PROFILE_METHOD = "JRuby::Profiler.profile";
    static final String PROFILER_PROFILED_CODE_METHOD = "JRuby::Profiler.profiled_code";

    public static ProfilePrinter newPrinter(RubyInstanceConfig.ProfilingMode mode2, ProfileData profileData) {
        return ProfilePrinter.newPrinter(mode2, profileData, null);
    }

    static ProfilePrinter newPrinter(RubyInstanceConfig.ProfilingMode mode2, ProfileData profileData, Invocation topInvocation) {
        if (topInvocation == null) {
            topInvocation = profileData.computeResults();
        }
        ProfilePrinter printer = mode2 == RubyInstanceConfig.ProfilingMode.FLAT ? new FlatProfilePrinter(profileData, topInvocation) : (mode2 == RubyInstanceConfig.ProfilingMode.GRAPH ? new GraphProfilePrinter(profileData, topInvocation) : (mode2 == RubyInstanceConfig.ProfilingMode.HTML ? new HtmlProfilePrinter(profileData, topInvocation) : (mode2 == RubyInstanceConfig.ProfilingMode.JSON ? new JsonProfilePrinter(profileData, topInvocation) : null)));
        return printer;
    }

    protected ProfilePrinter(ProfileData profileData) {
        this(profileData, profileData.computeResults());
    }

    protected ProfilePrinter(ProfileData profileData, Invocation topInvocation) {
        this.profileData = profileData;
        this.topInvocation = topInvocation;
    }

    public ProfileData getProfileData() {
        return this.profileData;
    }

    protected Invocation getTopInvocation() {
        return this.topInvocation;
    }

    public void printHeader(PrintStream out) {
    }

    public void printFooter(PrintStream out) {
    }

    public void printProfile(PrintStream out) {
        this.printProfile(out, false);
    }

    public abstract void printProfile(PrintStream var1, boolean var2);

    public void printProfile(RubyIO out) {
        this.printProfile(new PrintStream(out.getOutStream()));
    }

    boolean isProfilerInvocation(Invocation inv) {
        return this.isThisProfilerInvocation(inv.getMethodSerialNumber()) || inv.getParent() != null && this.isProfilerInvocation(inv.getParent());
    }

    boolean isThisProfilerInvocation(int serial2) {
        String start2 = PROFILER_START_METHOD;
        String stop2 = PROFILER_STOP_METHOD;
        String name2 = this.methodName(serial2);
        return name2.hashCode() == PROFILER_START_METHOD.hashCode() && name2.equals(PROFILER_START_METHOD) || name2.hashCode() == PROFILER_STOP_METHOD.hashCode() && name2.equals(PROFILER_STOP_METHOD);
    }

    public String getThreadName() {
        if (this.getProfileData().getThreadContext().getThread() == null) {
            return Thread.currentThread().getName();
        }
        return this.getProfileData().getThreadContext().getThread().getNativeThread().getName();
    }

    public String methodName(int serial2) {
        return this.profileData.methodName(serial2);
    }

    static String methodName(ProfiledMethod profileMethod) {
        String displayName;
        if (profileMethod != null) {
            String name2 = profileMethod.getName();
            DynamicMethod method2 = profileMethod.getMethod();
            if (name2 == null) {
                name2 = method2.getName();
            }
            displayName = ProfilePrinter.moduleHashMethod(method2.getImplementationClass(), name2);
        } else {
            displayName = "<unknown>";
        }
        return displayName;
    }

    protected static IntHashMap<MethodData> methodData(Invocation top) {
        IntHashMap<MethodData> methods2 = new IntHashMap<MethodData>();
        MethodData data2 = new MethodData(0);
        methods2.put(0, data2);
        data2.invocations.add(top);
        ProfilePrinter.methodData1(methods2, top);
        return methods2;
    }

    private static void methodData1(IntHashMap<MethodData> methods2, Invocation inv) {
        for (IntHashMap.Entry<Invocation> entry : inv.getChildren().entrySet()) {
            Invocation child = entry.getValue();
            int serial2 = child.getMethodSerialNumber();
            MethodData data2 = methods2.get(serial2);
            if (data2 == null) {
                data2 = new MethodData(serial2);
                methods2.put(serial2, data2);
            }
            data2.invocations.add(child);
            ProfilePrinter.methodData1(methods2, child);
        }
    }

    private static String moduleHashMethod(RubyModule module, String name2) {
        if (module instanceof MetaClass) {
            IRubyObject obj = ((MetaClass)module).getAttached();
            if (obj instanceof RubyModule) {
                return ((RubyModule)obj).getName() + "." + name2;
            }
            if (obj instanceof RubyObject) {
                return ((RubyObject)obj).getType().getName() + "(singleton)#" + name2;
            }
            return "unknown#" + name2;
        }
        if (module.isSingleton()) {
            return ((RubyClass)module).getRealClass().getName() + "(singleton)#" + name2;
        }
        if (module instanceof RubyClass) {
            return module.getName() + "#" + name2;
        }
        return module.getName() + "." + name2;
    }

    protected static void pad(PrintStream out, int size2, String body) {
        ProfilePrinter.pad(out, size2, body, true);
    }

    protected static void pad(PrintStream out, int size2, String body, boolean front) {
        int i2;
        if (front) {
            for (i2 = 0; i2 < size2 - body.length(); ++i2) {
                out.print(' ');
            }
        }
        out.print(body);
        if (!front) {
            for (i2 = 0; i2 < size2 - body.length(); ++i2) {
                out.print(' ');
            }
        }
    }

    protected static String nanoString(long nanoTime) {
        DecimalFormat formatter = new DecimalFormat("##0.00");
        return formatter.format((double)nanoTime / 1.0E9);
    }
}

