/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.operator.jcajce;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.jruby.org.bouncycastle.operator.AsymmetricKeyUnwrapper;
import org.jruby.org.bouncycastle.operator.GenericKey;
import org.jruby.org.bouncycastle.operator.OperatorException;
import org.jruby.org.bouncycastle.operator.jcajce.OperatorHelper;

public class JceAsymmetricKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private PrivateKey privKey;

    public JceAsymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey) {
        super(algorithmIdentifier);
        this.privKey = privateKey;
    }

    public JceAsymmetricKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceAsymmetricKeyUnwrapper setProvider(String string2) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string2));
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws OperatorException {
        try {
            Key key2 = null;
            Cipher cipher2 = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
            try {
                cipher2.init(4, this.privKey);
                key2 = cipher2.unwrap(byArray, algorithmIdentifier.getAlgorithm().getId(), 3);
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (ProviderException providerException) {
                // empty catch block
            }
            if (key2 == null) {
                cipher2.init(2, this.privKey);
                key2 = new SecretKeySpec(cipher2.doFinal(byArray), algorithmIdentifier.getAlgorithm().getId());
            }
            return new GenericKey(key2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new OperatorException("key invalid: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new OperatorException("illegal blocksize: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new OperatorException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
        }
    }
}

