/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jruby.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.jruby.org.bouncycastle.util.io.Streams;

public class CMSTypedStream {
    private static final int BUF_SIZ = 32768;
    private final ASN1ObjectIdentifier _oid;
    private final InputStream _in;

    public CMSTypedStream(InputStream inputStream) {
        this(PKCSObjectIdentifiers.data.getId(), inputStream, 32768);
    }

    public CMSTypedStream(String string2, InputStream inputStream) {
        this(new ASN1ObjectIdentifier(string2), inputStream, 32768);
    }

    public CMSTypedStream(String string2, InputStream inputStream, int n) {
        this(new ASN1ObjectIdentifier(string2), inputStream, n);
    }

    public CMSTypedStream(ASN1ObjectIdentifier aSN1ObjectIdentifier, InputStream inputStream) {
        this(aSN1ObjectIdentifier, inputStream, 32768);
    }

    public CMSTypedStream(ASN1ObjectIdentifier aSN1ObjectIdentifier, InputStream inputStream, int n) {
        this._oid = aSN1ObjectIdentifier;
        this._in = new FullReaderStream(new BufferedInputStream(inputStream, n));
    }

    public ASN1ObjectIdentifier getContentType() {
        return this._oid;
    }

    public InputStream getContentStream() {
        return this._in;
    }

    public void drain() throws IOException {
        Streams.drain(this._in);
        this._in.close();
    }

    private static class FullReaderStream
    extends FilterInputStream {
        FullReaderStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = Streams.readFully(this.in, byArray, n, n2);
            return n3 > 0 ? n3 : -1;
        }
    }
}

