/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.x509.Target;
import org.jruby.org.bouncycastle.asn1.x509.Targets;

public class TargetInformation
extends ASN1Encodable {
    private ASN1Sequence targets;

    public static TargetInformation getInstance(Object object) {
        if (object instanceof TargetInformation) {
            return (TargetInformation)object;
        }
        if (object instanceof ASN1Sequence) {
            return new TargetInformation((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass());
    }

    private TargetInformation(ASN1Sequence aSN1Sequence) {
        this.targets = aSN1Sequence;
    }

    public Targets[] getTargetsObjects() {
        Targets[] targetsArray = new Targets[this.targets.size()];
        int n = 0;
        Enumeration enumeration = this.targets.getObjects();
        while (enumeration.hasMoreElements()) {
            targetsArray[n++] = Targets.getInstance(enumeration.nextElement());
        }
        return targetsArray;
    }

    public TargetInformation(Targets targets) {
        this.targets = new DERSequence(targets);
    }

    public TargetInformation(Target[] targetArray) {
        this(new Targets(targetArray));
    }

    public DERObject toASN1Object() {
        return this.targets;
    }
}

