/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.ASN1TaggedObject;
import org.jruby.org.bouncycastle.asn1.DERGeneralizedTime;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.DERTaggedObject;
import org.jruby.org.bouncycastle.asn1.x509.X509Extension;

public class PrivateKeyUsagePeriod
extends ASN1Encodable {
    private DERGeneralizedTime _notBefore;
    private DERGeneralizedTime _notAfter;

    public static PrivateKeyUsagePeriod getInstance(Object object) {
        if (object instanceof PrivateKeyUsagePeriod) {
            return (PrivateKeyUsagePeriod)object;
        }
        if (object instanceof ASN1Sequence) {
            return new PrivateKeyUsagePeriod((ASN1Sequence)object);
        }
        if (object instanceof X509Extension) {
            return PrivateKeyUsagePeriod.getInstance(X509Extension.convertValueToObject((X509Extension)object));
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    private PrivateKeyUsagePeriod(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            if (aSN1TaggedObject.getTagNo() == 0) {
                this._notBefore = DERGeneralizedTime.getInstance(aSN1TaggedObject, false);
                continue;
            }
            if (aSN1TaggedObject.getTagNo() != 1) continue;
            this._notAfter = DERGeneralizedTime.getInstance(aSN1TaggedObject, false);
        }
    }

    public DERGeneralizedTime getNotBefore() {
        return this._notBefore;
    }

    public DERGeneralizedTime getNotAfter() {
        return this._notAfter;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this._notBefore != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this._notBefore));
        }
        if (this._notAfter != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this._notAfter));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

