/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.x509;

import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.ASN1TaggedObject;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.x509.GeneralName;

public class GeneralNames
extends ASN1Encodable {
    private final GeneralName[] names;

    public static GeneralNames getInstance(Object object) {
        if (object == null || object instanceof GeneralNames) {
            return (GeneralNames)object;
        }
        if (object instanceof ASN1Sequence) {
            return new GeneralNames((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static GeneralNames getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return GeneralNames.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public GeneralNames(GeneralName generalName) {
        this.names = new GeneralName[]{generalName};
    }

    public GeneralNames(ASN1Sequence aSN1Sequence) {
        this.names = new GeneralName[aSN1Sequence.size()];
        for (int j = 0; j != aSN1Sequence.size(); ++j) {
            this.names[j] = GeneralName.getInstance(aSN1Sequence.getObjectAt(j));
        }
    }

    public GeneralName[] getNames() {
        GeneralName[] generalNameArray = new GeneralName[this.names.length];
        System.arraycopy(this.names, 0, generalNameArray, 0, this.names.length);
        return generalNameArray;
    }

    public DERObject toASN1Object() {
        return new DERSequence(this.names);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        stringBuffer.append("GeneralNames:");
        stringBuffer.append(string2);
        for (int j = 0; j != this.names.length; ++j) {
            stringBuffer.append("    ");
            stringBuffer.append(this.names[j]);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

