/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.crmf;

import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.crmf.CertReqMsg;

public class CertReqMessages
extends ASN1Encodable {
    private ASN1Sequence content;

    private CertReqMessages(ASN1Sequence aSN1Sequence) {
        this.content = aSN1Sequence;
    }

    public static CertReqMessages getInstance(Object object) {
        if (object instanceof CertReqMessages) {
            return (CertReqMessages)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CertReqMessages((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public CertReqMessages(CertReqMsg certReqMsg) {
        this.content = new DERSequence(certReqMsg);
    }

    public CertReqMessages(CertReqMsg[] certReqMsgArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int j = 0; j < certReqMsgArray.length; ++j) {
            aSN1EncodableVector.add(certReqMsgArray[j]);
        }
        this.content = new DERSequence(aSN1EncodableVector);
    }

    public CertReqMsg[] toCertReqMsgArray() {
        CertReqMsg[] certReqMsgArray = new CertReqMsg[this.content.size()];
        for (int j = 0; j != certReqMsgArray.length; ++j) {
            certReqMsgArray[j] = CertReqMsg.getInstance(this.content.getObjectAt(j));
        }
        return certReqMsgArray;
    }

    public DERObject toASN1Object() {
        return this.content;
    }
}

