/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.cms;

import org.jruby.org.bouncycastle.asn1.ASN1Choice;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.ASN1TaggedObject;
import org.jruby.org.bouncycastle.asn1.DEREncodable;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERTaggedObject;
import org.jruby.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.jruby.org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.jruby.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.jruby.org.bouncycastle.asn1.cms.OtherRecipientInfo;
import org.jruby.org.bouncycastle.asn1.cms.PasswordRecipientInfo;

public class RecipientInfo
extends ASN1Encodable
implements ASN1Choice {
    DEREncodable info;

    public RecipientInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        this.info = keyTransRecipientInfo;
    }

    public RecipientInfo(KeyAgreeRecipientInfo keyAgreeRecipientInfo) {
        this.info = new DERTaggedObject(false, 1, keyAgreeRecipientInfo);
    }

    public RecipientInfo(KEKRecipientInfo kEKRecipientInfo) {
        this.info = new DERTaggedObject(false, 2, kEKRecipientInfo);
    }

    public RecipientInfo(PasswordRecipientInfo passwordRecipientInfo) {
        this.info = new DERTaggedObject(false, 3, passwordRecipientInfo);
    }

    public RecipientInfo(OtherRecipientInfo otherRecipientInfo) {
        this.info = new DERTaggedObject(false, 4, otherRecipientInfo);
    }

    public RecipientInfo(DERObject dERObject) {
        this.info = dERObject;
    }

    public static RecipientInfo getInstance(Object object) {
        if (object == null || object instanceof RecipientInfo) {
            return (RecipientInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RecipientInfo((ASN1Sequence)object);
        }
        if (object instanceof ASN1TaggedObject) {
            return new RecipientInfo((ASN1TaggedObject)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public DERInteger getVersion() {
        if (this.info instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)this.info;
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(aSN1TaggedObject, false).getVersion();
                }
                case 2: {
                    return this.getKEKInfo(aSN1TaggedObject).getVersion();
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(aSN1TaggedObject, false).getVersion();
                }
                case 4: {
                    return new DERInteger(0);
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.info).getVersion();
    }

    public boolean isTagged() {
        return this.info instanceof ASN1TaggedObject;
    }

    public DEREncodable getInfo() {
        if (this.info instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)this.info;
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(aSN1TaggedObject, false);
                }
                case 2: {
                    return this.getKEKInfo(aSN1TaggedObject);
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(aSN1TaggedObject, false);
                }
                case 4: {
                    return OtherRecipientInfo.getInstance(aSN1TaggedObject, false);
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.info);
    }

    private KEKRecipientInfo getKEKInfo(ASN1TaggedObject aSN1TaggedObject) {
        if (aSN1TaggedObject.isExplicit()) {
            return KEKRecipientInfo.getInstance(aSN1TaggedObject, true);
        }
        return KEKRecipientInfo.getInstance(aSN1TaggedObject, false);
    }

    public DERObject toASN1Object() {
        return this.info.getDERObject();
    }
}

