/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.ext.openssl.impl.BIO;
import org.jruby.ext.openssl.impl.MimeHeader;
import org.jruby.ext.openssl.impl.MimeParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Mime {
    public static final Mime DEFAULT = new Mime(){
        private static final int MIME_START = 1;
        private static final int MIME_TYPE = 2;
        private static final int MIME_NAME = 3;
        private static final int MIME_VALUE = 4;
        private static final int MIME_QUOTE = 5;
        private static final int MIME_COMMENT = 6;
        private static final int MAX_SMLEN = 1024;

        private int stripStart(byte[] buffer, int start2, int end2) {
            for (int p2 = start2; p2 < end2; ++p2) {
                byte c = buffer[p2];
                if (c == 34) {
                    if (p2 + 1 < end2) {
                        return p2 + 1;
                    }
                    return -1;
                }
                if (Character.isWhitespace((char)c)) continue;
                return p2;
            }
            return -1;
        }

        private int stripEnd(byte[] buffer, int start2, int end2) {
            this.mimeDebug("stripEnd(" + start2 + "," + end2 + ")");
            if (start2 == -1) {
                return -1;
            }
            for (int p2 = end2 - 1; p2 >= start2; --p2) {
                this.mimeDebug("  p = " + p2 + ", c = " + (char)buffer[p2] + "(" + buffer[p2] + ")");
                byte c = buffer[p2];
                if (c == 34) {
                    if (p2 - 1 == start2) {
                        return -1;
                    }
                    return p2;
                }
                if (Character.isWhitespace((char)c)) continue;
                return p2 + 1;
            }
            return -1;
        }

        private String stripEnds(byte[] buffer, int start2, int end2) {
            start2 = this.stripStart(buffer, start2, end2);
            end2 = this.stripEnd(buffer, start2, end2);
            try {
                return new String(buffer, start2, end2 - start2, "ISO8859-1");
            }
            catch (Exception e) {
                return null;
            }
        }

        public void mimeDebug(String str) {
        }

        @Override
        public List<MimeHeader> parseHeaders(BIO bio) throws IOException {
            this.mimeDebug("\n!!!!!!!!!!!!!!!!!\n" + bio + "\n^^^^^^^^^^^^^^^^^^^^^^^^\n");
            int state2 = 0;
            byte[] linebuf = new byte[1024];
            int len = 0;
            String ntmp = null;
            MimeHeader mhdr = null;
            int saveState = -1;
            ArrayList<MimeHeader> headers = new ArrayList<MimeHeader>();
            while ((len = bio.gets(linebuf, 1024)) > 0) {
                int p2;
                state2 = mhdr != null && Character.isWhitespace((char)linebuf[0]) ? 3 : 1;
                int q = 0;
                block9: for (p2 = 0; p2 < len && linebuf[p2] != 13 && linebuf[p2] != 10; ++p2) {
                    byte c = linebuf[p2];
                    switch (state2) {
                        case 1: {
                            if (c != 58) continue block9;
                            state2 = 2;
                            this.mimeDebug("creating new: " + q + ":" + p2);
                            ntmp = this.stripEnds(linebuf, q, p2);
                            q = p2 + 1;
                            continue block9;
                        }
                        case 2: {
                            if (c == 59) {
                                this.mimeDebug("Found End Value");
                                this.mimeDebug("creating new: " + q + ":" + p2);
                                mhdr = new MimeHeader(ntmp, this.stripEnds(linebuf, q, p2));
                                headers.add(mhdr);
                                ntmp = null;
                                q = p2 + 1;
                                state2 = 3;
                                continue block9;
                            }
                            if (c != 40) continue block9;
                            saveState = state2;
                            state2 = 6;
                            continue block9;
                        }
                        case 6: {
                            if (c != 41) continue block9;
                            state2 = saveState;
                            continue block9;
                        }
                        case 3: {
                            if (c != 61) continue block9;
                            state2 = 4;
                            this.mimeDebug("creating new: " + q + ":" + p2);
                            ntmp = this.stripEnds(linebuf, q, p2);
                            q = p2 + 1;
                            continue block9;
                        }
                        case 4: {
                            if (c == 59) {
                                state2 = 3;
                                mhdr.getParams().add(new MimeParam(ntmp, this.stripEnds(linebuf, q, p2)));
                                ntmp = null;
                                q = p2 + 1;
                                continue block9;
                            }
                            if (c == 34) {
                                this.mimeDebug("Found Quote");
                                state2 = 5;
                                continue block9;
                            }
                            if (c != 40) continue block9;
                            saveState = state2;
                            state2 = 6;
                            continue block9;
                        }
                        case 5: {
                            if (c != 34) continue block9;
                            this.mimeDebug("Found Match Quote");
                            state2 = 4;
                        }
                    }
                }
                if (state2 == 2) {
                    this.mimeDebug("creating new: " + q + ":" + p2);
                    mhdr = new MimeHeader(ntmp, this.stripEnds(linebuf, q, p2));
                    headers.add(mhdr);
                } else if (state2 == 4) {
                    this.mimeDebug("creating new: " + q + ":" + p2);
                    mhdr.getParams().add(new MimeParam(ntmp, this.stripEnds(linebuf, q, p2)));
                }
                if (p2 != 0) continue;
                break;
            }
            return headers;
        }

        @Override
        public MimeHeader findHeader(List<MimeHeader> headers, String key2) {
            for (MimeHeader hdr : headers) {
                if (!hdr.getName().equals(key2)) continue;
                return hdr;
            }
            return null;
        }

        @Override
        public MimeParam findParam(MimeHeader header, String key2) {
            for (MimeParam par : header.getParams()) {
                if (!par.getParamName().equals(key2)) continue;
                return par;
            }
            return null;
        }
    };

    public List<MimeHeader> parseHeaders(BIO var1) throws IOException;

    public MimeHeader findHeader(List<MimeHeader> var1, String var2);

    public MimeParam findParam(MimeHeader var1, String var2);
}

