/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.BlockArg18Node;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Interpreted19Block;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterNode
extends Node {
    private final Node varNode;
    private final Node bodyNode;
    private final Node blockVarNode;
    private StaticScope scope;
    private BlockBody blockBody;

    public IterNode(ISourcePosition position, Node args2, StaticScope scope, Node body) {
        super(position);
        if (args2 instanceof BlockArg18Node) {
            this.varNode = ((BlockArg18Node)args2).getArgs();
            this.blockVarNode = ((BlockArg18Node)args2).getBlockArg();
        } else {
            this.varNode = args2;
            this.blockVarNode = null;
        }
        this.scope = scope;
        this.bodyNode = body;
        this.blockBody = InterpretedBlock.newBlockBody(this, Arity.procArityOf(this.varNode), this.getArgumentType());
    }

    public IterNode(ISourcePosition position, ArgsNode args2, Node body, StaticScope scope) {
        super(position);
        this.varNode = args2;
        this.blockVarNode = null;
        this.bodyNode = body;
        this.scope = scope;
        this.blockBody = Interpreted19Block.newBlockBody(this);
    }

    public final int getArgumentType() {
        return BlockBody.asArgumentType(BlockBody.getArgumentTypeWackyHack(this));
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ITERNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    public Node getBlockVarNode() {
        return this.blockVarNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getVarNode() {
        return this.varNode;
    }

    public BlockBody getBlockBody() {
        return this.blockBody;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.varNode, this.blockVarNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        assert (false) : "Call nodes deal with these directly";
        return null;
    }
}

