/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.RecursiveComparator;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Hash"}, include={"Enumerable"})
public class RubyHash
extends RubyObject
implements Map {
    public static final int DEFAULT_INSPECT_STR_SIZE = 20;
    private static final ObjectAllocator HASH_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyHash(runtime, klass);
        }
    };
    private RubyHashEntry[] table;
    protected int size = 0;
    private int threshold;
    private static final int PROCDEFAULT_HASH_F = 1024;
    private IRubyObject ifNone;
    private static final int[] MRI_PRIMES = new int[]{11, 19, 37, 67, 131, 283, 521, 1033, 2053, 4099, 8219, 16427, 32771, 65581, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000055, 0};
    private static final int JAVASOFT_INITIAL_CAPACITY = 8;
    private static final int MRI_INITIAL_CAPACITY = MRI_PRIMES[0];
    private static final int INITIAL_THRESHOLD = 6;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final RubyHashEntry NO_ENTRY = new RubyHashEntry();
    private int generation = 0;
    private final RubyHashEntry head = new RubyHashEntry();
    private static final int HASH_SIGN_BIT_MASK = Integer.MAX_VALUE;
    private static final int MIN_CAPA = 8;
    private static final int ST_DEFAULT_MAX_DENSITY = 5;
    private static final boolean MRI_HASH = true;
    private static final boolean MRI_HASH_RESIZE = true;
    public static long collisions = 0L;
    private static final EntryMatchType MATCH_KEY = new EntryMatchType(){

        public boolean matches(RubyHashEntry entry, Object obj) {
            IRubyObject key2 = entry.key;
            return obj == key2 || ((IRubyObject)obj).eql(key2);
        }
    };
    private static final EntryMatchType MATCH_ENTRY = new EntryMatchType(){

        public boolean matches(RubyHashEntry entry, Object obj) {
            return entry.equals(obj);
        }
    };
    private static final Found FOUND = new Found();
    private AtomicInteger iteratorCount;
    private static final Mismatch MISMATCH = new Mismatch();
    private static final EntryView DIRECT_KEY_VIEW = new EntryView(){

        public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
            return entry.key;
        }

        public boolean contains(RubyHash hash2, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            return hash2.internalGet((IRubyObject)o) != null;
        }

        public boolean remove(RubyHash hash2, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            return hash2.internalDelete((IRubyObject)o) != NO_ENTRY;
        }
    };
    private static final EntryView KEY_VIEW = new EntryView(){

        public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
            return entry.key.toJava(Object.class);
        }

        public boolean contains(RubyHash hash2, Object o) {
            return hash2.containsKey(o);
        }

        public boolean remove(RubyHash hash2, Object o) {
            return hash2.remove(o) != null;
        }
    };
    private static final EntryView DIRECT_VALUE_VIEW = new EntryView(){

        public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
            return entry.value;
        }

        public boolean contains(RubyHash hash2, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            IRubyObject obj = (IRubyObject)o;
            return hash2.hasValue(obj.getRuntime().getCurrentContext(), obj);
        }

        public boolean remove(RubyHash hash2, Object o) {
            if (!(o instanceof IRubyObject)) {
                return false;
            }
            IRubyObject obj = (IRubyObject)o;
            IRubyObject key2 = hash2.internalIndex(obj.getRuntime().getCurrentContext(), obj);
            if (key2 == null) {
                return false;
            }
            return hash2.internalDelete(key2) != NO_ENTRY;
        }
    };
    private static final EntryView VALUE_VIEW = new EntryView(){

        public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
            return entry.value.toJava(Object.class);
        }

        public boolean contains(RubyHash hash2, Object o) {
            return hash2.containsValue(o);
        }

        public boolean remove(RubyHash hash2, Object o) {
            IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(hash2.getRuntime(), o);
            IRubyObject key2 = hash2.internalIndex(hash2.getRuntime().getCurrentContext(), value2);
            if (key2 == null) {
                return false;
            }
            return hash2.internalDelete(key2) != NO_ENTRY;
        }
    };
    private static final EntryView DIRECT_ENTRY_VIEW = new EntryView(){

        public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
            return entry;
        }

        public boolean contains(RubyHash hash2, Object o) {
            if (!(o instanceof RubyHashEntry)) {
                return false;
            }
            RubyHashEntry entry = (RubyHashEntry)o;
            RubyHashEntry candidate = hash2.internalGetEntry(entry.key);
            return candidate != NO_ENTRY && entry.equals(candidate);
        }

        public boolean remove(RubyHash hash2, Object o) {
            if (!(o instanceof RubyHashEntry)) {
                return false;
            }
            return hash2.internalDeleteEntry((RubyHashEntry)o) != NO_ENTRY;
        }
    };
    private static final EntryView ENTRY_VIEW = new EntryView(){

        public Object convertEntry(Ruby runtime, RubyHashEntry entry) {
            return new ConvertingEntry(runtime, entry);
        }

        public boolean contains(RubyHash hash2, Object o) {
            if (!(o instanceof ConvertingEntry)) {
                return false;
            }
            ConvertingEntry entry = (ConvertingEntry)o;
            RubyHashEntry candidate = hash2.internalGetEntry(entry.entry.key);
            return candidate != NO_ENTRY && entry.entry.equals(candidate);
        }

        public boolean remove(RubyHash hash2, Object o) {
            if (!(o instanceof ConvertingEntry)) {
                return false;
            }
            ConvertingEntry entry = (ConvertingEntry)o;
            return hash2.internalDeleteEntry(entry.entry) != NO_ENTRY;
        }
    };

    public static RubyClass createHashClass(Ruby runtime) {
        RubyClass hashc = runtime.defineClass("Hash", runtime.getObject(), HASH_ALLOCATOR);
        runtime.setHash(hashc);
        hashc.index = 10;
        hashc.setReifiedClass(RubyHash.class);
        hashc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyHash;
            }
        };
        hashc.includeModule(runtime.getEnumerable());
        hashc.defineAnnotatedMethods(RubyHash.class);
        return hashc;
    }

    public int getNativeTypeIndex() {
        return 10;
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true)
    public static IRubyObject create(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        Ruby runtime = context.runtime;
        if (args2.length == 1) {
            IRubyObject tmp = TypeConverter.convertToTypeWithCheck(args2[0], runtime.getHash(), "to_hash");
            if (!tmp.isNil()) {
                RubyHash otherHash = (RubyHash)tmp;
                return new RubyHash(runtime, klass, otherHash);
            }
            tmp = TypeConverter.convertToTypeWithCheck(args2[0], runtime.getArray(), "to_ary");
            if (!tmp.isNil()) {
                RubyHash hash2 = (RubyHash)klass.allocate();
                RubyArray arr = (RubyArray)tmp;
                int j = arr.getLength();
                for (int i2 = 0; i2 < j; ++i2) {
                    IRubyObject v = TypeConverter.convertToTypeWithCheck(arr.entry(i2), runtime.getArray(), "to_ary");
                    IRubyObject key2 = runtime.getNil();
                    IRubyObject val = runtime.getNil();
                    if (v.isNil()) continue;
                    switch (((RubyArray)v).getLength()) {
                        case 2: {
                            val = ((RubyArray)v).entry(1);
                        }
                        case 1: {
                            key2 = ((RubyArray)v).entry(0);
                            hash2.fastASet(key2, val);
                        }
                    }
                }
                return hash2;
            }
        }
        if ((args2.length & 1) != 0) {
            throw runtime.newArgumentError("odd number of arguments for Hash");
        }
        RubyHash hash3 = (RubyHash)klass.allocate();
        for (int i3 = 0; i3 < args2.length; i3 += 2) {
            hash3.op_aset(context, args2[i3], args2[i3 + 1]);
        }
        return hash3;
    }

    @JRubyMethod(name={"try_convert"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject recv2, IRubyObject args2) {
        return TypeConverter.convertToTypeWithCheck(args2, context.runtime.getHash(), "to_hash");
    }

    public static final RubyHash newHash(Ruby runtime) {
        return new RubyHash(runtime);
    }

    public static final RubyHash newSmallHash(Ruby runtime) {
        return new RubyHash(runtime, 1);
    }

    public static final RubyHash newHash(Ruby runtime, Map valueMap, IRubyObject defaultValue) {
        assert (defaultValue != null);
        return new RubyHash(runtime, valueMap, defaultValue);
    }

    private RubyHash(Ruby runtime, RubyClass klass, RubyHash other) {
        super(runtime, klass);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.iteratorCount = new AtomicInteger(0);
        this.ifNone = runtime.getNil();
        this.threshold = 6;
        this.table = other.internalCopyTable(this.head);
        this.size = other.size;
    }

    public RubyHash(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.iteratorCount = new AtomicInteger(0);
        this.ifNone = runtime.getNil();
        this.alloc();
    }

    public RubyHash(Ruby runtime, int buckets) {
        this(runtime, runtime.getNil(), buckets);
    }

    public RubyHash(Ruby runtime) {
        this(runtime, runtime.getNil());
    }

    public RubyHash(Ruby runtime, IRubyObject defaultValue) {
        super(runtime, runtime.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.iteratorCount = new AtomicInteger(0);
        this.ifNone = defaultValue;
        this.alloc();
    }

    public RubyHash(Ruby runtime, IRubyObject defaultValue, int buckets) {
        super(runtime, runtime.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.iteratorCount = new AtomicInteger(0);
        this.ifNone = defaultValue;
        this.alloc(buckets);
    }

    RubyHash(Ruby runtime, boolean objectSpace) {
        super(runtime, runtime.getHash(), objectSpace);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.iteratorCount = new AtomicInteger(0);
        this.alloc();
    }

    public RubyHash(Ruby runtime, Map valueMap, IRubyObject defaultValue) {
        super(runtime, runtime.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.iteratorCount = new AtomicInteger(0);
        this.ifNone = defaultValue;
        this.alloc();
        for (Map.Entry e : valueMap.entrySet()) {
            this.internalPut((IRubyObject)e.getKey(), (IRubyObject)e.getValue());
        }
    }

    private final void alloc() {
        this.threshold = 6;
        ++this.generation;
        this.head.nextAdded = (this.head.prevAdded = this.head);
        this.table = new RubyHashEntry[MRI_INITIAL_CAPACITY];
    }

    private final void alloc(int buckets) {
        this.threshold = 6;
        ++this.generation;
        this.head.nextAdded = (this.head.prevAdded = this.head);
        this.table = new RubyHashEntry[buckets];
    }

    private static int JavaSoftHashValue(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int JavaSoftBucketIndex(int h, int length2) {
        return h & length2 - 1;
    }

    private static int MRIHashValue(int h) {
        return h & Integer.MAX_VALUE;
    }

    private static int MRIBucketIndex(int h, int length2) {
        return (h & Integer.MAX_VALUE) % length2;
    }

    private final void resize(int newCapacity) {
        RubyHashEntry[] oldTable = this.table;
        RubyHashEntry[] newTable = new RubyHashEntry[newCapacity];
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHashEntry next = entry.next;
                int i2 = RubyHash.bucketIndex(entry.hash, newCapacity);
                entry.next = newTable[i2];
                newTable[i2] = entry;
                entry = next;
            }
        }
        this.table = newTable;
    }

    private final void JavaSoftCheckResize() {
        if (this.overThreshold()) {
            RubyHashEntry[] tbl = this.table;
            if (tbl.length == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            this.resizeAndAdjustThreshold(this.table);
        }
    }

    private boolean overThreshold() {
        return this.size > this.threshold;
    }

    private void resizeAndAdjustThreshold(RubyHashEntry[] oldTable) {
        int newCapacity = oldTable.length << 1;
        this.resize(newCapacity);
        this.threshold = newCapacity - (newCapacity >> 2);
    }

    private final void MRICheckResize() {
        if (this.size / this.table.length > 5) {
            int forSize = this.table.length + 1;
            int i2 = 0;
            int newCapacity = 8;
            while (i2 < MRI_PRIMES.length) {
                if (newCapacity > forSize) {
                    this.resize(MRI_PRIMES[i2]);
                    return;
                }
                ++i2;
                newCapacity <<= 1;
            }
            return;
        }
    }

    protected static int hashValue(int h) {
        return RubyHash.MRIHashValue(h);
    }

    private static int bucketIndex(int h, int length2) {
        return RubyHash.MRIBucketIndex(h, length2);
    }

    private void checkResize() {
        this.MRICheckResize();
    }

    private void checkIterating() {
        if (this.iteratorCount.get() > 0) {
            throw this.getRuntime().newRuntimeError("can't add a new key into hash during iteration");
        }
    }

    private final void internalPut(IRubyObject key2, IRubyObject value2) {
        this.internalPut(key2, value2, true);
    }

    private final void internalPutSmall(IRubyObject key2, IRubyObject value2) {
        this.internalPutSmall(key2, value2, true);
    }

    protected void internalPut(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
        this.checkResize();
        this.internalPutSmall(key2, value2, checkForExisting);
    }

    protected void internalPutSmall(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
        int hash2 = RubyHash.hashValue(key2.hashCode());
        int i2 = RubyHash.bucketIndex(hash2, this.table.length);
        if (checkForExisting) {
            RubyHashEntry entry = this.table[i2];
            while (entry != null) {
                if (this.internalKeyExist(entry, hash2, key2)) {
                    entry.value = value2;
                    return;
                }
                entry = entry.next;
            }
        }
        this.checkIterating();
        this.table[i2] = new RubyHashEntry(hash2, key2, value2, this.table[i2], this.head);
        ++this.size;
    }

    protected IRubyObject internalGet(IRubyObject key2) {
        return this.internalGetEntry(key2).value;
    }

    protected RubyHashEntry internalGetEntry(IRubyObject key2) {
        int hash2 = RubyHash.hashValue(key2.hashCode());
        RubyHashEntry entry = this.table[RubyHash.bucketIndex(hash2, this.table.length)];
        while (entry != null) {
            if (this.internalKeyExist(entry, hash2, key2)) {
                return entry;
            }
            entry = entry.next;
        }
        return NO_ENTRY;
    }

    private boolean internalKeyExist(RubyHashEntry entry, int hash2, IRubyObject key2) {
        return entry.hash == hash2 && (entry.key == key2 || !this.isComparedByIdentity() && key2.eql(entry.key));
    }

    protected RubyHashEntry internalDelete(IRubyObject key2) {
        return this.internalDelete(RubyHash.hashValue(key2.hashCode()), MATCH_KEY, key2);
    }

    protected RubyHashEntry internalDeleteEntry(RubyHashEntry entry) {
        return this.internalDelete(RubyHash.hashValue(entry.key.hashCode()), MATCH_ENTRY, entry);
    }

    private final RubyHashEntry internalDelete(int hash2, EntryMatchType matchType, Object obj) {
        int i2 = RubyHash.bucketIndex(hash2, this.table.length);
        RubyHashEntry entry = this.table[i2];
        if (entry != null) {
            RubyHashEntry prior = null;
            while (entry != null) {
                if (entry.hash == hash2 && matchType.matches(entry, obj)) {
                    if (prior != null) {
                        prior.next = entry.next;
                    } else {
                        this.table[i2] = entry.next;
                    }
                    entry.detach();
                    --this.size;
                    return entry;
                }
                prior = entry;
                entry = entry.next;
            }
        }
        return NO_ENTRY;
    }

    private final RubyHashEntry[] internalCopyTable(RubyHashEntry destHead) {
        RubyHashEntry[] newTable = new RubyHashEntry[this.table.length];
        RubyHashEntry entry = this.head.nextAdded;
        while (entry != this.head) {
            int i2 = RubyHash.bucketIndex(entry.hash, this.table.length);
            newTable[i2] = new RubyHashEntry(entry.hash, entry.key, entry.value, newTable[i2], destHead);
            entry = entry.nextAdded;
        }
        return newTable;
    }

    public void visitAll(Visitor visitor) {
        int startGeneration = this.generation;
        RubyHashEntry entry = this.head.nextAdded;
        while (entry != this.head) {
            if (startGeneration != this.generation) {
                startGeneration = this.generation;
                entry = this.head.nextAdded;
                if (entry == this.head) break;
            }
            if (entry.isLive()) {
                visitor.visit(entry.key, entry.value);
            }
            entry = entry.nextAdded;
        }
    }

    @JRubyMethod(optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        this.modify();
        if (block.isGiven()) {
            if (args2.length > 0) {
                throw this.getRuntime().newArgumentError("wrong number of arguments");
            }
            this.ifNone = this.getRuntime().newProc(Block.Type.PROC, block);
            this.flags |= 0x400;
        } else {
            Arity.checkArgumentCount(this.getRuntime(), args2, 0, 1);
            if (args2.length == 1) {
                this.ifNone = args2[0];
            }
        }
        return this;
    }

    @Deprecated
    public IRubyObject default_value_get(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.default_value_get(context);
            }
            case 1: {
                return this.default_value_get(context, args2[0]);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 1);
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context) {
        if ((this.flags & 0x400) != 0) {
            return this.getRuntime().getNil();
        }
        return this.ifNone;
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context, IRubyObject arg2) {
        if ((this.flags & 0x400) != 0) {
            return RuntimeHelpers.invoke(context, this.ifNone, "call", (IRubyObject)this, arg2);
        }
        return this.ifNone;
    }

    @JRubyMethod(name={"default="}, required=1)
    public IRubyObject default_value_set(IRubyObject defaultValue) {
        this.modify();
        this.ifNone = defaultValue;
        this.flags &= 0xFFFFFBFF;
        return this.ifNone;
    }

    @JRubyMethod
    public IRubyObject default_proc() {
        return (this.flags & 0x400) != 0 ? this.ifNone : this.getRuntime().getNil();
    }

    private void checkDefaultProcArity(IRubyObject proc2) {
        int n = ((RubyProc)proc2).getBlock().arity().getValue();
        if (((RubyProc)proc2).getBlock().type == Block.Type.LAMBDA && n != 2 && (n >= 0 || n < -3)) {
            if (n < 0) {
                n = -n - 1;
            }
            throw this.getRuntime().newTypeError("default_proc takes two arguments (2 for " + n + ")");
        }
    }

    @JRubyMethod(name={"default_proc="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject set_default_proc(IRubyObject proc2) {
        this.modify();
        IRubyObject b = TypeConverter.convertToType(proc2, this.getRuntime().getProc(), "to_proc");
        if (b.isNil() || !(b instanceof RubyProc)) {
            throw this.getRuntime().newTypeError("wrong default_proc type " + proc2.getMetaClass() + " (expected Proc)");
        }
        proc2 = b;
        this.checkDefaultProcArity(proc2);
        this.ifNone = proc2;
        this.flags |= 0x400;
        return proc2;
    }

    public void modify() {
        this.testFrozen("Hash");
    }

    private IRubyObject inspectHash(final ThreadContext context) {
        final RubyString str = RubyString.newStringLight(context.runtime, 20);
        str.cat((byte)123);
        final boolean[] firstEntry = new boolean[]{true};
        final boolean is19 = context.runtime.is1_9();
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                if (!firstEntry[0]) {
                    str.cat((byte)44).cat((byte)32);
                }
                RubyString inspectedKey = RubyObject.inspect(context, key2);
                RubyString inspectedValue = RubyObject.inspect(context, value2);
                if (is19) {
                    str.cat19(inspectedKey);
                    str.cat((byte)61).cat((byte)62);
                    str.cat19(inspectedValue);
                } else {
                    str.cat(inspectedKey);
                    str.cat((byte)61).cat((byte)62);
                    str.cat(inspectedValue);
                }
                firstEntry[0] = false;
            }
        });
        str.cat((byte)125);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        if (this.size == 0) {
            return this.getRuntime().newString("{}");
        }
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("{...}");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.inspectHash(context);
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum rb_size() {
        return this.getRuntime().newFixnum(this.size);
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.size == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        final Ruby runtime = this.getRuntime();
        try {
            final RubyArray result2 = RubyArray.newArray(runtime, this.size);
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    result2.append(RubyArray.newArray(runtime, key2, value2));
                }
            });
            result2.setTaint(this.isTaint());
            return result2;
        }
        catch (NegativeArraySizeException nase) {
            throw this.concurrentModification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (runtime.isInspecting(this)) {
            return runtime.newString("{...}");
        }
        try {
            runtime.registerInspecting(this);
            IRubyObject iRubyObject = this.to_a().to_s();
            return iRubyObject;
        }
        finally {
            runtime.unregisterInspecting(this);
        }
    }

    @JRubyMethod(name={"to_s"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_s19(ThreadContext context) {
        return this.inspect(context);
    }

    @JRubyMethod(name={"rehash"})
    public RubyHash rehash() {
        if (this.iteratorCount.get() > 0) {
            throw this.getRuntime().newRuntimeError("rehash during iteration");
        }
        this.modify();
        RubyHashEntry[] oldTable = this.table;
        RubyHashEntry[] newTable = new RubyHashEntry[oldTable.length];
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHashEntry next = entry.next;
                entry.hash = RubyHash.hashValue(entry.key.hashCode());
                int i2 = RubyHash.bucketIndex(entry.hash, newTable.length);
                entry.next = newTable[i2];
                newTable[i2] = entry;
                entry = next;
            }
        }
        this.table = newTable;
        return this;
    }

    @JRubyMethod(name={"to_hash"})
    public RubyHash to_hash() {
        return this;
    }

    public RubyHash convertToHash() {
        return this;
    }

    public final void fastASet(IRubyObject key2, IRubyObject value2) {
        this.internalPut(key2, value2);
    }

    public final RubyHash fastASetChained(IRubyObject key2, IRubyObject value2) {
        this.internalPut(key2, value2);
        return this;
    }

    public final void fastASetCheckString(Ruby runtime, IRubyObject key2, IRubyObject value2) {
        if (key2 instanceof RubyString) {
            this.op_asetForString(runtime, (RubyString)key2, value2);
        } else {
            this.internalPut(key2, value2);
        }
    }

    public final void fastASetSmallCheckString(Ruby runtime, IRubyObject key2, IRubyObject value2) {
        if (key2 instanceof RubyString) {
            this.op_asetSmallForString(runtime, (RubyString)key2, value2);
        } else {
            this.internalPutSmall(key2, value2);
        }
    }

    public final void fastASetCheckString19(Ruby runtime, IRubyObject key2, IRubyObject value2) {
        if (key2.getMetaClass().getRealClass() == runtime.getString()) {
            this.op_asetForString(runtime, (RubyString)key2, value2);
        } else {
            this.internalPut(key2, value2);
        }
    }

    public final void fastASetSmallCheckString19(Ruby runtime, IRubyObject key2, IRubyObject value2) {
        if (key2.getMetaClass().getRealClass() == runtime.getString()) {
            this.op_asetSmallForString(runtime, (RubyString)key2, value2);
        } else {
            this.internalPutSmall(key2, value2);
        }
    }

    @Deprecated
    public IRubyObject op_aset(IRubyObject key2, IRubyObject value2) {
        return this.op_aset(this.getRuntime().getCurrentContext(), key2, value2);
    }

    @JRubyMethod(name={"[]=", "store"}, required=2, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        this.modify();
        this.fastASetCheckString(context.runtime, key2, value2);
        return value2;
    }

    @JRubyMethod(name={"[]=", "store"}, required=2, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aset19(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        this.modify();
        this.fastASetCheckString19(context.runtime, key2, value2);
        return value2;
    }

    protected void op_asetForString(Ruby runtime, RubyString key2, IRubyObject value2) {
        RubyHashEntry entry = this.internalGetEntry(key2);
        if (entry != NO_ENTRY) {
            entry.value = value2;
        } else {
            this.checkIterating();
            if (!key2.isFrozen()) {
                key2 = key2.strDup(runtime, key2.getMetaClass().getRealClass());
                key2.setFrozen(true);
            }
            this.internalPut(key2, value2, false);
        }
    }

    protected void op_asetSmallForString(Ruby runtime, RubyString key2, IRubyObject value2) {
        RubyHashEntry entry = this.internalGetEntry(key2);
        if (entry != NO_ENTRY) {
            entry.value = value2;
        } else {
            this.checkIterating();
            if (!key2.isFrozen()) {
                key2 = key2.strDup(runtime, key2.getMetaClass().getRealClass());
                key2.setFrozen(true);
            }
            this.internalPutSmall(key2, value2, false);
        }
    }

    public IRubyObject aset(IRubyObject key2, IRubyObject value2) {
        return this.op_aset(this.getRuntime().getCurrentContext(), key2, value2);
    }

    public IRubyObject aref(IRubyObject key2) {
        return this.op_aref(this.getRuntime().getCurrentContext(), key2);
    }

    public final IRubyObject fastARef(IRubyObject key2) {
        return this.internalGet(key2);
    }

    public RubyBoolean compare(final ThreadContext context, final MethodNames method2, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (!(other instanceof RubyHash)) {
            if (!other.respondsTo("to_hash")) {
                return runtime.getFalse();
            }
            return RuntimeHelpers.rbEqual(context, other, this);
        }
        final RubyHash otherHash = (RubyHash)other;
        if (this.size != otherHash.size) {
            return runtime.getFalse();
        }
        try {
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    IRubyObject value22 = otherHash.fastARef(key2);
                    if (value22 == null) {
                        throw MISMATCH;
                    }
                    if (!(method2 == MethodNames.OP_EQUAL ? RuntimeHelpers.rbEqual(context, value2, value22) : RuntimeHelpers.rbEql(context, value2, value22)).isTrue()) {
                        throw MISMATCH;
                    }
                }
            });
        }
        catch (Mismatch e) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return RecursiveComparator.compare(context, MethodNames.OP_EQUAL, this, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql19(ThreadContext context, IRubyObject other) {
        return RecursiveComparator.compare(context, MethodNames.EQL, this, other);
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
        IRubyObject value2 = this.internalGet(key2);
        return value2 == null ? this.callMethod(context, "default", key2) : value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"hash"}, compat=CompatVersion.RUBY1_8)
    public RubyFixnum hash() {
        Ruby runtime = this.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        if (this.size == 0 || runtime.isInspecting(this)) {
            return RubyFixnum.zero(runtime);
        }
        final long[] hash2 = new long[]{this.size};
        try {
            runtime.registerInspecting(this);
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    hash2[0] = hash2[0] ^ RuntimeHelpers.invokedynamic(context, key2, MethodNames.HASH).convertToInteger().getLongValue();
                    hash2[0] = hash2[0] ^ RuntimeHelpers.invokedynamic(context, value2, MethodNames.HASH).convertToInteger().getLongValue();
                }
            });
        }
        finally {
            runtime.unregisterInspecting(this);
        }
        return RubyFixnum.newFixnum(runtime, hash2[0]);
    }

    @JRubyMethod(name={"hash"}, compat=CompatVersion.RUBY1_9)
    public RubyFixnum hash19() {
        final Ruby runtime = this.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        return (RubyFixnum)this.getRuntime().execRecursiveOuter(new Ruby.RecursiveFunction(){

            public IRubyObject call(IRubyObject obj, boolean recur) {
                if (RubyHash.this.size == 0) {
                    return RubyFixnum.zero(runtime);
                }
                final long[] h = new long[]{RubyHash.this.size};
                if (recur) {
                    h[0] = h[0] ^ RubyNumeric.num2long(RuntimeHelpers.invokedynamic(context, (IRubyObject)runtime.getHash(), MethodNames.HASH));
                } else {
                    RubyHash.this.visitAll(new Visitor(){

                        public void visit(IRubyObject key2, IRubyObject value2) {
                            h[0] = h[0] ^ RuntimeHelpers.invokedynamic(context, key2, MethodNames.HASH).convertToInteger().getLongValue();
                            h[0] = h[0] ^ RuntimeHelpers.invokedynamic(context, value2, MethodNames.HASH).convertToInteger().getLongValue();
                        }
                    });
                }
                return runtime.newFixnum(h[0]);
            }
        }, this);
    }

    @JRubyMethod(required=1, optional=1)
    public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject value2;
        Ruby runtime = context.runtime;
        if (args2.length == 2 && block.isGiven()) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument");
        }
        if ((value2 = this.internalGet(args2[0])) == null) {
            if (block.isGiven()) {
                return block.yield(context, args2[0]);
            }
            if (args2.length == 1) {
                if (runtime.is1_9()) {
                    throw runtime.newKeyError("key not found: " + args2[0]);
                }
                throw runtime.newIndexError("key not found");
            }
            return args2[1];
        }
        return value2;
    }

    @JRubyMethod(name={"has_key?", "key?", "include?", "member?"}, required=1)
    public RubyBoolean has_key_p(IRubyObject key2) {
        return this.internalGetEntry(key2) == NO_ENTRY ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    private boolean hasValue(final ThreadContext context, final IRubyObject expected) {
        try {
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    if (RubyObject.equalInternal(context, value2, expected)) {
                        throw FOUND;
                    }
                }
            });
            return false;
        }
        catch (Found found) {
            return true;
        }
    }

    @JRubyMethod(name={"has_value?", "value?"}, required=1)
    public RubyBoolean has_value_p(ThreadContext context, IRubyObject expected) {
        return this.getRuntime().newBoolean(this.hasValue(context, expected));
    }

    private void iteratorEntry() {
        this.iteratorCount.incrementAndGet();
    }

    private void iteratorExit() {
        this.iteratorCount.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iteratorVisitAll(Visitor visitor) {
        try {
            this.iteratorEntry();
            this.visitAll(visitor);
        }
        finally {
            this.iteratorExit();
        }
    }

    public RubyHash eachCommon(final ThreadContext context, final Block block) {
        if (block.arity() == Arity.TWO_ARGUMENTS) {
            this.iteratorVisitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    block.yieldSpecific(context, key2, value2);
                }
            });
        } else {
            final Ruby runtime = context.runtime;
            this.iteratorVisitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    block.yield(context, RubyArray.newArray(runtime, key2, value2));
                }
            });
        }
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject each(ThreadContext context, Block block) {
        return block.isGiven() ? this.eachCommon(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each");
    }

    @JRubyMethod(name={"each"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject each19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_pairCommon(context, block, true) : RubyEnumerator.enumeratorize(context.runtime, this, "each");
    }

    public RubyHash each_pairCommon(final ThreadContext context, final Block block, final boolean oneNine) {
        final Ruby runtime = this.getRuntime();
        this.iteratorVisitAll(new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                if (oneNine) {
                    block.yield(context, RubyArray.newArray(runtime, key2, value2));
                } else {
                    block.yieldArray(context, RubyArray.newArray(runtime, key2, value2), null, null);
                }
            }
        });
        return this;
    }

    @JRubyMethod
    public IRubyObject each_pair(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_pairCommon(context, block, context.runtime.is1_9()) : RubyEnumerator.enumeratorize(context.runtime, this, "each_pair");
    }

    public RubyHash each_valueCommon(final ThreadContext context, final Block block) {
        this.iteratorVisitAll(new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                block.yield(context, value2);
            }
        });
        return this;
    }

    @JRubyMethod
    public IRubyObject each_value(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_valueCommon(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_value");
    }

    public RubyHash each_keyCommon(final ThreadContext context, final Block block) {
        this.iteratorVisitAll(new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                block.yield(context, key2);
            }
        });
        return this;
    }

    @JRubyMethod
    public IRubyObject each_key(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_keyCommon(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_key");
    }

    @JRubyMethod(name={"select!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject select_bang(ThreadContext context, Block block) {
        if (block.isGiven()) {
            if (this.keep_ifCommon(context, block)) {
                return this;
            }
            return context.runtime.getNil();
        }
        return RubyEnumerator.enumeratorize(context.runtime, this, "each_key");
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject keep_if(ThreadContext context, Block block) {
        if (block.isGiven()) {
            this.keep_ifCommon(context, block);
            return this;
        }
        return RubyEnumerator.enumeratorize(context.runtime, this, "each_key");
    }

    public boolean keep_ifCommon(final ThreadContext context, final Block block) {
        this.testFrozen("hash");
        final boolean[] modified = new boolean[]{false};
        this.iteratorVisitAll(new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                if (!block.yieldSpecific(context, key2, value2).isTrue()) {
                    modified[0] = true;
                    RubyHash.this.remove(key2);
                }
            }
        });
        return modified[0];
    }

    @JRubyMethod
    public IRubyObject sort(ThreadContext context, Block block) {
        return this.to_a().sort_bang(context, block);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject index(ThreadContext context, IRubyObject expected) {
        IRubyObject key2 = this.internalIndex(context, expected);
        return key2 != null ? key2 : context.runtime.getNil();
    }

    @JRubyMethod(name={"index"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject index19(ThreadContext context, IRubyObject expected) {
        context.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Hash#index is deprecated; use Hash#key");
        return this.key(context, expected);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject key(ThreadContext context, IRubyObject expected) {
        IRubyObject key2 = this.internalIndex(context, expected);
        return key2 != null ? key2 : context.runtime.getNil();
    }

    private IRubyObject internalIndex(final ThreadContext context, final IRubyObject expected) {
        try {
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    if (RubyObject.equalInternal(context, value2, expected)) {
                        throw new FoundKey(key2);
                    }
                }
            });
            return null;
        }
        catch (FoundKey found) {
            return found.key;
        }
    }

    @JRubyMethod(name={"indexes", "indices"}, rest=true)
    public RubyArray indices(ThreadContext context, IRubyObject[] indices2) {
        return this.values_at(context, indices2);
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        Ruby runtime = this.getRuntime();
        try {
            final RubyArray keys2 = RubyArray.newArray(runtime, this.size);
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    keys2.append(key2);
                }
            });
            return keys2;
        }
        catch (NegativeArraySizeException nase) {
            throw this.concurrentModification();
        }
    }

    @JRubyMethod(name={"values"})
    public RubyArray rb_values() {
        try {
            final RubyArray values2 = RubyArray.newArray(this.getRuntime(), this.size);
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    values2.append(value2);
                }
            });
            return values2;
        }
        catch (NegativeArraySizeException nase) {
            throw this.concurrentModification();
        }
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context) {
        this.modify();
        RubyHashEntry entry = this.head.nextAdded;
        if (entry != this.head) {
            RubyArray result2 = RubyArray.newArray(this.getRuntime(), entry.key, entry.value);
            this.internalDeleteEntry(entry);
            return result2;
        }
        if ((this.flags & 0x400) != 0) {
            return RuntimeHelpers.invoke(context, this.ifNone, "call", (IRubyObject)this, this.getRuntime().getNil());
        }
        return this.ifNone;
    }

    public final boolean fastDelete(IRubyObject key2) {
        return this.internalDelete(key2) != NO_ENTRY;
    }

    @JRubyMethod
    public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
        this.modify();
        RubyHashEntry entry = this.internalDelete(key2);
        if (entry != NO_ENTRY) {
            return entry.value;
        }
        if (block.isGiven()) {
            return block.yield(context, key2);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject select(final ThreadContext context, final Block block) {
        final Ruby runtime = this.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, this, "select");
        }
        final RubyArray result2 = runtime.newArray();
        this.iteratorVisitAll(new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                if (block.yieldArray(context, runtime.newArray(key2, value2), null, null).isTrue()) {
                    result2.append(runtime.newArray(key2, value2));
                }
            }
        });
        return result2;
    }

    @JRubyMethod(name={"select"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject select19(final ThreadContext context, final Block block) {
        final Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, this, "select");
        }
        final RubyHash result2 = RubyHash.newHash(runtime);
        this.iteratorVisitAll(new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                if (block.yieldArray(context, runtime.newArray(key2, value2), null, null).isTrue()) {
                    result2.fastASet(key2, value2);
                }
            }
        });
        return result2;
    }

    public RubyHash delete_ifInternal(final ThreadContext context, final Block block) {
        this.modify();
        final Ruby runtime = this.getRuntime();
        final RubyHash self = this;
        this.iteratorVisitAll(new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                if (block.yieldArray(context, RubyArray.newArray(runtime, key2, value2), null, null).isTrue()) {
                    self.delete(context, key2, Block.NULL_BLOCK);
                }
            }
        });
        return this;
    }

    @JRubyMethod
    public IRubyObject delete_if(ThreadContext context, Block block) {
        return block.isGiven() ? this.delete_ifInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "delete_if");
    }

    public RubyHash rejectInternal(ThreadContext context, Block block) {
        return ((RubyHash)this.dup()).delete_ifInternal(context, block);
    }

    @JRubyMethod
    public IRubyObject reject(ThreadContext context, Block block) {
        return block.isGiven() ? this.rejectInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "reject");
    }

    public IRubyObject reject_bangInternal(ThreadContext context, Block block) {
        int n = this.size;
        this.delete_if(context, block);
        if (n == this.size) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.reject_bangInternal(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "reject!");
    }

    @JRubyMethod(name={"clear"})
    public RubyHash rb_clear() {
        this.modify();
        if (this.size > 0) {
            this.alloc();
            this.size = 0;
        }
        return this;
    }

    @JRubyMethod(name={"invert"})
    public RubyHash invert(final ThreadContext context) {
        final RubyHash result2 = RubyHash.newHash(this.getRuntime());
        this.visitAll(new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                result2.op_aset(context, value2, key2);
            }
        });
        return result2;
    }

    @JRubyMethod(name={"merge!", "update"}, required=1, compat=CompatVersion.RUBY1_8)
    public RubyHash merge_bang(final ThreadContext context, IRubyObject other, final Block block) {
        RubyHash otherHash = other.convertToHash();
        if (otherHash.empty_p().isTrue()) {
            return this;
        }
        this.modify();
        final Ruby runtime = this.getRuntime();
        final RubyHash self = this;
        otherHash.visitAll(new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                IRubyObject existing;
                if (block.isGiven() && (existing = self.internalGet(key2)) != null) {
                    value2 = block.yield(context, RubyArray.newArrayNoCopy(runtime, new IRubyObject[]{key2, existing, value2}));
                }
                self.op_aset(context, key2, value2);
            }
        });
        return this;
    }

    @JRubyMethod(name={"merge!", "update"}, required=1, compat=CompatVersion.RUBY1_9)
    public RubyHash merge_bang19(final ThreadContext context, IRubyObject other, final Block block) {
        this.modify();
        RubyHash otherHash = other.convertToHash();
        if (otherHash.empty_p().isTrue()) {
            return this;
        }
        final Ruby runtime = this.getRuntime();
        final RubyHash self = this;
        otherHash.visitAll(new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                IRubyObject existing;
                if (block.isGiven() && (existing = self.internalGet(key2)) != null) {
                    value2 = block.yield(context, RubyArray.newArrayNoCopy(runtime, new IRubyObject[]{key2, existing, value2}));
                }
                self.op_aset(context, key2, value2);
            }
        });
        return this;
    }

    @JRubyMethod
    public RubyHash merge(ThreadContext context, IRubyObject other, Block block) {
        return ((RubyHash)this.dup()).merge_bang(context, other, block);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public RubyHash initialize_copy(ThreadContext context, IRubyObject other) {
        return this.replace(context, other);
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public RubyHash initialize_copy19(ThreadContext context, IRubyObject other) {
        return this.replace19(context, other);
    }

    @JRubyMethod(name={"replace"}, required=1, compat=CompatVersion.RUBY1_8)
    public RubyHash replace(final ThreadContext context, IRubyObject other) {
        final RubyHash self = this;
        return this.replaceCommon(context, other, new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                self.op_aset(context, key2, value2);
            }
        });
    }

    @JRubyMethod(name={"replace"}, required=1, compat=CompatVersion.RUBY1_9)
    public RubyHash replace19(final ThreadContext context, IRubyObject other) {
        final RubyHash self = this;
        return this.replaceCommon19(context, other, new Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                self.op_aset19(context, key2, value2);
            }
        });
    }

    private RubyHash replaceCommon(ThreadContext context, IRubyObject other, Visitor visitor) {
        RubyHash otherHash = other.convertToHash();
        if (this == otherHash) {
            return this;
        }
        this.rb_clear();
        if (!this.isComparedByIdentity() && otherHash.isComparedByIdentity()) {
            this.setComparedByIdentity(true);
        }
        otherHash.visitAll(visitor);
        this.ifNone = otherHash.ifNone;
        this.flags = (otherHash.flags & 0x400) != 0 ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
        return this;
    }

    private RubyHash replaceCommon19(ThreadContext context, IRubyObject other, Visitor visitor) {
        RubyHash otherHash = other.convertToHash();
        this.rb_clear();
        if (this == otherHash) {
            return this;
        }
        if (!this.isComparedByIdentity() && otherHash.isComparedByIdentity()) {
            this.setComparedByIdentity(true);
        }
        otherHash.visitAll(visitor);
        this.ifNone = otherHash.ifNone;
        this.flags = (otherHash.flags & 0x400) != 0 ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
        return this;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public RubyArray values_at(ThreadContext context, IRubyObject[] args2) {
        RubyArray result2 = RubyArray.newArray(this.getRuntime(), args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            result2.append(this.op_aref(context, args2[i2]));
        }
        return result2;
    }

    @JRubyMethod(name={"assoc"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject assoc(final ThreadContext context, final IRubyObject obj) {
        try {
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    if (RubyObject.equalInternal(context, obj, key2)) {
                        throw new FoundPair(key2, value2);
                    }
                }
            });
            return context.runtime.getNil();
        }
        catch (FoundPair found) {
            return context.runtime.newArray(found.key, found.value);
        }
    }

    @JRubyMethod(name={"rassoc"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rassoc(final ThreadContext context, final IRubyObject obj) {
        try {
            this.visitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    if (RubyObject.equalInternal(context, obj, value2)) {
                        throw new FoundPair(key2, value2);
                    }
                }
            });
            return context.runtime.getNil();
        }
        catch (FoundPair found) {
            return context.runtime.newArray(found.key, found.value);
        }
    }

    @JRubyMethod(name={"flatten"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject flatten(ThreadContext context) {
        RubyArray ary = this.to_a();
        ary.callMethod(context, "flatten!", (IRubyObject)RubyFixnum.one(context.runtime));
        return ary;
    }

    @JRubyMethod(name={"flatten"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject flatten(ThreadContext context, IRubyObject level2) {
        RubyArray ary = this.to_a();
        ary.callMethod(context, "flatten!", level2);
        return ary;
    }

    @JRubyMethod(name={"compare_by_identity"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getCompareByIdentity(ThreadContext context) {
        this.modify();
        this.setComparedByIdentity(true);
        return this;
    }

    @JRubyMethod(name={"compare_by_identity?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getCompareByIdentity_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isComparedByIdentity());
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject dup(ThreadContext context) {
        RubyHash dup2 = (RubyHash)super.dup();
        dup2.setComparedByIdentity(this.isComparedByIdentity());
        return dup2;
    }

    @JRubyMethod(name={"clone"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rbClone(ThreadContext context) {
        RubyHash clone = (RubyHash)super.rbClone();
        clone.setComparedByIdentity(this.isComparedByIdentity());
        return clone;
    }

    public boolean hasDefaultProc() {
        return (this.flags & 0x400) != 0;
    }

    public IRubyObject getIfNone() {
        return this.ifNone;
    }

    public static void marshalTo(RubyHash hash2, final MarshalStream output) throws IOException {
        output.registerLinkTarget(hash2);
        output.writeInt(hash2.size);
        try {
            hash2.visitAll(new Visitor(){

                public void visit(IRubyObject key2, IRubyObject value2) {
                    try {
                        output.dumpObject(key2);
                        output.dumpObject(value2);
                    }
                    catch (IOException e) {
                        throw new VisitorIOException(e);
                    }
                }
            });
        }
        catch (VisitorIOException e) {
            throw (IOException)e.getCause();
        }
        if (!hash2.ifNone.isNil()) {
            output.dumpObject(hash2.ifNone);
        }
    }

    public static RubyHash unmarshalFrom(UnmarshalStream input, boolean defaultValue) throws IOException {
        RubyHash result2 = RubyHash.newHash(input.getRuntime());
        input.registerLinkTarget(result2);
        int size2 = input.unmarshalInt();
        for (int i2 = 0; i2 < size2; ++i2) {
            result2.fastASetCheckString(input.getRuntime(), input.unmarshalObject(), input.unmarshalObject());
        }
        if (defaultValue) {
            result2.default_value_set(input.unmarshalObject());
        }
        return result2;
    }

    public Class getJavaClass() {
        return Map.class;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Object key2) {
        return this.internalGet(JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), key2)) != null;
    }

    public boolean containsValue(Object value2) {
        return this.hasValue(this.getRuntime().getCurrentContext(), JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2));
    }

    public Object get(Object key2) {
        IRubyObject gotten = this.internalGet(JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), key2));
        return gotten == null ? null : gotten.toJava(Object.class);
    }

    public Object put(Object key2, Object value2) {
        this.internalPut(JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), key2), JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2));
        return value2;
    }

    public Object remove(Object key2) {
        IRubyObject rubyKey = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), key2);
        return this.internalDelete(rubyKey).value;
    }

    public void putAll(Map map) {
        Ruby runtime = this.getRuntime();
        for (Map.Entry entry : map.entrySet()) {
            this.internalPut(JavaUtil.convertJavaToUsableRubyObject(runtime, entry.getKey()), JavaUtil.convertJavaToUsableRubyObject(runtime, entry.getValue()));
        }
    }

    public void clear() {
        this.rb_clear();
    }

    public boolean equals(Object other) {
        if (!(other instanceof RubyHash)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.op_equal(this.getRuntime().getCurrentContext(), (RubyHash)other).isTrue();
    }

    public Set keySet() {
        return new BaseSet(KEY_VIEW);
    }

    public Set directKeySet() {
        return new BaseSet(DIRECT_KEY_VIEW);
    }

    public Collection values() {
        return new BaseCollection(VALUE_VIEW);
    }

    public Collection directValues() {
        return new BaseCollection(DIRECT_VALUE_VIEW);
    }

    public Set entrySet() {
        return new BaseSet(ENTRY_VIEW);
    }

    public Set directEntrySet() {
        return new BaseSet(DIRECT_ENTRY_VIEW);
    }

    private final RaiseException concurrentModification() {
        return this.getRuntime().newConcurrencyError("Detected invalid hash contents due to unsynchronized modifications with concurrent users");
    }

    protected boolean isComparedByIdentity() {
        return (this.flags & 0x2000) != 0;
    }

    public void setComparedByIdentity(boolean comparedByIdentity) {
        this.flags = comparedByIdentity ? (this.flags |= 0x2000) : (this.flags &= 0xFFFFDFFF);
    }

    private static class ConvertingEntry
    implements Map.Entry {
        private final RubyHashEntry entry;
        private final Ruby runtime;

        public ConvertingEntry(Ruby runtime, RubyHashEntry entry) {
            this.entry = entry;
            this.runtime = runtime;
        }

        public Object getKey() {
            return this.entry.key.toJava(Object.class);
        }

        public Object getValue() {
            return this.entry.value.toJava(Object.class);
        }

        public Object setValue(Object o) {
            return this.entry.setValue(JavaUtil.convertJavaToUsableRubyObject(this.runtime, o));
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConvertingEntry)) {
                return false;
            }
            ConvertingEntry other = (ConvertingEntry)o;
            return this.entry.equals(other.entry);
        }

        public int hashCode() {
            return this.entry.hashCode();
        }
    }

    private static abstract class EntryView {
        private EntryView() {
        }

        public abstract Object convertEntry(Ruby var1, RubyHashEntry var2);

        public abstract boolean contains(RubyHash var1, Object var2);

        public abstract boolean remove(RubyHash var1, Object var2);
    }

    private class BaseIterator
    implements Iterator {
        private final EntryView view;
        private RubyHashEntry entry;
        private boolean peeking;
        private int startGeneration;

        public BaseIterator(EntryView view) {
            this.view = view;
            this.entry = RubyHash.this.head;
            this.startGeneration = RubyHash.this.generation;
        }

        private void advance(boolean consume) {
            if (!this.peeking) {
                do {
                    if (this.startGeneration != RubyHash.this.generation) {
                        this.startGeneration = RubyHash.this.generation;
                        this.entry = RubyHash.this.head;
                    }
                    this.entry = this.entry.nextAdded;
                } while (this.entry != RubyHash.this.head && !this.entry.isLive());
            }
            this.peeking = !consume;
        }

        public Object next() {
            this.advance(true);
            if (this.entry == RubyHash.this.head) {
                this.peeking = true;
                throw new NoSuchElementException();
            }
            return this.view.convertEntry(RubyHash.this.getRuntime(), this.entry);
        }

        public boolean hasNext() {
            this.advance(false);
            return this.entry != RubyHash.this.head;
        }

        public void remove() {
            if (this.entry == RubyHash.this.head) {
                throw new IllegalStateException("Iterator out of range");
            }
            RubyHash.this.internalDeleteEntry(this.entry);
        }
    }

    private class BaseCollection
    extends AbstractCollection {
        final EntryView view;

        public BaseCollection(EntryView view) {
            this.view = view;
        }

        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        public boolean contains(Object o) {
            return this.view.contains(RubyHash.this, o);
        }

        public void clear() {
            RubyHash.this.clear();
        }

        public int size() {
            return RubyHash.this.size;
        }

        public boolean remove(Object o) {
            return this.view.remove(RubyHash.this, o);
        }
    }

    private class BaseSet
    extends AbstractSet {
        final EntryView view;

        public BaseSet(EntryView view) {
            this.view = view;
        }

        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        public boolean contains(Object o) {
            return this.view.contains(RubyHash.this, o);
        }

        public void clear() {
            RubyHash.this.clear();
        }

        public int size() {
            return RubyHash.this.size;
        }

        public boolean remove(Object o) {
            return this.view.remove(RubyHash.this, o);
        }
    }

    private static class VisitorIOException
    extends RuntimeException {
        VisitorIOException(Throwable cause2) {
            super(cause2);
        }
    }

    private static class Mismatch
    extends RuntimeException {
        private Mismatch() {
        }
    }

    private static class FoundPair
    extends FoundKey {
        public final IRubyObject value;

        FoundPair(IRubyObject key2, IRubyObject value2) {
            super(key2);
            this.value = value2;
        }
    }

    private static class FoundKey
    extends Found {
        public final IRubyObject key;

        FoundKey(IRubyObject key2) {
            this.key = key2;
        }
    }

    private static class Found
    extends RuntimeException {
        private Found() {
        }

        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    public static abstract class Visitor {
        public abstract void visit(IRubyObject var1, IRubyObject var2);
    }

    private static abstract class EntryMatchType {
        private EntryMatchType() {
        }

        public abstract boolean matches(RubyHashEntry var1, Object var2);
    }

    public static final class RubyHashEntry
    implements Map.Entry {
        private IRubyObject key;
        private IRubyObject value;
        private RubyHashEntry next;
        private RubyHashEntry prevAdded;
        private RubyHashEntry nextAdded;
        private int hash;

        RubyHashEntry() {
            this.key = RubyBasicObject.NEVER;
        }

        public RubyHashEntry(int h, IRubyObject k, IRubyObject v, RubyHashEntry e, RubyHashEntry head) {
            this.key = k;
            this.value = v;
            this.next = e;
            this.hash = h;
            if (head != null) {
                this.prevAdded = head.prevAdded;
                this.nextAdded = head;
                this.nextAdded.prevAdded = this;
                this.prevAdded.nextAdded = this;
            }
        }

        public void detach() {
            if (this.prevAdded != null) {
                this.prevAdded.nextAdded = this.nextAdded;
                this.nextAdded.prevAdded = this.prevAdded;
                this.prevAdded = null;
            }
        }

        public boolean isLive() {
            return this.prevAdded != null;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getJavaifiedKey() {
            return this.key.toJava(Object.class);
        }

        public Object getValue() {
            return this.value;
        }

        public Object getJavaifiedValue() {
            return this.value.toJava(Object.class);
        }

        public Object setValue(Object value2) {
            IRubyObject oldValue = this.value;
            if (!(value2 instanceof IRubyObject)) {
                throw new UnsupportedOperationException("directEntrySet() doesn't support setValue for non IRubyObject instance entries, convert them manually or use entrySet() instead");
            }
            this.value = (IRubyObject)value2;
            return oldValue;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RubyHashEntry)) {
                return false;
            }
            RubyHashEntry otherEntry = (RubyHashEntry)other;
            return !(this.key != otherEntry.key && !this.key.eql(otherEntry.key) || this.value != otherEntry.value && !this.value.equals(otherEntry.value));
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

