/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.compiler.ASTInspector;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.MethodArgs;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedMethod
extends DynamicMethod
implements MethodArgs,
PositionAware {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private ISourcePosition position;
    private String file;
    private int line;
    private boolean needsScope;

    public InterpretedMethod(RubyModule implementationClass, StaticScope staticScope, Node body, String name2, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, visibility, CallConfiguration.FrameFullScopeFull, name2);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.position = position;
        this.file = position.getFile();
        this.line = position.getLine();
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(body);
        inspector.inspect(argsNode);
        this.needsScope = true;
        assert (argsNode != null);
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime);
                this.argsNode.checkArgCount(runtime, name2, args2.length);
                this.argsNode.prepare(context, runtime, self, args2, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
                Object var12_13 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var12_14 = null;
                this.post(runtime, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime);
                Object var12_15 = null;
                this.post(runtime, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime, bj, callNumber);
                Object var12_16 = null;
                this.post(runtime, context, name2);
                return iRubyObject4;
            }
            this.post(runtime, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.post(runtime, context, name2);
            throw throwable;
        }
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.call(context, self, clazz, name2, args2, Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
                this.argsNode.checkArgCount(runtime, name2, 0);
                this.argsNode.prepare(context, runtime, self, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
                Object var10_11 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var10_12 = null;
                this.post(runtime, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime);
                Object var10_13 = null;
                this.post(runtime, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime, bj, callNumber);
                Object var10_14 = null;
                this.post(runtime, context, name2);
                return iRubyObject4;
            }
            this.post(runtime, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.post(runtime, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime);
                this.argsNode.checkArgCount(runtime, name2, 0);
                this.argsNode.prepare(context, runtime, self, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
                Object var11_12 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var11_13 = null;
                this.post(runtime, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime);
                Object var11_14 = null;
                this.post(runtime, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime, bj, callNumber);
                Object var11_15 = null;
                this.post(runtime, context, name2);
                return iRubyObject4;
            }
            this.post(runtime, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.post(runtime, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
                this.argsNode.checkArgCount(runtime, name2, 1);
                this.argsNode.prepare(context, runtime, self, arg0, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
                Object var11_12 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var11_13 = null;
                this.post(runtime, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime);
                Object var11_14 = null;
                this.post(runtime, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime, bj, callNumber);
                Object var11_15 = null;
                this.post(runtime, context, name2);
                return iRubyObject4;
            }
            this.post(runtime, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.post(runtime, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime);
                this.argsNode.checkArgCount(runtime, name2, 1);
                this.argsNode.prepare(context, runtime, self, arg0, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
                Object var12_13 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var12_14 = null;
                this.post(runtime, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime);
                Object var12_15 = null;
                this.post(runtime, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime, bj, callNumber);
                Object var12_16 = null;
                this.post(runtime, context, name2);
                return iRubyObject4;
            }
            this.post(runtime, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.post(runtime, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
                this.argsNode.checkArgCount(runtime, name2, 2);
                this.argsNode.prepare(context, runtime, self, arg0, arg1, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
                Object var12_13 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var12_14 = null;
                this.post(runtime, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime);
                Object var12_15 = null;
                this.post(runtime, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime, bj, callNumber);
                Object var12_16 = null;
                this.post(runtime, context, name2);
                return iRubyObject4;
            }
            this.post(runtime, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.post(runtime, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime);
                this.argsNode.checkArgCount(runtime, name2, 2);
                this.argsNode.prepare(context, runtime, self, arg0, arg1, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
                Object var13_14 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var13_15 = null;
                this.post(runtime, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime);
                Object var13_16 = null;
                this.post(runtime, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime, bj, callNumber);
                Object var13_17 = null;
                this.post(runtime, context, name2);
                return iRubyObject4;
            }
            this.post(runtime, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            this.post(runtime, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, Block.NULL_BLOCK, runtime);
                this.argsNode.checkArgCount(runtime, name2, 3);
                this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, Block.NULL_BLOCK);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, Block.NULL_BLOCK, this.isTraceable());
                Object var13_14 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var13_15 = null;
                this.post(runtime, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime);
                Object var13_16 = null;
                this.post(runtime, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime, bj, callNumber);
                Object var13_17 = null;
                this.post(runtime, context, name2);
                return iRubyObject4;
            }
            this.post(runtime, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            this.post(runtime, context, name2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        Ruby runtime = context.runtime;
        int callNumber = context.callNumber;
        try {
            IRubyObject iRubyObject;
            try {
                this.pre(context, name2, self, block, runtime);
                this.argsNode.checkArgCount(runtime, name2, 3);
                this.argsNode.prepare(context, runtime, self, arg0, arg1, arg2, block);
                iRubyObject = ASTInterpreter.INTERPRET_METHOD(runtime, context, this.file, this.line, this.getImplementationClass(), this.body, name2, self, block, this.isTraceable());
                Object var14_15 = null;
            }
            catch (JumpException.ReturnJump rj) {
                IRubyObject iRubyObject2 = this.handleReturn(context, rj, callNumber);
                Object var14_16 = null;
                this.post(runtime, context, name2);
                return iRubyObject2;
            }
            catch (JumpException.RedoJump rj) {
                IRubyObject iRubyObject3 = this.handleRedo(runtime);
                Object var14_17 = null;
                this.post(runtime, context, name2);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject4 = this.handleBreak(context, runtime, bj, callNumber);
                Object var14_18 = null;
                this.post(runtime, context, name2);
                return iRubyObject4;
            }
            this.post(runtime, context, name2);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.post(runtime, context, name2);
            throw throwable;
        }
    }

    protected void pre(ThreadContext context, String name2, IRubyObject self, Block block, Ruby runtime) {
        if (this.needsScope) {
            context.preMethodFrameAndScope(this.getImplementationClass(), name2, self, block, this.staticScope);
        } else {
            context.preMethodFrameAndDummyScope(this.getImplementationClass(), name2, self, block, this.staticScope);
        }
    }

    protected void post(Ruby runtime, ThreadContext context, String name2) {
        context.postMethodFrameAndScope();
    }

    protected boolean isTraceable() {
        return false;
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    public String getFile() {
        return this.position.getFile();
    }

    public int getLine() {
        return this.position.getLine();
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new InterpretedMethod(this.getImplementationClass(), this.staticScope, this.body, this.name, this.argsNode, this.getVisibility(), this.position);
    }
}

