/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTags;

public class DEROutputStream
extends FilterOutputStream
implements DERTags {
    public DEROutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void writeLength(int n) throws IOException {
        if (n > 127) {
            int n2 = 1;
            int n3 = n;
            while ((n3 >>>= 8) != 0) {
                ++n2;
            }
            this.write((byte)(n2 | 0x80));
            for (int j = (n2 - 1) * 8; j >= 0; j -= 8) {
                this.write((byte)(n >> j));
            }
        } else {
            this.write((byte)n);
        }
    }

    void writeEncoded(int n, byte[] byArray) throws IOException {
        this.write(n);
        this.writeLength(byArray.length);
        this.write(byArray);
    }

    void writeTag(int n, int n2) throws IOException {
        if (n2 < 31) {
            this.write(n | n2);
        } else {
            this.write(n | 0x1F);
            if (n2 < 128) {
                this.write(n2);
            } else {
                byte[] byArray = new byte[5];
                int n3 = byArray.length;
                byArray[--n3] = (byte)(n2 & 0x7F);
                do {
                    byArray[--n3] = (byte)((n2 >>= 7) & 0x7F | 0x80);
                } while (n2 > 127);
                this.write(byArray, n3, byArray.length - n3);
            }
        }
    }

    void writeEncoded(int n, int n2, byte[] byArray) throws IOException {
        this.writeTag(n, n2);
        this.writeLength(byArray.length);
        this.write(byArray);
    }

    protected void writeNull() throws IOException {
        this.write(5);
        this.write(0);
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof DERObject) {
            ((DERObject)object).encode(this);
        } else if (object instanceof DEREncodable) {
            ((DEREncodable)object).getDERObject().encode(this);
        } else {
            throw new IOException("object not DEREncodable");
        }
    }
}

