/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.PageManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jnr.ffi.Runtime;
import jnr.ffi.provider.jffi.AllocatedDirectMemoryIO;
import jnr.ffi.provider.jffi.DirectMemoryIO;
import jnr.ffi.provider.jffi.NativeFinalizer;
import jnr.ffi.util.ref.FinalizableWeakReference;

public class TransientNativeMemory
extends DirectMemoryIO {
    private static final Map<Magazine, Boolean> referenceSet = new ConcurrentHashMap<Magazine, Boolean>();
    private static final ThreadLocal<Magazine> currentMagazine = new ThreadLocal();
    private static final int PAGES_PER_MAGAZINE = 2;
    private final Sentinel sentinel;
    private final int size;

    public static DirectMemoryIO allocate(Runtime runtime, int size2, int align, boolean clear2) {
        long address2;
        Sentinel sentinel;
        if (size2 > 256) {
            return new AllocatedDirectMemoryIO(runtime, size2, clear2);
        }
        Magazine magazine = currentMagazine.get();
        Sentinel sentinel2 = sentinel = magazine != null ? (Sentinel)magazine.get() : null;
        if (sentinel == null || (address2 = magazine.allocate(size2, align)) == 0L) {
            long memory;
            PageManager pm = PageManager.getInstance();
            while ((memory = pm.allocatePages(2, 3)) == 0L || memory == -1L) {
                System.gc();
            }
            sentinel = new Sentinel();
            magazine = new Magazine(sentinel, pm, memory, 2);
            referenceSet.put(magazine, Boolean.TRUE);
            currentMagazine.set(magazine);
            address2 = magazine.allocate(size2, align);
        }
        return new TransientNativeMemory(runtime, sentinel, address2, size2);
    }

    TransientNativeMemory(Runtime runtime, Sentinel sentinel, long address2, int size2) {
        super(runtime, address2);
        this.sentinel = sentinel;
        this.size = size2;
    }

    private static long align(long offset2, long align) {
        return offset2 + align - 1L & (align - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public long size() {
        return this.size;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransientNativeMemory) {
            TransientNativeMemory mem = (TransientNativeMemory)obj;
            return mem.size == this.size && mem.address() == this.address;
        }
        return super.equals(obj);
    }

    public String toString() {
        return String.format(this.getClass().getName() + " address=%x size=%d", this.address, this.size());
    }

    public final void dispose() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Magazine
    extends FinalizableWeakReference<Sentinel> {
        private final PageManager pm;
        private final long page;
        private final long end;
        private final int pageCount;
        private long memory;

        Magazine(Sentinel sentinel, PageManager pm, long page, int pageCount) {
            super(sentinel, NativeFinalizer.getInstance().getFinalizerQueue());
            this.pm = pm;
            this.memory = this.page = page;
            this.pageCount = pageCount;
            this.end = this.memory + (long)pageCount * pm.pageSize();
        }

        long allocate(int size2, int align) {
            long address2 = TransientNativeMemory.align(this.memory, align);
            if (address2 + (long)size2 <= this.end) {
                this.memory = address2 + (long)size2;
                return address2;
            }
            return 0L;
        }

        @Override
        public final void finalizeReferent() {
            this.pm.freePages(this.page, this.pageCount);
            referenceSet.remove(this);
        }
    }

    private static final class Sentinel {
        private Sentinel() {
        }
    }
}

