/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;

public class multipart_signed
implements DataContentHandler {
    private static final ActivationDataFlavor ADF = new ActivationDataFlavor(MimeMultipart.class, "multipart/signed", "Multipart Signed");
    private static final DataFlavor[] DFS = new DataFlavor[]{ADF};

    public Object getContent(DataSource dataSource) throws IOException {
        try {
            return new MimeMultipart(dataSource);
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        if (ADF.equals(dataFlavor)) {
            return this.getContent(dataSource);
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return DFS;
    }

    public void writeTo(Object object, String string2, OutputStream outputStream) throws IOException {
        if (object instanceof MimeMultipart) {
            try {
                this.outputBodyPart(outputStream, object);
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException.getMessage());
            }
        } else if (object instanceof byte[]) {
            outputStream.write((byte[])object);
        } else if (object instanceof InputStream) {
            int n;
            InputStream inputStream = (InputStream)object;
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            while ((n = inputStream.read()) >= 0) {
                outputStream.write(n);
            }
        } else if (object instanceof SMIMEStreamingProcessor) {
            SMIMEStreamingProcessor sMIMEStreamingProcessor = (SMIMEStreamingProcessor)object;
            sMIMEStreamingProcessor.write(outputStream);
        } else {
            throw new IOException("unknown object in writeTo " + object);
        }
    }

    private void outputBodyPart(OutputStream outputStream, Object object) throws MessagingException, IOException {
        if (object instanceof Multipart) {
            Multipart multipart = (Multipart)object;
            ContentType contentType = new ContentType(multipart.getContentType());
            String string2 = "--" + contentType.getParameter("boundary");
            LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
            for (int j = 0; j < multipart.getCount(); ++j) {
                lineOutputStream.writeln(string2);
                this.outputBodyPart(outputStream, multipart.getBodyPart(j));
                lineOutputStream.writeln();
            }
            lineOutputStream.writeln(string2 + "--");
            return;
        }
        MimeBodyPart mimeBodyPart = (MimeBodyPart)object;
        if (mimeBodyPart.getContent() instanceof Multipart) {
            Multipart multipart = (Multipart)mimeBodyPart.getContent();
            ContentType contentType = new ContentType(multipart.getContentType());
            String string3 = "--" + contentType.getParameter("boundary");
            LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
            Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                lineOutputStream.writeln((String)enumeration.nextElement());
            }
            lineOutputStream.writeln();
            multipart_signed.outputPreamble(lineOutputStream, mimeBodyPart, string3);
            this.outputBodyPart(outputStream, multipart);
            return;
        }
        mimeBodyPart.writeTo(outputStream);
    }

    static void outputPreamble(LineOutputStream lineOutputStream, MimeBodyPart mimeBodyPart, String string2) throws MessagingException, IOException {
        String string3;
        InputStream inputStream;
        try {
            inputStream = mimeBodyPart.getRawInputStream();
        }
        catch (MessagingException messagingException) {
            return;
        }
        while ((string3 = multipart_signed.readLine(inputStream)) != null && !string3.equals(string2)) {
            lineOutputStream.writeln(string3);
        }
        inputStream.close();
        if (string3 == null) {
            throw new MessagingException("no boundary found");
        }
    }

    private static String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) >= 0 && n != 10) {
            if (n == 13) continue;
            stringBuffer.append((char)n);
        }
        if (n < 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private static class LineOutputStream
    extends FilterOutputStream {
        private static byte[] newline = new byte[2];

        public LineOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void writeln(String string2) throws MessagingException {
            try {
                byte[] byArray = LineOutputStream.getBytes(string2);
                this.out.write(byArray);
                this.out.write(newline);
            }
            catch (Exception exception2) {
                throw new MessagingException("IOException", exception2);
            }
        }

        public void writeln() throws MessagingException {
            try {
                this.out.write(newline);
            }
            catch (Exception exception2) {
                throw new MessagingException("IOException", exception2);
            }
        }

        private static byte[] getBytes(String string2) {
            char[] cArray = string2.toCharArray();
            int n = cArray.length;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)cArray[n2++];
            }
            return byArray;
        }

        static {
            LineOutputStream.newline[0] = 13;
            LineOutputStream.newline[1] = 10;
        }
    }
}

