/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import java.nio.channels.spi.SelectorProvider;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.enxio.channels.NativeServerSocketChannel;
import jnr.ffi.byref.IntByReference;
import jnr.unixsocket.Native;
import jnr.unixsocket.SockAddrUnix;
import jnr.unixsocket.UnixServerSocket;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class UnixServerSocketChannel
extends NativeServerSocketChannel {
    private final UnixServerSocket socket = new UnixServerSocket(this);

    UnixServerSocketChannel(UnixServerSocket unixServerSocket) throws IOException {
        super(Native.socket(ProtocolFamily.PF_UNIX, Sock.SOCK_STREAM, 0));
    }

    UnixServerSocketChannel(SelectorProvider selectorProvider, int n) {
        super(selectorProvider, n, 16);
    }

    public static UnixServerSocketChannel open() throws IOException {
        return new UnixServerSocket().channel;
    }

    public UnixSocketChannel accept() throws IOException {
        UnixSocketAddress unixSocketAddress = new UnixSocketAddress();
        SockAddrUnix sockAddrUnix = unixSocketAddress.getStruct();
        IntByReference intByReference = new IntByReference(sockAddrUnix.getMaximumLength());
        int n = Native.accept(this.getFD(), sockAddrUnix, intByReference);
        if (n < 0) {
            throw new IOException("accept failed: " + Native.getLastErrorString());
        }
        Native.setBlocking(n, true);
        return new UnixSocketChannel(n, unixSocketAddress);
    }

    public final UnixServerSocket socket() {
        return this.socket;
    }
}

