/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jnr.posix.util.Platform;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSEnvironment {
    public Map getEnvironmentVariableMap(Ruby runtime) {
        Map envs = null;
        if (runtime.getInstanceConfig().getEnvironment() != null) {
            return OSEnvironment.getAsMapOfRubyStrings(runtime, runtime.getInstanceConfig().getEnvironment().entrySet());
        }
        if (Ruby.isSecurityRestricted()) {
            envs = new HashMap();
        } else {
            Map<String, String> variables = System.getenv();
            envs = OSEnvironment.getAsMapOfRubyStrings(runtime, variables.entrySet());
        }
        return envs;
    }

    public Map getSystemPropertiesMap(Ruby runtime) {
        if (Ruby.isSecurityRestricted()) {
            return new HashMap();
        }
        return OSEnvironment.getAsMapOfRubyStrings(runtime, ((Properties)System.getProperties().clone()).entrySet());
    }

    private static Map getAsMapOfRubyStrings(Ruby runtime, Set<Map.Entry<Object, Object>> entrySet) {
        HashMap envs = new HashMap();
        Encoding encoding2 = runtime.getEncodingService().getLocaleEncoding();
        if (Platform.IS_WINDOWS) {
            OSEnvironment.addRubyKeyValuePair(runtime, envs, "HOME", SafePropertyAccessor.getProperty("user.home"), encoding2);
            OSEnvironment.addRubyKeyValuePair(runtime, envs, "USER", SafePropertyAccessor.getProperty("user.name"), encoding2);
        }
        for (Map.Entry<Object, Object> entry : entrySet) {
            String value2 = (String)entry.getValue();
            String key2 = (String)entry.getKey();
            OSEnvironment.addRubyKeyValuePair(runtime, envs, key2, value2, encoding2);
        }
        return envs;
    }

    private static void addRubyKeyValuePair(Ruby runtime, Map map, String key2, String value2, Encoding encoding2) {
        ByteList keyBytes = new ByteList(key2.getBytes(), encoding2);
        ByteList valueBytes = new ByteList(value2.getBytes(), encoding2);
        RubyString keyString = runtime.newString(keyBytes);
        RubyString valueString = runtime.newString(valueBytes);
        keyString.setFrozen(true);
        valueString.setFrozen(true);
        map.put(keyString, valueString);
    }
}

