/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyString;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.CExtension;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.ExternalScript;
import org.jruby.runtime.load.JarredScript;
import org.jruby.runtime.load.JavaCompiledScript;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.URLUtil;
import org.jruby.util.collections.StringArraySet;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class LoadService {
    private static final Logger LOG = LoggerFactory.getLogger("LoadService");
    private final LoadTimer loadTimer;
    protected static final Pattern sourcePattern = Pattern.compile("\\.(?:rb)$");
    protected static final Pattern extensionPattern = Pattern.compile("\\.(?:so|o|dll|bundle|jar)$");
    protected RubyArray loadPath;
    protected StringArraySet loadedFeatures;
    protected final Map<String, Library> builtinLibraries = new HashMap<String, Library>();
    protected final Map<String, JarFile> jarFiles = new HashMap<String, JarFile>();
    protected final Ruby runtime;
    protected final RequireLocks requireLocks = new RequireLocks();
    protected final List<LoadSearcher> searchers = new ArrayList<LoadSearcher>();

    public LoadService(Ruby runtime) {
        this.searchers.add(new SourceBailoutSearcher());
        this.searchers.add(new NormalSearcher());
        this.searchers.add(new ClassLoaderSearcher());
        this.searchers.add(new BailoutSearcher());
        this.searchers.add(new ExtensionSearcher());
        this.searchers.add(new ScriptClassSearcher());
        this.runtime = runtime;
        this.loadTimer = RubyInstanceConfig.DEBUG_LOAD_TIMINGS ? new TracingLoadTimer() : new LoadTimer();
    }

    public void init(List additionalDirectories) {
        RubyString env_rubylib;
        this.loadPath = RubyArray.newArray(this.runtime);
        String jrubyHome = this.runtime.getJRubyHome();
        this.loadedFeatures = new StringArraySet(this.runtime);
        Iterator iter = additionalDirectories.iterator();
        while (iter.hasNext()) {
            this.addPath((String)iter.next());
        }
        RubyHash env = (RubyHash)this.runtime.getObject().getConstant("ENV");
        if (env.has_key_p(env_rubylib = this.runtime.newString("RUBYLIB")).isTrue()) {
            String rubylib = env.op_aref(this.runtime.getCurrentContext(), env_rubylib).toString();
            String[] paths = rubylib.split(File.pathSeparator);
            for (int i2 = 0; i2 < paths.length; ++i2) {
                this.addPath(paths[i2]);
            }
        }
        try {
            if (jrubyHome != null) {
                char sep = '/';
                String rubyDir = jrubyHome + sep + "lib" + sep + "ruby" + sep;
                if (this.runtime.is1_9()) {
                    this.addPath(rubyDir + "site_ruby" + sep + "1.9");
                    this.addPath(rubyDir + "shared");
                    this.addPath(rubyDir + "1.9");
                } else {
                    this.addPath(rubyDir + "site_ruby" + sep + "1.8");
                    this.addPath(rubyDir + "shared");
                    this.addPath(rubyDir + "1.8");
                }
            }
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        if (!this.runtime.is1_9() && this.runtime.getSafeLevel() == 0) {
            this.addPath(".");
        }
    }

    protected void addLoadedFeature(String name2) {
        this.loadedFeatures.append(RubyString.newString(this.runtime, name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPath(String path2) {
        if (path2 == null || path2.length() == 0) {
            return;
        }
        RubyArray rubyArray = this.loadPath;
        synchronized (rubyArray) {
            this.loadPath.append(this.runtime.newString(path2.replace('\\', '/')));
        }
    }

    public void load(String file2, boolean wrap2) {
        if (!this.runtime.getProfile().allowLoad(file2)) {
            throw this.runtime.newLoadError("no such file to load -- " + file2);
        }
        SearchState state2 = new SearchState(file2);
        state2.prepareLoadSearch(file2);
        Library library2 = this.findBuiltinLibrary(state2, state2.searchFile, state2.suffixType);
        if (library2 == null) {
            library2 = this.findLibraryWithoutCWD(state2, state2.searchFile, state2.suffixType);
        }
        if (library2 == null && (library2 = this.findLibraryWithClassloaders(state2, state2.searchFile, state2.suffixType)) == null) {
            throw this.runtime.newLoadError("no such file to load -- " + file2);
        }
        try {
            library2.load(this.runtime, wrap2);
        }
        catch (IOException e) {
            if (this.runtime.getDebug().isTrue()) {
                e.printStackTrace(this.runtime.getErr());
            }
            throw LoadService.newLoadErrorFromThrowable(this.runtime, file2, e);
        }
    }

    public void loadFromClassLoader(ClassLoader classLoader, String file2, boolean wrap2) {
        SearchState state2 = new SearchState(file2);
        state2.prepareLoadSearch(file2);
        Library library2 = null;
        LoadServiceResource resource2 = this.getClassPathResource(classLoader, file2);
        if (resource2 != null) {
            state2.loadName = this.resolveLoadName(resource2, file2);
            library2 = this.createLibrary(state2, resource2);
        }
        if (library2 == null) {
            throw this.runtime.newLoadError("no such file to load -- " + file2);
        }
        try {
            library2.load(this.runtime, wrap2);
        }
        catch (IOException e) {
            if (this.runtime.getDebug().isTrue()) {
                e.printStackTrace(this.runtime.getErr());
            }
            throw LoadService.newLoadErrorFromThrowable(this.runtime, file2, e);
        }
    }

    public SearchState findFileForLoad(String file2) {
        if (Platform.IS_WINDOWS) {
            file2 = file2.replace('\\', '/');
        }
        if (file2.endsWith(".so")) {
            file2 = file2.replaceAll(".so$", ".jar");
        }
        SearchState state2 = new SearchState(file2);
        state2.prepareRequireSearch(file2);
        for (LoadSearcher searcher : this.searchers) {
            if (!searcher.shouldTrySearch(state2) || searcher.trySearch(state2)) continue;
            return null;
        }
        return state2;
    }

    public boolean require(String requireName) {
        return this.requireCommon(requireName, true) == RequireState.LOADED;
    }

    public boolean autoloadRequire(String requireName) {
        return this.requireCommon(requireName, false) != RequireState.CIRCULAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RequireState requireCommon(String requireName, boolean circularRequireWarning) {
        RequireState requireState;
        block10: {
            RequireState requireState2;
            block9: {
                if (this.featureAlreadyLoaded(requireName)) {
                    return RequireState.ALREADY_LOADED;
                }
                if (!this.requireLocks.lock(requireName)) {
                    if (!circularRequireWarning) return RequireState.CIRCULAR;
                    if (!this.runtime.isVerbose()) return RequireState.CIRCULAR;
                    if (!this.runtime.is1_9()) return RequireState.CIRCULAR;
                    this.warnCircularRequire(requireName);
                    return RequireState.CIRCULAR;
                }
                try {
                    if (!this.runtime.getProfile().allowRequire(requireName)) {
                        throw this.runtime.newLoadError("no such file to load -- " + requireName);
                    }
                    if (this.featureAlreadyLoaded(requireName)) {
                        requireState2 = RequireState.ALREADY_LOADED;
                        Object var11_4 = null;
                        break block9;
                    }
                    long startTime = this.loadTimer.startLoad(requireName);
                    try {
                        boolean loaded = this.smartLoadInternal(requireName);
                        requireState = loaded ? RequireState.LOADED : RequireState.ALREADY_LOADED;
                        Object var9_10 = null;
                        this.loadTimer.endLoad(requireName, startTime);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        this.loadTimer.endLoad(requireName, startTime);
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_6 = null;
                    this.requireLocks.unlock(requireName);
                    throw throwable;
                }
            }
            this.requireLocks.unlock(requireName);
            return requireState2;
        }
        Object var11_5 = null;
        this.requireLocks.unlock(requireName);
        return requireState;
    }

    protected void warnCircularRequire(String requireName) {
        this.runtime.getWarnings().warn("loading in progress, circular require considered harmful - " + requireName);
        RaiseException ex = new RaiseException(this.runtime, this.runtime.getRuntimeError(), null, false);
        String trace = this.runtime.getInstanceConfig().getTraceType().printBacktrace(ex.getException(), this.runtime.getPosix().isatty(FileDescriptor.err));
        System.err.print(trace.replaceFirst("[^\n]*\n", ""));
    }

    @Deprecated
    public boolean smartLoad(String file2) {
        return this.require(file2);
    }

    private boolean smartLoadInternal(String file2) {
        this.checkEmptyLoad(file2);
        SearchState state2 = this.findFileForLoad(file2);
        if (state2 == null) {
            return false;
        }
        if (state2.library == null) {
            throw this.runtime.newLoadError("no such file to load -- " + state2.searchFile);
        }
        if (this.featureAlreadyLoaded(state2.loadName)) {
            return false;
        }
        boolean loaded = this.tryLoadingLibraryOrScript(this.runtime, state2);
        if (loaded) {
            this.addLoadedFeature(state2.loadName);
        }
        return loaded;
    }

    public static void reflectedLoad(Ruby runtime, String libraryName, String className, ClassLoader classLoader, boolean wrap2) {
        block7: {
            try {
                Object libObject;
                if (classLoader == null && Ruby.isSecurityRestricted()) {
                    classLoader = runtime.getInstanceConfig().getLoader();
                }
                if ((libObject = classLoader.loadClass(className).newInstance()) instanceof Library) {
                    Library library2 = (Library)libObject;
                    library2.load(runtime, false);
                    break block7;
                }
                if (libObject instanceof BasicLibraryService) {
                    BasicLibraryService service = (BasicLibraryService)libObject;
                    service.basicLoad(runtime);
                    break block7;
                }
                throw runtime.newLoadError("library `" + libraryName + "' is not of type Library or BasicLibraryService");
            }
            catch (RaiseException re) {
                throw re;
            }
            catch (Throwable e) {
                if (runtime.getDebug().isTrue()) {
                    e.printStackTrace();
                }
                throw runtime.newLoadError("library `" + libraryName + "' could not be loaded: " + e);
            }
        }
    }

    public IRubyObject getLoadPath() {
        return this.loadPath;
    }

    public IRubyObject getLoadedFeatures() {
        return this.loadedFeatures;
    }

    public void addBuiltinLibrary(String name2, Library library2) {
        this.builtinLibraries.put(name2, library2);
    }

    public void removeBuiltinLibrary(String name2) {
        this.builtinLibraries.remove(name2);
    }

    public void removeInternalLoadedFeature(String name2) {
        RubyString nameRubyString = this.runtime.newString(name2);
        this.loadedFeatures.delete(this.runtime.getCurrentContext(), nameRubyString, Block.NULL_BLOCK);
    }

    protected boolean featureAlreadyLoaded(String name2) {
        return this.loadedFeatures.containsString(name2);
    }

    protected boolean isJarfileLibrary(SearchState state2, String file2) {
        return state2.library instanceof JarredScript && file2.endsWith(".jar");
    }

    protected void reraiseRaiseExceptions(Throwable e) throws RaiseException {
        if (e instanceof RaiseException) {
            throw (RaiseException)e;
        }
    }

    protected boolean tryLoadingLibraryOrScript(Ruby runtime, SearchState state2) {
        try {
            state2.library.load(runtime, false);
            return true;
        }
        catch (MainExitException mee) {
            throw mee;
        }
        catch (Throwable e) {
            if (this.isJarfileLibrary(state2, state2.searchFile)) {
                return true;
            }
            this.reraiseRaiseExceptions(e);
            if (runtime.getDebug().isTrue()) {
                e.printStackTrace(runtime.getErr());
            }
            RaiseException re = LoadService.newLoadErrorFromThrowable(runtime, state2.searchFile, e);
            re.initCause(e);
            throw re;
        }
    }

    private static RaiseException newLoadErrorFromThrowable(Ruby runtime, String file2, Throwable t) {
        return runtime.newLoadError(String.format("load error: %s -- %s: %s", file2, t.getClass().getName(), t.getMessage()));
    }

    protected String buildClassName(String className) {
        if ((className = className.replaceFirst("^\\.\\/", "")).lastIndexOf(".") != -1) {
            className = className.substring(0, className.lastIndexOf("."));
        }
        className = className.replace("-", "_minus_").replace('.', '_');
        return className;
    }

    protected void checkEmptyLoad(String file2) throws RaiseException {
        if (file2.equals("")) {
            throw this.runtime.newLoadError("no such file to load -- " + file2);
        }
    }

    protected void debugLogTry(String what, String msg) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            LOG.info("LoadService: trying " + what + ": " + msg, new Object[0]);
        }
    }

    protected void debugLogFound(String what, String msg) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            LOG.info("LoadService: found " + what + ": " + msg, new Object[0]);
        }
    }

    protected void debugLogFound(LoadServiceResource resource2) {
        if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
            String resourceUrl;
            try {
                resourceUrl = resource2.getURL().toString();
            }
            catch (IOException e) {
                resourceUrl = e.getMessage();
            }
            LOG.info("LoadService: found: " + resourceUrl, new Object[0]);
        }
    }

    protected Library findBuiltinLibrary(SearchState state2, String baseName, SuffixType suffixType) {
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = baseName + suffix;
            this.debugLogTry("builtinLib", namePlusSuffix);
            if (!this.builtinLibraries.containsKey(namePlusSuffix)) continue;
            state2.loadName = namePlusSuffix;
            Library lib = this.builtinLibraries.get(namePlusSuffix);
            this.debugLogFound("builtinLib", namePlusSuffix);
            return lib;
        }
        return null;
    }

    protected Library findLibraryWithoutCWD(SearchState state2, String baseName, SuffixType suffixType) {
        Library library2 = null;
        switch (suffixType) {
            case Both: {
                library2 = this.findBuiltinLibrary(state2, baseName, SuffixType.Source);
                if (library2 == null) {
                    library2 = this.createLibrary(state2, this.tryResourceFromJarURL(state2, baseName, SuffixType.Source));
                }
                if (library2 == null) {
                    library2 = this.createLibrary(state2, this.tryResourceFromLoadPathOrURL(state2, baseName, SuffixType.Source));
                }
                if (library2 == null) {
                    library2 = this.findBuiltinLibrary(state2, baseName, SuffixType.Extension);
                }
                if (library2 == null) {
                    library2 = this.createLibrary(state2, this.tryResourceFromJarURL(state2, baseName, SuffixType.Extension));
                }
                if (library2 != null) break;
                library2 = this.createLibrary(state2, this.tryResourceFromLoadPathOrURL(state2, baseName, SuffixType.Extension));
                break;
            }
            case Source: 
            case Extension: {
                library2 = this.findBuiltinLibrary(state2, baseName, suffixType);
                if (library2 == null) {
                    library2 = this.createLibrary(state2, this.tryResourceFromJarURL(state2, baseName, suffixType));
                }
                if (library2 != null) break;
                library2 = this.createLibrary(state2, this.tryResourceFromLoadPathOrURL(state2, baseName, suffixType));
                break;
            }
            case Neither: {
                library2 = this.createLibrary(state2, this.tryResourceFromJarURL(state2, baseName, SuffixType.Neither));
                if (library2 != null) break;
                library2 = this.createLibrary(state2, this.tryResourceFromLoadPathOrURL(state2, baseName, SuffixType.Neither));
            }
        }
        return library2;
    }

    protected Library findLibraryWithClassloaders(SearchState state2, String baseName, SuffixType suffixType) {
        for (String suffix : suffixType.getSuffixes()) {
            String file2 = baseName + suffix;
            LoadServiceResource resource2 = this.findFileInClasspath(file2);
            if (resource2 == null) continue;
            state2.loadName = this.resolveLoadName(resource2, file2);
            return this.createLibrary(state2, resource2);
        }
        return null;
    }

    protected Library createLibrary(SearchState state2, LoadServiceResource resource2) {
        if (resource2 == null) {
            return null;
        }
        String file2 = state2.loadName;
        if (file2.endsWith(".so") || file2.endsWith(".dll") || file2.endsWith(".bundle")) {
            if (this.runtime.getInstanceConfig().isCextEnabled()) {
                return new CExtension(resource2);
            }
            throw this.runtime.newLoadError("C extensions are disabled, can't load `" + resource2.getName() + "'");
        }
        if (file2.endsWith(".jar")) {
            return new JarredScript(resource2);
        }
        if (file2.endsWith(".class")) {
            return new JavaCompiledScript(resource2);
        }
        return new ExternalScript(resource2, file2);
    }

    protected LoadServiceResource tryResourceFromCWD(SearchState state2, String baseName, SuffixType suffixType) throws RaiseException {
        LoadServiceResource foundResource = null;
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = baseName + suffix;
            try {
                JRubyFile file2 = JRubyFile.create(this.runtime.getCurrentDirectory(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                this.debugLogTry("resourceFromCWD", file2.toString());
                if (!file2.isFile() || !file2.isAbsolute() || !file2.canRead()) continue;
                boolean absolute = true;
                foundResource = new LoadServiceResource(file2, this.getFileName(file2, namePlusSuffix), absolute);
                this.debugLogFound(foundResource);
                state2.loadName = this.resolveLoadName(foundResource, namePlusSuffix);
                break;
            }
            catch (IllegalArgumentException illArgEx) {
            }
            catch (SecurityException secEx) {
                // empty catch block
            }
        }
        return foundResource;
    }

    protected LoadServiceResource tryResourceFromHome(SearchState state2, String baseName, SuffixType suffixType) throws RaiseException {
        RubyString env_home;
        LoadServiceResource foundResource = null;
        RubyHash env = (RubyHash)this.runtime.getObject().getConstant("ENV");
        if (env.has_key_p(env_home = this.runtime.newString("HOME")).isFalse()) {
            return null;
        }
        String home2 = env.op_aref(this.runtime.getCurrentContext(), env_home).toString();
        String path2 = baseName.substring(2);
        for (String suffix : suffixType.getSuffixes()) {
            String namePlusSuffix = path2 + suffix;
            try {
                JRubyFile file2 = JRubyFile.create(home2, RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                this.debugLogTry("resourceFromHome", file2.toString());
                if (!file2.isFile() || !file2.isAbsolute() || !file2.canRead()) continue;
                boolean absolute = true;
                state2.loadName = file2.getPath();
                foundResource = new LoadServiceResource(file2, state2.loadName, absolute);
                this.debugLogFound(foundResource);
                break;
            }
            catch (IllegalArgumentException illArgEx) {
            }
            catch (SecurityException secEx) {
                // empty catch block
            }
        }
        return foundResource;
    }

    protected LoadServiceResource tryResourceFromJarURL(SearchState state2, String baseName, SuffixType suffixType) {
        LoadServiceResource foundResource;
        block10: {
            block11: {
                foundResource = null;
                if (!baseName.startsWith("jar:")) break block11;
                for (String suffix : suffixType.getSuffixes()) {
                    String namePlusSuffix = baseName + suffix;
                    try {
                        URL url = new URL(namePlusSuffix);
                        this.debugLogTry("resourceFromJarURL", url.toString());
                        if (url.openStream() != null) {
                            foundResource = new LoadServiceResource(url, namePlusSuffix);
                            this.debugLogFound(foundResource);
                        }
                    }
                    catch (FileNotFoundException e) {
                    }
                    catch (MalformedURLException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                    catch (IOException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                    if (foundResource == null) continue;
                    state2.loadName = this.resolveLoadName(foundResource, namePlusSuffix);
                    break block10;
                }
                break block10;
            }
            if (!baseName.startsWith("file:") || baseName.indexOf("!/") == -1) break block10;
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                try {
                    String jarFile = namePlusSuffix.substring(5, namePlusSuffix.indexOf("!/"));
                    JarFile file2 = new JarFile(jarFile);
                    String expandedFilename = this.expandRelativeJarPath(namePlusSuffix.substring(namePlusSuffix.indexOf("!/") + 2));
                    this.debugLogTry("resourceFromJarURL", expandedFilename.toString());
                    if (file2.getJarEntry(expandedFilename) != null) {
                        foundResource = new LoadServiceResource(new URL("jar:file:" + jarFile + "!/" + expandedFilename), namePlusSuffix);
                        this.debugLogFound(foundResource);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (foundResource == null) continue;
                state2.loadName = this.resolveLoadName(foundResource, namePlusSuffix);
                break;
            }
        }
        return foundResource;
    }

    protected LoadServiceResource tryResourceFromLoadPathOrURL(SearchState state2, String baseName, SuffixType suffixType) {
        LoadServiceResource foundResource = null;
        if (baseName.startsWith("./")) {
            foundResource = this.tryResourceFromCWD(state2, baseName, suffixType);
            if (foundResource != null) {
                state2.loadName = this.resolveLoadName(foundResource, foundResource.getName());
            }
            return foundResource;
        }
        if (baseName.startsWith("~/")) {
            foundResource = this.tryResourceFromHome(state2, baseName, suffixType);
            if (foundResource != null) {
                state2.loadName = this.resolveLoadName(foundResource, foundResource.getName());
            }
            return foundResource;
        }
        if (new File(baseName).isAbsolute() || baseName.startsWith("../")) {
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                foundResource = this.tryResourceAsIs(namePlusSuffix);
                if (foundResource == null) continue;
                state2.loadName = this.resolveLoadName(foundResource, namePlusSuffix);
                return foundResource;
            }
            return null;
        }
        block1: for (int i2 = 0; i2 < this.loadPath.size(); ++i2) {
            String loadPathEntry = this.getLoadPathEntry(this.loadPath.eltInternal(i2));
            if (loadPathEntry.equals(".") || loadPathEntry.equals("")) {
                foundResource = this.tryResourceFromCWD(state2, baseName, suffixType);
                if (foundResource == null) continue;
                String ss = foundResource.getName();
                if (ss.startsWith("./")) {
                    ss = ss.substring(2);
                }
                state2.loadName = this.resolveLoadName(foundResource, ss);
                break;
            }
            boolean looksLikeJarURL = this.loadPathLooksLikeJarURL(loadPathEntry);
            boolean looksLikeClasspathURL = this.loadPathLooksLikeClasspathURL(loadPathEntry);
            for (String suffix : suffixType.getSuffixes()) {
                String namePlusSuffix = baseName + suffix;
                foundResource = looksLikeJarURL ? this.tryResourceFromJarURLWithLoadPath(namePlusSuffix, loadPathEntry) : (looksLikeClasspathURL ? this.findFileInClasspath(loadPathEntry + "/" + namePlusSuffix) : this.tryResourceFromLoadPath(namePlusSuffix, loadPathEntry));
                if (foundResource == null) continue;
                String ss = namePlusSuffix;
                if (ss.startsWith("./")) {
                    ss = ss.substring(2);
                }
                state2.loadName = this.resolveLoadName(foundResource, ss);
                break block1;
            }
        }
        return foundResource;
    }

    protected String getLoadPathEntry(IRubyObject entry) {
        RubyString entryString = entry.convertToString();
        return entryString.asJavaString();
    }

    protected LoadServiceResource tryResourceFromJarURLWithLoadPath(String namePlusSuffix, String loadPathEntry) {
        LoadServiceResource foundResource = null;
        String[] urlParts = this.splitJarUrl(loadPathEntry);
        String jarFileName = urlParts[0];
        String entryPath = urlParts[1];
        JarFile current2 = this.getJarFile(jarFileName);
        if (current2 != null) {
            String canonicalEntry = (entryPath.length() > 0 ? entryPath + "/" : "") + namePlusSuffix;
            this.debugLogTry("resourceFromJarURLWithLoadPath", current2.getName() + "!/" + canonicalEntry);
            if (current2.getJarEntry(canonicalEntry) != null) {
                try {
                    String resourceUrl = "jar:file:" + jarFileName + "!/" + canonicalEntry;
                    foundResource = new LoadServiceResource(new URL(resourceUrl), resourceUrl);
                    this.debugLogFound(foundResource);
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
            }
        }
        return foundResource;
    }

    public JarFile getJarFile(String jarFileName) {
        JarFile jarFile = this.jarFiles.get(jarFileName);
        if (null == jarFile) {
            try {
                jarFile = new JarFile(jarFileName);
                this.jarFiles.put(jarFileName, jarFile);
            }
            catch (ZipException ignored) {
                if (this.runtime.getInstanceConfig().isDebug()) {
                    LOG.info("ZipException trying to access " + jarFileName + ", stack trace follows:", new Object[0]);
                    ignored.printStackTrace(this.runtime.getErr());
                }
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException e) {
                throw this.runtime.newIOErrorFromException(e);
            }
        }
        return jarFile;
    }

    protected boolean loadPathLooksLikeJarURL(String loadPathEntry) {
        return loadPathEntry.startsWith("jar:") || loadPathEntry.endsWith(".jar") || loadPathEntry.startsWith("file:") && loadPathEntry.indexOf("!") != -1;
    }

    protected boolean loadPathLooksLikeClasspathURL(String loadPathEntry) {
        return loadPathEntry.startsWith("classpath:");
    }

    private String[] splitJarUrl(String loadPathEntry) {
        String entry;
        int idx = loadPathEntry.indexOf("!");
        if (idx == -1) {
            return new String[]{loadPathEntry, ""};
        }
        String filename2 = loadPathEntry.substring(0, idx);
        String string2 = entry = idx + 2 < loadPathEntry.length() ? loadPathEntry.substring(idx + 2) : "";
        if (filename2.startsWith("jar:")) {
            filename2 = filename2.substring(4);
        }
        if (filename2.startsWith("file:")) {
            filename2 = filename2.substring(5);
        }
        return new String[]{filename2, entry};
    }

    protected LoadServiceResource tryResourceFromLoadPath(String namePlusSuffix, String loadPathEntry) throws RaiseException {
        LoadServiceResource foundResource = null;
        try {
            if (!Ruby.isSecurityRestricted()) {
                String reportedPath = loadPathEntry + "/" + namePlusSuffix;
                boolean absolute = true;
                if (!new File(reportedPath).isAbsolute()) {
                    absolute = false;
                    if (reportedPath.charAt(0) != '.') {
                        reportedPath = "./" + reportedPath;
                    }
                    loadPathEntry = JRubyFile.create(this.runtime.getCurrentDirectory(), loadPathEntry).getAbsolutePath();
                }
                JRubyFile actualPath = JRubyFile.create(loadPathEntry, RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                if (RubyInstanceConfig.DEBUG_LOAD_SERVICE) {
                    this.debugLogTry("resourceFromLoadPath", "'" + actualPath.toString() + "' " + actualPath.isFile() + " " + actualPath.canRead());
                }
                if (actualPath.isFile() && actualPath.canRead()) {
                    foundResource = new LoadServiceResource(actualPath, reportedPath, absolute);
                    this.debugLogFound(foundResource);
                }
            }
        }
        catch (SecurityException secEx) {
            // empty catch block
        }
        return foundResource;
    }

    protected LoadServiceResource tryResourceAsIs(String namePlusSuffix) throws RaiseException {
        LoadServiceResource foundResource = null;
        try {
            if (!Ruby.isSecurityRestricted()) {
                File actualPath;
                String reportedPath = namePlusSuffix;
                if (new File(reportedPath).isAbsolute()) {
                    actualPath = new File(RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                } else {
                    if (reportedPath.charAt(0) == '.' && reportedPath.charAt(1) == '/') {
                        reportedPath = reportedPath.replaceFirst("\\./", this.runtime.getCurrentDirectory());
                    }
                    actualPath = JRubyFile.create(this.runtime.getCurrentDirectory(), RubyFile.expandUserPath(this.runtime.getCurrentContext(), namePlusSuffix));
                }
                this.debugLogTry("resourceAsIs", actualPath.toString());
                if (actualPath.isFile() && actualPath.canRead()) {
                    foundResource = new LoadServiceResource(actualPath, reportedPath);
                    this.debugLogFound(foundResource);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return foundResource;
    }

    protected LoadServiceResource findFileInClasspath(String name2) {
        ClassLoader classLoader = this.runtime.getJRubyClassLoader();
        if (Ruby.isSecurityRestricted() && classLoader == null) {
            classLoader = this.runtime.getInstanceConfig().getLoader();
        }
        if (name2.startsWith("classpath:/")) {
            LoadServiceResource foundResource = this.getClassPathResource(classLoader, name2);
            if (foundResource != null) {
                return foundResource;
            }
        } else if (name2.startsWith("classpath:")) {
            name2 = name2.substring("classpath:".length());
        }
        for (int i2 = 0; i2 < this.loadPath.size(); ++i2) {
            String entry = this.getLoadPathEntry(this.loadPath.eltInternal(i2));
            if (entry.length() == 0 || entry.charAt(0) == '/' || entry.length() > 1 && entry.charAt(1) == ':') continue;
            if (entry.startsWith("classpath:/")) {
                entry = entry.substring("classpath:/".length());
            } else if (entry.startsWith("classpath:")) {
                entry = entry.substring("classpath:".length());
            }
            String entryName = name2.startsWith(entry) ? name2.substring(entry.length()) : name2;
            LoadServiceResource foundResource = this.getClassPathResource(classLoader, entry + "/" + entryName);
            if (foundResource == null) continue;
            return foundResource;
        }
        if (name2.charAt(0) == '/' || name2.length() > 1 && name2.charAt(1) == ':') {
            return null;
        }
        LoadServiceResource foundResource = this.getClassPathResource(classLoader, name2);
        if (foundResource != null) {
            return foundResource;
        }
        return null;
    }

    protected boolean isRequireable(URL loc) {
        if (loc != null) {
            if (loc.getProtocol().equals("file") && new File(URLUtil.getPath(loc)).isDirectory()) {
                return false;
            }
            try {
                loc.openConnection();
                return true;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return false;
    }

    protected LoadServiceResource getClassPathResource(ClassLoader classLoader, String name2) {
        boolean isClasspathScheme = false;
        if (name2.startsWith("classpath:/")) {
            isClasspathScheme = true;
            name2 = name2.substring("classpath:/".length());
        } else if (name2.startsWith("classpath:")) {
            isClasspathScheme = true;
            name2 = name2.substring("classpath:".length());
        } else if (name2.startsWith("file:") && name2.indexOf("!/") != -1) {
            name2 = name2.substring(name2.indexOf("!/") + 2);
        }
        this.debugLogTry("fileInClasspath", name2);
        URL loc = classLoader.getResource(name2);
        if (loc != null) {
            String path2 = "classpath:/" + name2;
            if (!isClasspathScheme && (loc.getProtocol().equals("jar") || loc.getProtocol().equals("file")) && this.isRequireable(loc)) {
                path2 = URLUtil.getPath(loc);
            }
            LoadServiceResource foundResource = new LoadServiceResource(loc, path2);
            this.debugLogFound(foundResource);
            return foundResource;
        }
        return null;
    }

    private String expandRelativeJarPath(String path2) {
        return path2.replaceAll("/[^/]+/\\.\\.|[^/]+/\\.\\./|\\./", "").replace("^\\\\", "/");
    }

    protected String resolveLoadName(LoadServiceResource foundResource, String previousPath) {
        return previousPath;
    }

    protected String getFileName(JRubyFile file2, String namePlusSuffix) {
        String s2 = namePlusSuffix;
        if (!namePlusSuffix.startsWith("./")) {
            s2 = "./" + s2;
        }
        return s2;
    }

    public static class SearchState {
        public Library library;
        public String loadName;
        public SuffixType suffixType;
        public String searchFile;

        public SearchState(String file2) {
            this.loadName = file2;
        }

        public void prepareRequireSearch(String file2) {
            if (file2.lastIndexOf(46) > file2.lastIndexOf(47)) {
                Matcher matcher = null;
                matcher = sourcePattern.matcher(file2);
                if (matcher.find()) {
                    this.suffixType = SuffixType.Source;
                    this.searchFile = file2.substring(0, matcher.start());
                } else {
                    matcher = extensionPattern.matcher(file2);
                    if (matcher.find()) {
                        this.suffixType = SuffixType.Extension;
                        this.searchFile = file2.substring(0, matcher.start());
                    } else {
                        this.suffixType = SuffixType.Both;
                        this.searchFile = file2;
                    }
                }
            } else {
                this.suffixType = SuffixType.Both;
                this.searchFile = file2;
            }
        }

        public void prepareLoadSearch(String file2) {
            if (file2.lastIndexOf(46) > file2.lastIndexOf(47)) {
                Matcher matcher = null;
                matcher = sourcePattern.matcher(file2);
                if (matcher.find()) {
                    this.suffixType = SuffixType.Source;
                    this.searchFile = file2.substring(0, matcher.start());
                } else {
                    this.suffixType = SuffixType.Neither;
                    this.searchFile = file2;
                }
            } else {
                this.suffixType = SuffixType.Neither;
                this.searchFile = file2;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName()).append(": ");
            sb.append("library=").append(this.library.toString());
            sb.append(", loadName=").append(this.loadName);
            sb.append(", suffixType=").append(this.suffixType.toString());
            sb.append(", searchFile=").append(this.searchFile);
            return sb.toString();
        }
    }

    public class ScriptClassSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state2) {
            return state2.library == null;
        }

        public boolean trySearch(SearchState state2) throws RaiseException {
            Script script;
            String className = LoadService.this.buildClassName(state2.searchFile);
            int lastSlashIndex = className.lastIndexOf(47);
            if (lastSlashIndex > -1 && lastSlashIndex < className.length() - 1 && !Character.isJavaIdentifierStart(className.charAt(lastSlashIndex + 1))) {
                className = lastSlashIndex == -1 ? "_" + className : className.substring(0, lastSlashIndex + 1) + "_" + className.substring(lastSlashIndex + 1);
            }
            className = className.replace('/', '.');
            try {
                Class<?> scriptClass = Class.forName(className);
                script = (Script)scriptClass.newInstance();
            }
            catch (Exception cnfe) {
                return true;
            }
            state2.library = new ScriptClassLibrary(script);
            return true;
        }

        public class ScriptClassLibrary
        implements Library {
            private Script script;

            public ScriptClassLibrary(Script script) {
                this.script = script;
            }

            public void load(Ruby runtime, boolean wrap2) {
                runtime.loadScript(this.script, wrap2);
            }
        }
    }

    public class ExtensionSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state2) {
            return (state2.library == null || state2.library instanceof JarredScript) && !state2.searchFile.equalsIgnoreCase("");
        }

        public boolean trySearch(SearchState state2) {
            Library oldLibrary = state2.library;
            String[] all = state2.searchFile.split("/");
            StringBuilder finName = new StringBuilder();
            int j = all.length - 1;
            for (int i2 = 0; i2 < j; ++i2) {
                finName.append(all[i2].toLowerCase()).append(".");
            }
            try {
                String[] last2 = all[all.length - 1].split("_");
                int j2 = last2.length;
                for (int i3 = 0; i3 < j2; ++i3) {
                    finName.append(Character.toUpperCase(last2[i3].charAt(0))).append(last2[i3].substring(1));
                }
                finName.append("Service");
                String className = finName.toString().replaceAll("^\\.*", "");
                if (state2.library instanceof JarredScript) {
                    LoadService.this.runtime.getJRubyClassLoader().addURL(((JarredScript)state2.library).getResource().getURL());
                }
                Class theClass = LoadService.this.runtime.getJavaSupport().loadJavaClass(className);
                state2.library = new ClassExtensionLibrary(className + ".java", theClass);
            }
            catch (ClassNotFoundException cnfe) {
                if (LoadService.this.runtime.isDebug()) {
                    cnfe.printStackTrace();
                }
            }
            catch (UnsupportedClassVersionError ucve) {
                if (LoadService.this.runtime.isDebug()) {
                    ucve.printStackTrace();
                }
                throw LoadService.this.runtime.newLoadError("JRuby ext built for wrong Java version in `" + finName + "': " + ucve);
            }
            catch (IOException ioe) {
                if (LoadService.this.runtime.isDebug()) {
                    ioe.printStackTrace();
                }
                throw LoadService.this.runtime.newLoadError("IOException loading extension `" + finName + "`: " + ioe);
            }
            catch (Exception e) {
                if (LoadService.this.runtime.isDebug()) {
                    e.printStackTrace();
                }
                throw LoadService.this.runtime.newLoadError("Exception loading extension `" + finName + "`: " + e);
            }
            if (state2.library == null && oldLibrary != null) {
                state2.library = oldLibrary;
            }
            return true;
        }
    }

    public class ClassLoaderSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state2) {
            return state2.library == null;
        }

        public boolean trySearch(SearchState state2) {
            state2.library = LoadService.this.findLibraryWithClassloaders(state2, state2.searchFile, state2.suffixType);
            return true;
        }
    }

    public class NormalSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state2) {
            return state2.library == null;
        }

        public boolean trySearch(SearchState state2) {
            state2.library = LoadService.this.findLibraryWithoutCWD(state2, state2.searchFile, state2.suffixType);
            return true;
        }
    }

    public class SourceBailoutSearcher
    extends BailoutSearcher {
        public boolean shouldTrySearch(SearchState state2) {
            return !extensionPattern.matcher(state2.loadName).find();
        }

        public boolean trySearch(SearchState state2) {
            return super.trySearch(state2.searchFile, SuffixType.Source);
        }
    }

    public class BailoutSearcher
    implements LoadSearcher {
        public boolean shouldTrySearch(SearchState state2) {
            return state2.library == null;
        }

        protected boolean trySearch(String file2, SuffixType suffixType) {
            for (String suffix : suffixType.getSuffixes()) {
                String searchName = file2 + suffix;
                if (!LoadService.this.featureAlreadyLoaded(searchName)) continue;
                return false;
            }
            return true;
        }

        public boolean trySearch(SearchState state2) {
            return this.trySearch(state2.searchFile, state2.suffixType);
        }
    }

    public static interface LoadSearcher {
        public boolean shouldTrySearch(SearchState var1);

        public boolean trySearch(SearchState var1);
    }

    private static class TracingLoadTimer
    extends LoadTimer {
        private final AtomicInteger indent = new AtomicInteger(0);

        private TracingLoadTimer() {
        }

        private String getIndentString() {
            StringBuilder buf = new StringBuilder();
            int i2 = this.indent.get();
            for (int j = 0; j < i2; ++j) {
                buf.append("  ");
            }
            return buf.toString();
        }

        public long startLoad(String file2) {
            this.indent.incrementAndGet();
            LOG.info(this.getIndentString() + "-> " + file2, new Object[0]);
            return System.currentTimeMillis();
        }

        public void endLoad(String file2, long startTime) {
            LOG.info(this.getIndentString() + "<- " + file2 + " - " + (System.currentTimeMillis() - startTime) + "ms", new Object[0]);
            this.indent.decrementAndGet();
        }
    }

    private static class LoadTimer {
        private LoadTimer() {
        }

        public long startLoad(String file2) {
            return 0L;
        }

        public void endLoad(String file2, long startTime) {
        }
    }

    private class RequireLocks {
        private final Map<String, ReentrantLock> pool = new HashMap<String, ReentrantLock>();
        private final ReentrantLock globalLock = new ReentrantLock(true);

        private RequireLocks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean lock(String requireName) {
            while (true) {
                ReentrantLock lock2;
                Map<String, ReentrantLock> map = this.pool;
                synchronized (map) {
                    lock2 = this.pool.get(requireName);
                    if (lock2 == null) {
                        lock2 = LoadService.this.runtime.getInstanceConfig().isGlobalRequireLock() ? this.globalLock : new ReentrantLock();
                        this.pool.put(requireName, lock2);
                    } else if (lock2.isHeldByCurrentThread()) {
                        return false;
                    }
                }
                lock2.lock();
                map = this.pool;
                synchronized (map) {
                    if (this.pool.get(requireName) == lock2) {
                        return true;
                    }
                    lock2.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlock(String requireName) {
            Map<String, ReentrantLock> map = this.pool;
            synchronized (map) {
                ReentrantLock lock2 = this.pool.get(requireName);
                if (lock2 != null) {
                    assert (lock2.isHeldByCurrentThread());
                    lock2.unlock();
                    this.pool.remove(requireName);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RequireState {
        LOADED,
        ALREADY_LOADED,
        CIRCULAR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SuffixType {
        Source,
        Extension,
        Both,
        Neither;

        private static final String[] emptySuffixes;
        public static final String[] sourceSuffixes;
        public static final String[] extensionSuffixes;
        private static final String[] allSuffixes;

        public String[] getSuffixes() {
            switch (this) {
                case Source: {
                    return sourceSuffixes;
                }
                case Extension: {
                    return extensionSuffixes;
                }
                case Both: {
                    return allSuffixes;
                }
                case Neither: {
                    return emptySuffixes;
                }
            }
            throw new RuntimeException("Unknown SuffixType: " + (Object)((Object)this));
        }

        static {
            emptySuffixes = new String[]{""};
            sourceSuffixes = new String[]{".rb", ".class"};
            extensionSuffixes = new String[2];
            SuffixType.extensionSuffixes[0] = ".jar";
            SuffixType.extensionSuffixes[1] = Platform.IS_WINDOWS ? ".dll" : (Platform.IS_MAC ? ".bundle" : ".so");
            allSuffixes = new String[sourceSuffixes.length + extensionSuffixes.length];
            System.arraycopy(sourceSuffixes, 0, allSuffixes, 0, sourceSuffixes.length);
            System.arraycopy(extensionSuffixes, 0, allSuffixes, sourceSuffixes.length, extensionSuffixes.length);
        }
    }
}

