/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLiteral
extends Operand {
    public final ByteList bytelist;
    public final String string;

    public StringLiteral(ByteList val) {
        this.bytelist = val;
        this.string = this.bytelist.toString();
    }

    public StringLiteral(String s2) {
        this.bytelist = ByteList.create(s2);
        this.string = s2;
    }

    @Override
    public boolean hasKnownValue() {
        return true;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return this;
    }

    public String toString() {
        return "\"" + this.string + "\"";
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        return RubyString.newStringShared(context.getRuntime(), this.bytelist);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.StringLiteral(this);
    }

    public ByteList getByteList() {
        return this.bytelist;
    }

    public String getString() {
        return this.string;
    }
}

