/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.RubyRange;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
extends Operand {
    private final Operand begin;
    private final Operand end;
    private boolean exclusive;

    public Range(Operand begin2, Operand end2, boolean exclusive2) {
        this.begin = begin2;
        this.end = end2;
        this.exclusive = exclusive2;
    }

    public String toString() {
        return "(" + this.begin + (this.exclusive ? ".." : "...") + this.end + "):Range";
    }

    @Override
    public boolean hasKnownValue() {
        return this.begin.hasKnownValue() && this.end.hasKnownValue();
    }

    @Override
    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        if (!this.hasKnownValue()) {
            return null;
        }
        return null;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newBegin = this.begin.getSimplifiedOperand(valueMap, force);
        Operand newEnd = this.end.getSimplifiedOperand(valueMap, force);
        return newBegin == this.begin && newEnd == this.end ? this : new Range(newBegin, newEnd, this.exclusive);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.begin.addUsedVariables(l);
        this.end.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return this.hasKnownValue() ? this : new Range(this.begin.cloneForInlining(ii), this.end.cloneForInlining(ii), this.exclusive);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        return RubyRange.newRange(context.getRuntime(), context, (IRubyObject)this.begin.retrieve(context, self, currDynScope, temp), (IRubyObject)this.end.retrieve(context, self, currDynScope, temp), this.exclusive);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Range(this);
    }
}

