/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.internal.runtime.UndefinedAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class GlobalVariable {
    private IAccessor accessor;
    private ArrayList<IRubyObject> traces = null;
    private boolean tracing;

    public GlobalVariable(IAccessor accessor) {
        this.accessor = accessor;
    }

    public static GlobalVariable newUndefined(Ruby runtime, String name2) {
        GlobalVariable variable = new GlobalVariable(null);
        variable.setAccessor(new UndefinedAccessor(runtime, variable, name2));
        return variable;
    }

    public IAccessor getAccessor() {
        return this.accessor;
    }

    public ArrayList getTraces() {
        return this.traces;
    }

    public void addTrace(RubyProc command) {
        if (this.traces == null) {
            this.traces = new ArrayList();
        }
        this.traces.add(command);
    }

    public boolean removeTrace(IRubyObject command) {
        if (this.traces == null || !this.traces.contains(command)) {
            return false;
        }
        this.traces.remove(command);
        return true;
    }

    public void removeTraces() {
        this.traces = null;
    }

    public void setAccessor(IAccessor accessor) {
        this.accessor = accessor;
    }

    public boolean isTracing() {
        return this.tracing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(IRubyObject value2) {
        if (this.traces == null) {
            return;
        }
        ThreadContext context = value2.getRuntime().getCurrentContext();
        if (context.isWithinTrace()) {
            return;
        }
        try {
            context.setWithinTrace(true);
            for (int i2 = 0; i2 < this.traces.size(); ++i2) {
                ((RubyProc)this.traces.get(i2)).call(context, new IRubyObject[]{value2});
            }
            Object var5_4 = null;
            context.setWithinTrace(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            context.setWithinTrace(false);
            throw throwable;
        }
    }
}

