/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PKCS10CertificationRequestExt;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.x509store.X509Aux;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

public class PEMInputOutput {
    public static final String BEF = "-----";
    public static final String AFT = "-----";
    public static final String BEF_G = "-----BEGIN ";
    public static final String BEF_E = "-----END ";
    public static final String PEM_STRING_X509_OLD = "X509 CERTIFICATE";
    public static final String PEM_STRING_X509 = "CERTIFICATE";
    public static final String PEM_STRING_X509_PAIR = "CERTIFICATE PAIR";
    public static final String PEM_STRING_X509_TRUSTED = "TRUSTED CERTIFICATE";
    public static final String PEM_STRING_X509_REQ_OLD = "NEW CERTIFICATE REQUEST";
    public static final String PEM_STRING_X509_REQ = "CERTIFICATE REQUEST";
    public static final String PEM_STRING_X509_CRL = "X509 CRL";
    public static final String PEM_STRING_EVP_PKEY = "ANY PRIVATE KEY";
    public static final String PEM_STRING_PUBLIC = "PUBLIC KEY";
    public static final String PEM_STRING_RSA = "RSA PRIVATE KEY";
    public static final String PEM_STRING_RSA_PUBLIC = "RSA PUBLIC KEY";
    public static final String PEM_STRING_DSA = "DSA PRIVATE KEY";
    public static final String PEM_STRING_DSA_PUBLIC = "DSA PUBLIC KEY";
    public static final String PEM_STRING_PKCS7 = "PKCS7";
    public static final String PEM_STRING_PKCS8 = "ENCRYPTED PRIVATE KEY";
    public static final String PEM_STRING_PKCS8INF = "PRIVATE KEY";
    public static final String PEM_STRING_DHPARAMS = "DH PARAMETERS";
    public static final String PEM_STRING_SSL_SESSION = "SSL SESSION PARAMETERS";
    public static final String PEM_STRING_DSAPARAMS = "DSA PARAMETERS";
    public static final String PEM_STRING_ECDSA_PUBLIC = "ECDSA PUBLIC KEY";
    public static final String PEM_STRING_ECPARAMETERS = "EC PARAMETERS";
    public static final String PEM_STRING_ECPRIVATEKEY = "EC PRIVATE KEY";
    private static final Pattern DH_PARAM_PATTERN = Pattern.compile("(-----BEGIN DH PARAMETERS-----)(.*)(-----END DH PARAMETERS-----)", 8);
    private static final int DH_PARAM_GROUP = 2;
    private static SecureRandom random;

    private static BufferedReader makeBuffered(Reader in) {
        if (in instanceof BufferedReader) {
            return (BufferedReader)in;
        }
        return new BufferedReader(in);
    }

    private static BufferedWriter makeBuffered(Writer out) {
        if (out instanceof BufferedWriter) {
            return (BufferedWriter)out;
        }
        return new BufferedWriter(out);
    }

    public static Object readPEM(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                try {
                    return PEMInputOutput.readPublicKey(_in, "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN DSA PRIVATE KEY") != -1) {
                try {
                    return PEMInputOutput.readKeyPair(_in, f, "DSA", "-----END DSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating DSA private key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN RSA PUBLIC KEY") != -1) {
                try {
                    return PEMInputOutput.readPublicKey(_in, "-----END RSA PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(_in, "-----END X509 CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(_in, "-----END CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN TRUSTED CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(_in, "-----END TRUSTED CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN X509 CRL") != -1) {
                try {
                    return PEMInputOutput.readCRL(_in, "-----END X509 CRL");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 CRL: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE REQUEST") == -1) continue;
            try {
                return PEMInputOutput.readCertificateRequest(_in, "-----END CERTIFICATE REQUEST");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 REQ: " + e.toString());
            }
        }
        return null;
    }

    public static byte[] readX509PEM(Reader in) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readBytes(_in, "-----END X509 CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readBytes(_in, "-----END CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN TRUSTED CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readBytes(_in, "-----END TRUSTED CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN X509 CRL") != -1) {
                try {
                    return PEMInputOutput.readBytes(_in, "-----END X509 CRL");
                }
                catch (Exception e) {
                    throw new IOException("problem reading PEM X509 CRL: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE REQUEST") == -1) continue;
            try {
                return PEMInputOutput.readBytes(_in, "-----END CERTIFICATE REQUEST");
            }
            catch (Exception e) {
                throw new IOException("problem reading PEM X509 REQ: " + e.toString());
            }
        }
        return null;
    }

    public static KeyPair readPrivateKey(Reader in, char[] password) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN RSA PRIVATE KEY") != -1) {
                try {
                    return PEMInputOutput.readKeyPair(_in, password, "RSA", "-----END RSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA private key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN DSA PRIVATE KEY") != -1) {
                try {
                    return PEMInputOutput.readKeyPair(_in, password, "DSA", "-----END DSA PRIVATE KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating DSA private key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN EC PRIVATE KEY") != -1) {
                throw new IOException("EC private key not supported");
            }
            if (line.indexOf("-----BEGIN PRIVATE KEY") != -1) {
                try {
                    byte[] bytes2 = PEMInputOutput.readBytes(_in, "-----END PRIVATE KEY");
                    ByteArrayInputStream bIn = new ByteArrayInputStream(bytes2);
                    ASN1InputStream aIn = new ASN1InputStream(bIn);
                    PrivateKeyInfo info = new PrivateKeyInfo((ASN1Sequence)aIn.readObject());
                    String type2 = PEMInputOutput.getPrivateKeyTypeFromObjectId(info.getAlgorithmId().getObjectId());
                    return PEMInputOutput.readPrivateKeySequence(info.getPrivateKey().getDEREncoded(), type2);
                }
                catch (Exception e) {
                    throw new IOException("problem creating private key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN ENCRYPTED PRIVATE KEY") == -1) continue;
            try {
                byte[] bytes3 = PEMInputOutput.readBytes(_in, "-----END ENCRYPTED PRIVATE KEY");
                ByteArrayInputStream bIn = new ByteArrayInputStream(bytes3);
                ASN1InputStream aIn = new ASN1InputStream(bIn);
                EncryptedPrivateKeyInfo eIn = new EncryptedPrivateKeyInfo((ASN1Sequence)aIn.readObject());
                AlgorithmIdentifier algId = eIn.getEncryptionAlgorithm();
                String algorithm = ASN1Registry.o2a(algId.getObjectId());
                algorithm = algorithm.split("-")[0];
                PKCS12PBEParams pbeParams = new PKCS12PBEParams((ASN1Sequence)algId.getParameters());
                SecretKeyFactory fact = OpenSSLReal.getSecretKeyFactoryBC(algorithm);
                PBEKeySpec pbeSpec = new PBEKeySpec(password);
                SecretKey key2 = fact.generateSecret(pbeSpec);
                PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
                Cipher cipher2 = OpenSSLReal.getCipherBC(algorithm);
                cipher2.init(4, (Key)key2, defParams);
                PrivateKey privKey = (PrivateKey)cipher2.unwrap(eIn.getEncryptedData(), "", 2);
                return new KeyPair(null, privKey);
            }
            catch (Exception e) {
                throw new IOException("problem creating private key: " + e.toString());
            }
        }
        return null;
    }

    public static DSAPublicKey readDSAPubKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN DSA PUBLIC KEY") == -1) continue;
            try {
                return (DSAPublicKey)PEMInputOutput.readPublicKey(_in, "DSA", "-----END DSA PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating DSA public key: " + e.toString());
            }
        }
        return null;
    }

    public static DSAPublicKey readDSAPublicKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") == -1) continue;
            try {
                return (DSAPublicKey)PEMInputOutput.readPublicKey(_in, "DSA", "-----END PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating DSA public key: " + e.toString());
            }
        }
        return null;
    }

    public static KeyPair readDSAPrivateKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN DSA PRIVATE KEY") == -1) continue;
            try {
                return PEMInputOutput.readKeyPair(_in, f, "DSA", "-----END DSA PRIVATE KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating DSA private key: " + e.toString());
            }
        }
        return null;
    }

    public static RSAPublicKey readRSAPubKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                try {
                    return PEMInputOutput.readRSAPublicKey(_in, "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN RSA PUBLIC KEY") == -1) continue;
            try {
                return PEMInputOutput.readRSAPublicKey(_in, "-----END RSA PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA public key: " + e.toString());
            }
        }
        return null;
    }

    public static RSAPublicKey readRSAPublicKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                try {
                    return (RSAPublicKey)PEMInputOutput.readPublicKey(_in, "RSA", "-----END PUBLIC KEY");
                }
                catch (Exception e) {
                    throw new IOException("problem creating RSA public key: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN RSA PUBLIC KEY") == -1) continue;
            try {
                return (RSAPublicKey)PEMInputOutput.readPublicKey(_in, "RSA", "-----END RSA PUBLIC KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA public key: " + e.toString());
            }
        }
        return null;
    }

    public static KeyPair readRSAPrivateKey(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN RSA PRIVATE KEY") == -1) continue;
            try {
                return PEMInputOutput.readKeyPair(_in, f, "RSA", "-----END RSA PRIVATE KEY");
            }
            catch (Exception e) {
                throw new IOException("problem creating RSA private key: " + e.toString());
            }
        }
        return null;
    }

    public static CMSSignedData readPKCS7(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN PKCS7") == -1) continue;
            try {
                return PEMInputOutput.readPKCS7(_in, f, "-----END PKCS7");
            }
            catch (Exception e) {
                throw new IOException("problem creating PKCS7: " + e.toString());
            }
        }
        return null;
    }

    public static X509AuxCertificate readX509Certificate(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                try {
                    return new X509AuxCertificate(PEMInputOutput.readCertificate(_in, "-----END X509 CERTIFICATE"));
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                try {
                    return new X509AuxCertificate(PEMInputOutput.readCertificate(_in, "-----END CERTIFICATE"));
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN TRUSTED CERTIFICATE") == -1) continue;
            try {
                return new X509AuxCertificate(PEMInputOutput.readCertificate(_in, "-----END TRUSTED CERTIFICATE"));
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 certificate: " + e.toString());
            }
        }
        return null;
    }

    public static X509AuxCertificate readX509Aux(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(_in, "-----END X509 CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN CERTIFICATE") != -1) {
                try {
                    return PEMInputOutput.readAuxCertificate(_in, "-----END CERTIFICATE");
                }
                catch (Exception e) {
                    throw new IOException("problem creating X509 Aux certificate: " + e.toString());
                }
            }
            if (line.indexOf("-----BEGIN TRUSTED CERTIFICATE") == -1) continue;
            try {
                return PEMInputOutput.readAuxCertificate(_in, "-----END TRUSTED CERTIFICATE");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 Aux certificate: " + e.toString());
            }
        }
        return null;
    }

    public static X509CRL readX509CRL(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN X509 CRL") == -1) continue;
            try {
                return PEMInputOutput.readCRL(_in, "-----END X509 CRL");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 CRL: " + e.toString());
            }
        }
        return null;
    }

    public static PKCS10CertificationRequestExt readX509Request(Reader in, char[] f) throws IOException {
        String line;
        BufferedReader _in = PEMInputOutput.makeBuffered(in);
        while ((line = _in.readLine()) != null) {
            if (line.indexOf("-----BEGIN CERTIFICATE REQUEST") == -1) continue;
            try {
                return PEMInputOutput.readCertificateRequest(_in, "-----END CERTIFICATE REQUEST");
            }
            catch (Exception e) {
                throw new IOException("problem creating X509 REQ: " + e.toString());
            }
        }
        return null;
    }

    public static DHParameterSpec readDHParameters(Reader _in) throws IOException, InvalidParameterSpecException {
        Matcher m;
        String line;
        BufferedReader in = PEMInputOutput.makeBuffered(_in);
        StringBuilder buf = new StringBuilder();
        while ((line = in.readLine()) != null) {
            if (line.indexOf("-----BEGIN DH PARAMETERS") < 0) continue;
            do {
                buf.append(line.trim());
            } while (line.indexOf("-----END DH PARAMETERS") < 0 && (line = in.readLine()) != null);
        }
        if ((m = DH_PARAM_PATTERN.matcher(buf.toString())).find()) {
            try {
                byte[] decoded = Base64.decode(m.group(2));
                ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(decoded));
                ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
                BigInteger p2 = ((DERInteger)seq.getObjectAt(0)).getValue();
                BigInteger g = ((DERInteger)seq.getObjectAt(1)).getValue();
                return new DHParameterSpec(p2, g);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new InvalidParameterSpecException("invalid DH PARAMETERS");
    }

    private static byte[] getEncoded(Key key2) {
        if (key2 != null) {
            return key2.getEncoded();
        }
        return new byte[]{48, 0};
    }

    private static byte[] getEncoded(ASN1Encodable obj) throws IOException {
        if (obj != null) {
            return obj.getEncoded();
        }
        return new byte[]{48, 0};
    }

    private static byte[] getEncoded(CMSSignedData obj) throws IOException {
        if (obj != null) {
            return obj.getEncoded();
        }
        return new byte[]{48, 0};
    }

    private static byte[] getEncoded(X509Certificate cert2) throws IOException {
        if (cert2 != null) {
            try {
                return cert2.getEncoded();
            }
            catch (GeneralSecurityException gse) {
                throw new IOException("problem with encoding object in write_X509");
            }
        }
        return new byte[]{48, 0};
    }

    private static byte[] getEncoded(X509CRL crl) throws IOException {
        if (crl != null) {
            try {
                return crl.getEncoded();
            }
            catch (GeneralSecurityException gse) {
                throw new IOException("problem with encoding object in write_X509_CRL");
            }
        }
        return new byte[]{48, 0};
    }

    public static void writeDSAPublicKey(Writer _out, DSAPublicKey obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN DSA PUBLIC KEY-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END DSA PUBLIC KEY-----");
        out.newLine();
        out.flush();
    }

    public static void writeRSAPublicKey(Writer _out, RSAPublicKey obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN RSA PUBLIC KEY-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END RSA PUBLIC KEY-----");
        out.newLine();
        out.flush();
    }

    public static void writePKCS7(Writer _out, ContentInfo obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN PKCS7-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END PKCS7-----");
        out.newLine();
        out.flush();
    }

    public static void writePKCS7(Writer _out, CMSSignedData obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN PKCS7-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END PKCS7-----");
        out.newLine();
        out.flush();
    }

    public static void writePKCS7(Writer _out, byte[] encoded) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        out.write("-----BEGIN PKCS7-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoded);
        out.write("-----END PKCS7-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509Certificate(Writer _out, X509Certificate obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN CERTIFICATE-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END CERTIFICATE-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509Aux(Writer _out, X509AuxCertificate obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = null;
        try {
            if (obj.getAux() == null) {
                encoding2 = obj.getEncoded();
            } else {
                ASN1EncodableVector a2;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] ymp = obj.getEncoded();
                baos.write(ymp, 0, ymp.length);
                X509Aux aux = obj.getAux();
                ASN1EncodableVector a1 = new ASN1EncodableVector();
                if (aux.trust.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    for (String trust2 : aux.trust) {
                        a2.add(new DERObjectIdentifier(trust2));
                    }
                    a1.add(new DERSequence(a2));
                }
                if (aux.reject.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    for (String reject2 : aux.reject) {
                        a2.add(new DERObjectIdentifier(reject2));
                    }
                    a1.add(new DERTaggedObject(0, new DERSequence(a2)));
                }
                if (aux.alias != null) {
                    a1.add(new DERUTF8String(aux.alias));
                }
                if (aux.keyid != null) {
                    a1.add(new DEROctetString(aux.keyid));
                }
                if (aux.other.size() > 0) {
                    a2 = new ASN1EncodableVector();
                    for (DERObject other : aux.other) {
                        a2.add(other);
                    }
                    a1.add(new DERTaggedObject(1, new DERSequence(a2)));
                }
                ymp = new DERSequence(a1).getEncoded();
                baos.write(ymp, 0, ymp.length);
                encoding2 = baos.toByteArray();
            }
        }
        catch (CertificateEncodingException e) {
            throw new IOException("problem with encoding object in write_X509_AUX");
        }
        out.write("-----BEGIN TRUSTED CERTIFICATE-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END TRUSTED CERTIFICATE-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509CRL(Writer _out, X509CRL obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN X509 CRL-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END X509 CRL-----");
        out.newLine();
        out.flush();
    }

    public static void writeX509Request(Writer _out, PKCS10CertificationRequestExt obj) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        byte[] encoding2 = PEMInputOutput.getEncoded(obj);
        out.write("-----BEGIN CERTIFICATE REQUEST-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END CERTIFICATE REQUEST-----");
        out.newLine();
        out.flush();
    }

    public static void writeDSAPrivateKey(Writer _out, DSAPrivateKey obj, String algo, char[] f) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        ByteArrayInputStream bIn = new ByteArrayInputStream(PEMInputOutput.getEncoded(obj));
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        PrivateKeyInfo info = new PrivateKeyInfo((ASN1Sequence)aIn.readObject());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        DSAParameter p2 = DSAParameter.getInstance(info.getAlgorithmId().getParameters());
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(0));
        v.add(new DERInteger(p2.getP()));
        v.add(new DERInteger(p2.getQ()));
        v.add(new DERInteger(p2.getG()));
        BigInteger x = obj.getX();
        BigInteger y = p2.getG().modPow(x, p2.getP());
        v.add(new DERInteger(y));
        v.add(new DERInteger(x));
        aOut.writeObject(new DERSequence(v));
        byte[] encoding2 = bOut.toByteArray();
        if (algo != null && f != null) {
            byte[] salt = new byte[8];
            byte[] encData = null;
            random.nextBytes(salt);
            OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
            pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes(f), salt);
            SecretKeySpec secretKey = null;
            if (!algo.equalsIgnoreCase("DESede/CBC/PKCS5Padding")) {
                throw new IOException("unknown algorithm in write_DSAPrivateKey: " + algo);
            }
            int keyLength = 24;
            KeyParameter param = (KeyParameter)pGen.generateDerivedParameters(keyLength * 8);
            secretKey = new SecretKeySpec(param.getKey(), "DESede");
            try {
                Cipher c = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                c.init(1, (Key)secretKey, new IvParameterSpec(salt));
                encData = c.doFinal(encoding2);
            }
            catch (Exception e) {
                throw new IOException("exception using cipher: " + e.toString());
            }
            out.write("-----BEGIN DSA PRIVATE KEY-----");
            out.newLine();
            out.write("Proc-Type: 4,ENCRYPTED");
            out.newLine();
            out.write("DEK-Info: DES-EDE3-CBC,");
            PEMInputOutput.writeHexEncoded(out, salt);
            out.newLine();
            out.newLine();
            PEMInputOutput.writeEncoded(out, encData);
            out.write("-----END DSA PRIVATE KEY-----");
            out.flush();
        } else {
            out.write("-----BEGIN DSA PRIVATE KEY-----");
            out.newLine();
            PEMInputOutput.writeEncoded(out, encoding2);
            out.write("-----END DSA PRIVATE KEY-----");
            out.newLine();
            out.flush();
        }
    }

    public static void writeRSAPrivateKey(Writer _out, RSAPrivateCrtKey obj, String algo, char[] f) throws IOException {
        assert (obj != null);
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        RSAPrivateKeyStructure keyStruct = new RSAPrivateKeyStructure(obj.getModulus(), obj.getPublicExponent(), obj.getPrivateExponent(), obj.getPrimeP(), obj.getPrimeQ(), obj.getPrimeExponentP(), obj.getPrimeExponentQ(), obj.getCrtCoefficient());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(keyStruct);
        aOut.close();
        byte[] encoding2 = bOut.toByteArray();
        if (algo != null && f != null) {
            int keyLength;
            byte[] salt = new byte[8];
            byte[] encData = null;
            random.nextBytes(salt);
            OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
            pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes(f), salt);
            SecretKeySpec secretKey = null;
            if (algo.startsWith("DES")) {
                keyLength = 24;
                if (algo.equalsIgnoreCase("DESEDE")) {
                    algo = "DESede/CBC/PKCS5Padding";
                }
            } else {
                throw new IOException("unknown algorithm `" + algo + "' in write_DSAPrivateKey");
            }
            KeyParameter param = (KeyParameter)pGen.generateDerivedParameters(keyLength * 8);
            secretKey = new SecretKeySpec(param.getKey(), algo.split("/")[0]);
            try {
                Cipher c = Cipher.getInstance(algo);
                c.init(1, (Key)secretKey, new IvParameterSpec(salt));
                encData = c.doFinal(encoding2);
            }
            catch (Exception e) {
                throw new IOException("exception using cipher: " + e.toString());
            }
            out.write("-----BEGIN RSA PRIVATE KEY-----");
            out.newLine();
            out.write("Proc-Type: 4,ENCRYPTED");
            out.newLine();
            out.write("DEK-Info: DES-EDE3-CBC,");
            PEMInputOutput.writeHexEncoded(out, salt);
            out.newLine();
            out.newLine();
            PEMInputOutput.writeEncoded(out, encData);
            out.write("-----END RSA PRIVATE KEY-----");
            out.flush();
        } else {
            out.write("-----BEGIN RSA PRIVATE KEY-----");
            out.newLine();
            PEMInputOutput.writeEncoded(out, encoding2);
            out.write("-----END RSA PRIVATE KEY-----");
            out.newLine();
            out.flush();
        }
    }

    public static void writeDHParameters(Writer _out, DHParameterSpec params2) throws IOException {
        BufferedWriter out = PEMInputOutput.makeBuffered(_out);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        ASN1EncodableVector v = new ASN1EncodableVector();
        BigInteger value2 = params2.getP();
        if (value2 != null) {
            v.add(new DERInteger(value2));
        }
        if ((value2 = params2.getG()) != null) {
            v.add(new DERInteger(value2));
        }
        aOut.writeObject(new DERSequence(v));
        byte[] encoding2 = bOut.toByteArray();
        out.write("-----BEGIN DH PARAMETERS-----");
        out.newLine();
        PEMInputOutput.writeEncoded(out, encoding2);
        out.write("-----END DH PARAMETERS-----");
        out.newLine();
        out.flush();
    }

    private static String getPrivateKeyTypeFromObjectId(DERObjectIdentifier oid2) {
        if (ASN1Registry.obj2nid(oid2) == 6) {
            return "RSA";
        }
        return "DSA";
    }

    private static byte[] readBytes(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        return Base64.decode(buf.toString());
    }

    private static SecretKey getKey(char[] k1, String algorithm, int keyLength, byte[] salt) throws IOException {
        char[] password = k1;
        if (password == null) {
            throw new IOException("Password is null, but a password is required");
        }
        OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
        pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes(password), salt);
        KeyParameter param = (KeyParameter)pGen.generateDerivedParameters(keyLength * 8);
        return new SecretKeySpec(param.getKey(), algorithm);
    }

    private static RSAPublicKey readRSAPublicKey(BufferedReader in, String endMarker) throws IOException {
        ByteArrayInputStream bAIS = new ByteArrayInputStream(PEMInputOutput.readBytes(in, endMarker));
        ASN1InputStream ais = new ASN1InputStream(bAIS);
        DERObject asnObject = ais.readObject();
        ASN1Sequence sequence = (ASN1Sequence)asnObject;
        RSAPublicKeyStructure rsaPubStructure = new RSAPublicKeyStructure(sequence);
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(rsaPubStructure.getModulus(), rsaPubStructure.getPublicExponent());
        try {
            KeyFactory keyFact = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFact.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        return null;
    }

    private static PublicKey readPublicKey(BufferedReader in, String alg, String endMarker) throws IOException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(PEMInputOutput.readBytes(in, endMarker));
        try {
            KeyFactory keyFact = KeyFactory.getInstance(alg);
            PublicKey pubKey = keyFact.generatePublic(keySpec);
            return pubKey;
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        return null;
    }

    private static PublicKey readPublicKey(BufferedReader in, String endMarker) throws IOException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(PEMInputOutput.readBytes(in, endMarker));
        String[] algs = new String[]{"RSA", "DSA"};
        for (int i2 = 0; i2 < algs.length; ++i2) {
            try {
                KeyFactory keyFact = KeyFactory.getInstance(algs[i2]);
                PublicKey pubKey = keyFact.generatePublic(keySpec);
                return pubKey;
            }
            catch (NoSuchAlgorithmException e) {
                continue;
            }
            catch (InvalidKeySpecException e) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static KeyPair readKeyPair(BufferedReader _in, char[] passwd2, String type2, String endMarker) throws Exception {
        boolean isEncrypted = false;
        String line = null;
        String dekInfo = null;
        StringBuffer buf = new StringBuffer();
        while ((line = _in.readLine()) != null) {
            if (line.startsWith("Proc-Type: 4,ENCRYPTED")) {
                isEncrypted = true;
                continue;
            }
            if (line.startsWith("DEK-Info:")) {
                dekInfo = line.substring(10);
                continue;
            }
            if (line.indexOf(endMarker) != -1) break;
            buf.append(line.trim());
        }
        byte[] keyBytes = null;
        if (isEncrypted) {
            StringTokenizer tknz = new StringTokenizer(dekInfo, ",");
            String encoding2 = tknz.nextToken();
            if (encoding2.equals("DES-EDE3-CBC")) {
                String alg = "DESede";
                byte[] iv = Hex.decode(tknz.nextToken());
                SecretKey sKey = PEMInputOutput.getKey(passwd2, alg, 24, iv);
                Cipher c = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                c.init(2, (Key)sKey, new IvParameterSpec(iv));
                keyBytes = c.doFinal(Base64.decode(buf.toString()));
                return PEMInputOutput.readPrivateKeySequence(keyBytes, type2);
            } else {
                if (!encoding2.equals("DES-CBC")) throw new IOException("unknown encryption with private key");
                String alg = "DES";
                byte[] iv = Hex.decode(tknz.nextToken());
                SecretKey sKey = PEMInputOutput.getKey(passwd2, alg, 8, iv);
                Cipher c = Cipher.getInstance("DES/CBC/PKCS5Padding");
                c.init(2, (Key)sKey, new IvParameterSpec(iv));
                keyBytes = c.doFinal(Base64.decode(buf.toString()));
            }
            return PEMInputOutput.readPrivateKeySequence(keyBytes, type2);
        } else {
            keyBytes = Base64.decode(buf.toString());
        }
        return PEMInputOutput.readPrivateKeySequence(keyBytes, type2);
    }

    private static KeyPair readPrivateKeySequence(byte[] in, String type2) throws Exception {
        KeySpec pubSpec = null;
        KeySpec privSpec = null;
        ByteArrayInputStream bIn = new ByteArrayInputStream(in);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        if (type2.equals("RSA")) {
            DERInteger mod = (DERInteger)seq.getObjectAt(1);
            DERInteger pubExp = (DERInteger)seq.getObjectAt(2);
            DERInteger privExp = (DERInteger)seq.getObjectAt(3);
            DERInteger p1 = (DERInteger)seq.getObjectAt(4);
            DERInteger p2 = (DERInteger)seq.getObjectAt(5);
            DERInteger exp1 = (DERInteger)seq.getObjectAt(6);
            DERInteger exp2 = (DERInteger)seq.getObjectAt(7);
            DERInteger crtCoef = (DERInteger)seq.getObjectAt(8);
            pubSpec = new RSAPublicKeySpec(mod.getValue(), pubExp.getValue());
            privSpec = new RSAPrivateCrtKeySpec(mod.getValue(), pubExp.getValue(), privExp.getValue(), p1.getValue(), p2.getValue(), exp1.getValue(), exp2.getValue(), crtCoef.getValue());
        } else {
            DERInteger p2 = (DERInteger)seq.getObjectAt(1);
            DERInteger q = (DERInteger)seq.getObjectAt(2);
            DERInteger g = (DERInteger)seq.getObjectAt(3);
            DERInteger y = (DERInteger)seq.getObjectAt(4);
            DERInteger x = (DERInteger)seq.getObjectAt(5);
            privSpec = new DSAPrivateKeySpec(x.getValue(), p2.getValue(), q.getValue(), g.getValue());
            pubSpec = new DSAPublicKeySpec(y.getValue(), p2.getValue(), q.getValue(), g.getValue());
        }
        KeyFactory fact = KeyFactory.getInstance(type2);
        return new KeyPair(fact.generatePublic(pubSpec), fact.generatePrivate(privSpec));
    }

    private static X509Certificate readCertificate(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode(buf.toString()));
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certFact.generateCertificate(bIn);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static X509AuxCertificate readAuxCertificate(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        ASN1InputStream try1 = new ASN1InputStream(Base64.decode(buf.toString()));
        ByteArrayInputStream bIn = new ByteArrayInputStream(try1.readObject().getEncoded());
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            X509Certificate bCert = (X509Certificate)certFact.generateCertificate(bIn);
            DERSequence aux = (DERSequence)try1.readObject();
            X509Aux ax = null;
            if (aux != null) {
                int i2;
                ax = new X509Aux();
                int ix = 0;
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DERSequence) {
                    DERSequence trust2 = (DERSequence)aux.getObjectAt(ix++);
                    for (i2 = 0; i2 < trust2.size(); ++i2) {
                        ax.trust.add(((DERObjectIdentifier)trust2.getObjectAt(i2)).getId());
                    }
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DERTaggedObject && ((DERTaggedObject)aux.getObjectAt(ix)).getTagNo() == 0) {
                    DERSequence reject2 = (DERSequence)((DERTaggedObject)aux.getObjectAt(ix++)).getObject();
                    for (i2 = 0; i2 < reject2.size(); ++i2) {
                        ax.reject.add(((DERObjectIdentifier)reject2.getObjectAt(i2)).getId());
                    }
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DERUTF8String) {
                    ax.alias = ((DERUTF8String)aux.getObjectAt(ix++)).getString();
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DEROctetString) {
                    ax.keyid = ((DEROctetString)aux.getObjectAt(ix++)).getOctets();
                }
                if (aux.size() > ix && aux.getObjectAt(ix) instanceof DERTaggedObject && ((DERTaggedObject)aux.getObjectAt(ix)).getTagNo() == 1) {
                    DERSequence other = (DERSequence)((DERTaggedObject)aux.getObjectAt(ix++)).getObject();
                    for (i2 = 0; i2 < other.size(); ++i2) {
                        ax.other.add((DERObject)other.getObjectAt(i2));
                    }
                }
            }
            return new X509AuxCertificate(bCert, ax);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static X509CRL readCRL(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode(buf.toString()));
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            return (X509CRL)certFact.generateCRL(bIn);
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static PKCS10CertificationRequestExt readCertificateRequest(BufferedReader in, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        try {
            return new PKCS10CertificationRequestExt(Base64.decode(buf.toString()));
        }
        catch (Exception e) {
            throw new IOException("problem parsing cert: " + e.toString());
        }
    }

    private static void writeHexEncoded(BufferedWriter out, byte[] bytes2) throws IOException {
        bytes2 = Hex.encode(bytes2);
        for (int i2 = 0; i2 != bytes2.length; ++i2) {
            out.write((char)bytes2[i2]);
        }
    }

    private static void writeEncoded(BufferedWriter out, byte[] bytes2) throws IOException {
        char[] buf = new char[64];
        bytes2 = Base64.encode(bytes2);
        for (int i2 = 0; i2 < bytes2.length; i2 += buf.length) {
            int index2;
            for (index2 = 0; index2 != buf.length && i2 + index2 < bytes2.length; ++index2) {
                buf[index2] = (char)bytes2[i2 + index2];
            }
            out.write(buf, 0, index2);
            out.newLine();
        }
    }

    private static CMSSignedData readPKCS7(BufferedReader in, char[] p2, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        while ((line = in.readLine()) != null && line.indexOf(endMarker) == -1) {
            line = line.trim();
            buf.append(line.trim());
            Base64.decode(buf.substring(0, buf.length() / 4 * 4), bOut);
            buf.delete(0, buf.length() / 4 * 4);
        }
        if (buf.length() != 0) {
            throw new RuntimeException("base64 data appears to be truncated");
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
        try {
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            return new CMSSignedData(ContentInfo.getInstance(aIn.readObject()));
        }
        catch (Exception e) {
            throw new IOException("problem parsing PKCS7 object: " + e.toString());
        }
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            random = null;
        }
    }
}

