/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;

public class PKey {
    public static PrivateKey readRSAPrivateKey(byte[] input) throws IOException, GeneralSecurityException {
        KeyFactory fact = KeyFactory.getInstance("RSA");
        DERSequence seq = (DERSequence)new ASN1InputStream(input).readObject();
        if (seq.size() == 9) {
            BigInteger mod = ((DERInteger)seq.getObjectAt(1)).getValue();
            BigInteger pubexp = ((DERInteger)seq.getObjectAt(2)).getValue();
            BigInteger privexp = ((DERInteger)seq.getObjectAt(3)).getValue();
            BigInteger primep = ((DERInteger)seq.getObjectAt(4)).getValue();
            BigInteger primeq = ((DERInteger)seq.getObjectAt(5)).getValue();
            BigInteger primeep = ((DERInteger)seq.getObjectAt(6)).getValue();
            BigInteger primeeq = ((DERInteger)seq.getObjectAt(7)).getValue();
            BigInteger crtcoeff = ((DERInteger)seq.getObjectAt(8)).getValue();
            return fact.generatePrivate(new RSAPrivateCrtKeySpec(mod, pubexp, privexp, primep, primeq, primeep, primeeq, crtcoeff));
        }
        return null;
    }

    public static PublicKey readRSAPublicKey(byte[] input) throws IOException, GeneralSecurityException {
        KeyFactory fact = KeyFactory.getInstance("RSA");
        DERSequence seq = (DERSequence)new ASN1InputStream(input).readObject();
        if (seq.size() == 2) {
            BigInteger mod = ((DERInteger)seq.getObjectAt(0)).getValue();
            BigInteger pubexp = ((DERInteger)seq.getObjectAt(1)).getValue();
            return fact.generatePublic(new RSAPublicKeySpec(mod, pubexp));
        }
        return null;
    }

    public static KeyPair readDSAPrivateKey(byte[] input) throws IOException, GeneralSecurityException {
        KeyFactory fact = KeyFactory.getInstance("DSA");
        DERSequence seq = (DERSequence)new ASN1InputStream(input).readObject();
        if (seq.size() == 6) {
            BigInteger p2 = ((DERInteger)seq.getObjectAt(1)).getValue();
            BigInteger q = ((DERInteger)seq.getObjectAt(2)).getValue();
            BigInteger g = ((DERInteger)seq.getObjectAt(3)).getValue();
            BigInteger y = ((DERInteger)seq.getObjectAt(4)).getValue();
            BigInteger x = ((DERInteger)seq.getObjectAt(5)).getValue();
            PrivateKey priv = fact.generatePrivate(new DSAPrivateKeySpec(x, p2, q, g));
            PublicKey pub = fact.generatePublic(new DSAPublicKeySpec(y, p2, q, g));
            return new KeyPair(pub, priv);
        }
        return null;
    }

    public static PublicKey readDSAPublicKey(byte[] input) throws IOException, GeneralSecurityException {
        KeyFactory fact = KeyFactory.getInstance("RSA");
        DERSequence seq = (DERSequence)new ASN1InputStream(input).readObject();
        if (seq.size() == 4) {
            BigInteger y = ((DERInteger)seq.getObjectAt(0)).getValue();
            BigInteger p2 = ((DERInteger)seq.getObjectAt(1)).getValue();
            BigInteger q = ((DERInteger)seq.getObjectAt(2)).getValue();
            BigInteger g = ((DERInteger)seq.getObjectAt(3)).getValue();
            return fact.generatePublic(new DSAPublicKeySpec(y, p2, q, g));
        }
        return null;
    }

    public static byte[] toDerRSAKey(RSAPublicKey pubKey, RSAPrivateCrtKey privKey) throws IOException {
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        if (pubKey != null && privKey == null) {
            v1.add(new DERInteger(pubKey.getModulus()));
            v1.add(new DERInteger(pubKey.getPublicExponent()));
        } else {
            v1.add(new DERInteger(0));
            v1.add(new DERInteger(privKey.getModulus()));
            v1.add(new DERInteger(privKey.getPublicExponent()));
            v1.add(new DERInteger(privKey.getPrivateExponent()));
            v1.add(new DERInteger(privKey.getPrimeP()));
            v1.add(new DERInteger(privKey.getPrimeQ()));
            v1.add(new DERInteger(privKey.getPrimeExponentP()));
            v1.add(new DERInteger(privKey.getPrimeExponentQ()));
            v1.add(new DERInteger(privKey.getCrtCoefficient()));
        }
        return new DERSequence(v1).getEncoded();
    }

    public static byte[] toDerDSAKey(DSAPublicKey pubKey, DSAPrivateKey privKey) throws IOException {
        if (pubKey != null && privKey == null) {
            return pubKey.getEncoded();
        }
        if (privKey != null && pubKey != null) {
            DSAParams params2 = privKey.getParams();
            ASN1EncodableVector v1 = new ASN1EncodableVector();
            v1.add(new DERInteger(0));
            v1.add(new DERInteger(params2.getP()));
            v1.add(new DERInteger(params2.getQ()));
            v1.add(new DERInteger(params2.getG()));
            v1.add(new DERInteger(pubKey.getY()));
            v1.add(new DERInteger(privKey.getX()));
            return new DERSequence(v1).getEncoded();
        }
        return privKey.getEncoded();
    }

    public static byte[] toDerDHKey(BigInteger p2, BigInteger g) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (p2 != null) {
            v.add(new DERInteger(p2));
        }
        if (g != null) {
            v.add(new DERInteger(g));
        }
        return new DERSequence(v).getEncoded();
    }
}

