/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.SimpleSecretKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Cipher
extends RubyObject {
    private static final long serialVersionUID = 7727377435222646536L;
    private static final boolean DEBUG = false;
    private static ObjectAllocator CIPHER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Cipher(runtime, klass);
        }
    };
    private javax.crypto.Cipher ciph;
    private String name;
    private String cryptoBase;
    private String cryptoVersion;
    private String cryptoMode;
    private String padding_type;
    private String realName;
    private int keyLen = -1;
    private int generateKeyLen = -1;
    private int ivLen = -1;
    private boolean encryptMode = true;
    private boolean ciphInited = false;
    private byte[] key;
    private byte[] realIV;
    private byte[] orgIV;
    private String padding;
    private byte[] lastIv = null;

    public static void createCipher(Ruby runtime, RubyModule mOSSL) {
        RubyClass cCipher = mOSSL.defineClassUnder("Cipher", runtime.getObject(), CIPHER_ALLOCATOR);
        cCipher.defineAnnotatedMethods(Cipher.class);
        cCipher.defineAnnotatedMethods(CipherModule.class);
        RubyClass openSSLError = mOSSL.getClass("OpenSSLError");
        cCipher.defineClassUnder("CipherError", openSSLError, openSSLError.getAllocator());
    }

    private static boolean tryCipher(String rubyName) {
        String cryptoMode = Algorithm.osslToJsse(rubyName, null)[3];
        try {
            javax.crypto.Cipher.getInstance(cryptoMode);
            return true;
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                OpenSSLReal.getCipherBC(cryptoMode);
                return true;
            }
            catch (GeneralSecurityException gse) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public Cipher(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    void dumpVars() {
        System.out.println("***** Cipher instance vars ****");
        System.out.println("name = " + this.name);
        System.out.println("cryptoBase = " + this.cryptoBase);
        System.out.println("cryptoVersion = " + this.cryptoVersion);
        System.out.println("cryptoMode = " + this.cryptoMode);
        System.out.println("padding_type = " + this.padding_type);
        System.out.println("realName = " + this.realName);
        System.out.println("keyLen = " + this.keyLen);
        System.out.println("ivLen = " + this.ivLen);
        System.out.println("ciph block size = " + this.ciph.getBlockSize());
        System.out.println("encryptMode = " + this.encryptMode);
        System.out.println("ciphInited = " + this.ciphInited);
        System.out.println("key.length = " + (this.key == null ? 0 : this.key.length));
        System.out.println("iv.length = " + (this.realIV == null ? 0 : this.realIV.length));
        System.out.println("padding = " + this.padding);
        System.out.println("ciphAlgo = " + this.ciph.getAlgorithm());
        System.out.println("*******************************");
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize(IRubyObject str) {
        this.name = str.toString();
        if (!CipherModule.isSupportedCipher(this.name)) {
            throw Cipher.newCipherError(this.getRuntime(), String.format("unsupported cipher algorithm (%s)", this.name));
        }
        String[] values2 = Algorithm.osslToJsse(this.name, this.padding);
        this.cryptoBase = values2[0];
        this.cryptoVersion = values2[1];
        this.cryptoMode = values2[2];
        this.realName = values2[3];
        this.padding_type = values2[4];
        this.ciph = this.getCipher();
        if (Cipher.hasLen(this.cryptoBase) && null != this.cryptoVersion) {
            try {
                this.keyLen = Integer.parseInt(this.cryptoVersion) / 8;
            }
            catch (NumberFormatException e) {
                this.keyLen = -1;
            }
        }
        if (this.keyLen == -1) {
            if ("DES".equalsIgnoreCase(this.cryptoBase)) {
                this.ivLen = 8;
                this.keyLen = "EDE3".equalsIgnoreCase(this.cryptoVersion) ? 24 : 8;
                this.generateKeyLen = this.keyLen / 8 * 7;
            } else if ("RC4".equalsIgnoreCase(this.cryptoBase)) {
                this.ivLen = 0;
                this.keyLen = 16;
            } else {
                this.keyLen = 16;
                try {
                    if (javax.crypto.Cipher.getMaxAllowedKeyLength(this.name) / 8 < this.keyLen) {
                        this.keyLen = javax.crypto.Cipher.getMaxAllowedKeyLength(this.name) / 8;
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        if (this.ivLen == -1) {
            this.ivLen = "AES".equalsIgnoreCase(this.cryptoBase) ? 16 : 8;
        }
        this.name = this.name.toUpperCase();
        return this;
    }

    @JRubyMethod(required=1)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.cryptoBase = ((Cipher)obj).cryptoBase;
        this.cryptoVersion = ((Cipher)obj).cryptoVersion;
        this.cryptoMode = ((Cipher)obj).cryptoMode;
        this.padding_type = ((Cipher)obj).padding_type;
        this.realName = ((Cipher)obj).realName;
        this.name = ((Cipher)obj).name;
        this.keyLen = ((Cipher)obj).keyLen;
        this.ivLen = ((Cipher)obj).ivLen;
        this.encryptMode = ((Cipher)obj).encryptMode;
        this.ciphInited = false;
        if (((Cipher)obj).key != null) {
            this.key = new byte[((Cipher)obj).key.length];
            System.arraycopy(((Cipher)obj).key, 0, this.key, 0, this.key.length);
        } else {
            this.key = null;
        }
        if (((Cipher)obj).realIV != null) {
            this.realIV = new byte[((Cipher)obj).realIV.length];
            System.arraycopy(((Cipher)obj).realIV, 0, this.realIV, 0, this.realIV.length);
        } else {
            this.realIV = null;
        }
        this.orgIV = this.realIV;
        this.padding = ((Cipher)obj).padding;
        this.ciph = this.getCipher();
        return this;
    }

    @JRubyMethod
    public IRubyObject name() {
        return this.getRuntime().newString(this.name);
    }

    @JRubyMethod
    public IRubyObject key_len() {
        return this.getRuntime().newFixnum(this.keyLen);
    }

    @JRubyMethod
    public IRubyObject iv_len() {
        return this.getRuntime().newFixnum(this.ivLen);
    }

    @JRubyMethod(name={"key_len="}, required=1)
    public IRubyObject set_key_len(IRubyObject len) {
        this.keyLen = RubyNumeric.fix2int(len);
        return len;
    }

    @JRubyMethod(name={"key="}, required=1)
    public IRubyObject set_key(IRubyObject key2) {
        byte[] keyBytes;
        try {
            keyBytes = key2.convertToString().getBytes();
        }
        catch (Exception e) {
            throw Cipher.newCipherError(this.getRuntime(), e.getMessage());
        }
        if (keyBytes.length < this.keyLen) {
            throw Cipher.newCipherError(this.getRuntime(), "key length to short");
        }
        if (keyBytes.length > this.keyLen) {
            byte[] keys2 = new byte[this.keyLen];
            System.arraycopy(keyBytes, 0, keys2, 0, this.keyLen);
            keyBytes = keys2;
        }
        this.key = keyBytes;
        return key2;
    }

    @JRubyMethod(name={"iv="}, required=1)
    public IRubyObject set_iv(IRubyObject iv) {
        byte[] ivBytes;
        try {
            ivBytes = iv.convertToString().getBytes();
        }
        catch (Exception e) {
            throw Cipher.newCipherError(this.getRuntime(), e.getMessage());
        }
        if (ivBytes.length < this.ivLen) {
            throw Cipher.newCipherError(this.getRuntime(), "iv length to short");
        }
        byte[] iv2 = new byte[this.ivLen];
        System.arraycopy(ivBytes, 0, iv2, 0, this.ivLen);
        this.realIV = iv2;
        this.orgIV = this.realIV;
        if (!this.isStreamCipher()) {
            this.ciphInited = false;
        }
        return iv;
    }

    @JRubyMethod
    public IRubyObject block_size() {
        if (this.isStreamCipher()) {
            return this.getRuntime().newFixnum(1);
        }
        return this.getRuntime().newFixnum(this.ciph.getBlockSize());
    }

    protected void init(IRubyObject[] args2, boolean encrypt2) {
        Arity.checkArgumentCount(this.getRuntime(), args2, 0, 2);
        this.encryptMode = encrypt2;
        this.ciphInited = false;
        if (args2.length > 0) {
            byte[] iv2;
            byte[] pass2 = args2[0].convertToString().getBytes();
            byte[] iv = null;
            try {
                iv = "OpenSSL for Ruby rulez!".getBytes("ISO8859-1");
                iv2 = new byte[this.ivLen];
                System.arraycopy(iv, 0, iv2, 0, this.ivLen);
                iv = iv2;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (args2.length > 1 && !args2[1].isNil()) {
                this.getRuntime().getWarnings().warning(IRubyWarnings.ID.MISCELLANEOUS, "key derivation by " + this.getMetaClass().getRealClass().getName() + "#encrypt is deprecated; use " + this.getMetaClass().getRealClass().getName() + "::pkcs5_keyivgen instead");
                iv = args2[1].convertToString().getBytes();
                if (iv.length > this.ivLen) {
                    iv2 = new byte[this.ivLen];
                    System.arraycopy(iv, 0, iv2, 0, this.ivLen);
                    iv = iv2;
                }
            }
            MessageDigest digest2 = Digest.getDigest("MD5", this.getRuntime());
            OpenSSLImpl.KeyAndIv result2 = OpenSSLImpl.EVP_BytesToKey(this.keyLen, this.ivLen, digest2, iv, pass2, 2048);
            this.key = result2.getKey();
            this.realIV = iv;
            this.orgIV = this.realIV;
        }
    }

    @JRubyMethod(optional=2)
    public IRubyObject encrypt(IRubyObject[] args2) {
        this.realIV = this.orgIV;
        this.init(args2, true);
        return this;
    }

    @JRubyMethod(optional=2)
    public IRubyObject decrypt(IRubyObject[] args2) {
        this.realIV = this.orgIV;
        this.init(args2, false);
        return this;
    }

    @JRubyMethod
    public IRubyObject reset() {
        if (!this.isStreamCipher()) {
            this.realIV = this.orgIV;
            this.doInitialize();
        }
        return this;
    }

    javax.crypto.Cipher getCipher() {
        try {
            return javax.crypto.Cipher.getInstance(this.realName);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                return OpenSSLReal.getCipherBC(this.realName);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw Cipher.newCipherError(this.getRuntime(), "unsupported cipher algorithm (" + this.realName + ")");
            }
        }
        catch (NoSuchPaddingException e) {
            throw Cipher.newCipherError(this.getRuntime(), "unsupported cipher padding (" + this.realName + ")");
        }
    }

    private static boolean hasLen(String cryptoBase) {
        return "AES".equalsIgnoreCase(cryptoBase) || "RC2".equalsIgnoreCase(cryptoBase) || "RC4".equalsIgnoreCase(cryptoBase);
    }

    @JRubyMethod(required=1, optional=3)
    public IRubyObject pkcs5_keyivgen(IRubyObject[] args2) {
        Arity.checkArgumentCount(this.getRuntime(), args2, 1, 4);
        byte[] pass2 = args2[0].convertToString().getBytes();
        byte[] salt = null;
        int iter = 2048;
        IRubyObject vdigest = this.getRuntime().getNil();
        if (args2.length > 1) {
            if (!args2[1].isNil()) {
                salt = args2[1].convertToString().getBytes();
            }
            if (args2.length > 2) {
                if (!args2[2].isNil()) {
                    iter = RubyNumeric.fix2int(args2[2]);
                }
                if (args2.length > 3) {
                    vdigest = args2[3];
                }
            }
        }
        if (null != salt && salt.length != 8) {
            throw Cipher.newCipherError(this.getRuntime(), "salt must be an 8-octet string");
        }
        String algorithm = vdigest.isNil() ? "MD5" : ((Digest)vdigest).getAlgorithm();
        MessageDigest digest2 = Digest.getDigest(algorithm, this.getRuntime());
        OpenSSLImpl.KeyAndIv result2 = OpenSSLImpl.EVP_BytesToKey(this.keyLen, this.ivLen, digest2, salt, pass2, iter);
        this.key = result2.getKey();
        this.realIV = result2.getIv();
        this.orgIV = this.realIV;
        this.doInitialize();
        return this.getRuntime().getNil();
    }

    private void doInitialize() {
        this.ciphInited = true;
        try {
            assert (this.key.length * 8 == this.keyLen || this.key.length == this.keyLen) : "Key wrong length";
            assert (this.realIV.length * 8 == this.ivLen || this.realIV.length == this.ivLen) : "IV wrong length";
            if (!"ECB".equalsIgnoreCase(this.cryptoMode)) {
                if (this.realIV == null) {
                    this.realIV = new byte[this.ivLen];
                    System.arraycopy("OpenSSL for JRuby rulez".getBytes(), 0, this.realIV, 0, this.ivLen);
                }
                if ("RC2".equalsIgnoreCase(this.cryptoBase)) {
                    this.ciph.init(this.encryptMode ? 1 : 2, (Key)new SimpleSecretKey("RC2", this.key), new RC2ParameterSpec(this.key.length * 8, this.realIV));
                } else if ("RC4".equalsIgnoreCase(this.cryptoBase)) {
                    this.ciph.init(this.encryptMode ? 1 : 2, new SimpleSecretKey("RC4", this.key));
                } else {
                    this.ciph.init(this.encryptMode ? 1 : 2, (Key)new SimpleSecretKey(this.realName.split("/")[0], this.key), new IvParameterSpec(this.realIV));
                }
            } else {
                this.ciph.init(this.encryptMode ? 1 : 2, new SimpleSecretKey(this.realName.split("/")[0], this.key));
            }
        }
        catch (Exception e) {
            throw Cipher.newCipherError(this.getRuntime(), e.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject update(IRubyObject data2) {
        byte[] val = data2.convertToString().getBytes();
        if (val.length == 0) {
            throw this.getRuntime().newArgumentError("data must not be empty");
        }
        if (!this.ciphInited) {
            this.doInitialize();
        }
        byte[] str = new byte[]{};
        try {
            byte[] out = this.ciph.update(val);
            if (out != null) {
                str = out;
                if (this.realIV != null) {
                    byte[] tmpIv;
                    if (this.lastIv == null) {
                        this.lastIv = new byte[this.ivLen];
                    }
                    byte[] byArray = tmpIv = this.encryptMode ? out : val;
                    if (tmpIv.length >= this.ivLen) {
                        System.arraycopy(tmpIv, tmpIv.length - this.ivLen, this.lastIv, 0, this.ivLen);
                    }
                }
            }
        }
        catch (Exception e) {
            throw Cipher.newCipherError(this.getRuntime(), e.getMessage());
        }
        return this.getRuntime().newString(new ByteList(str, false));
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject update_deprecated(IRubyObject data2) {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "" + this.getMetaClass().getRealClass().getName() + "#<< is deprecated; use " + this.getMetaClass().getRealClass().getName() + "#update instead");
        return this.update(data2);
    }

    @JRubyMethod(name={"final"})
    public IRubyObject _final() {
        if (!this.ciphInited) {
            this.doInitialize();
        }
        if ("RC4".equalsIgnoreCase(this.cryptoBase)) {
            return this.getRuntime().newString("");
        }
        ByteList str = new ByteList(ByteList.NULL_ARRAY);
        try {
            byte[] out = this.ciph.doFinal();
            if (out != null) {
                str = new ByteList(out, false);
                if (this.realIV != null) {
                    byte[] tmpIv;
                    if (this.lastIv == null) {
                        this.lastIv = new byte[this.ivLen];
                    }
                    if ((tmpIv = out).length >= this.ivLen) {
                        System.arraycopy(tmpIv, tmpIv.length - this.ivLen, this.lastIv, 0, this.ivLen);
                    }
                }
            }
            if (this.realIV != null) {
                this.realIV = this.lastIv;
                this.doInitialize();
            }
        }
        catch (Exception e) {
            throw Cipher.newCipherError(this.getRuntime(), e.getMessage());
        }
        return this.getRuntime().newString(str);
    }

    @JRubyMethod(name={"padding="})
    public IRubyObject set_padding(IRubyObject padding) {
        this.padding = padding.toString();
        this.initialize(this.getRuntime().newString(this.name));
        return padding;
    }

    String getAlgorithm() {
        return this.ciph.getAlgorithm();
    }

    String getName() {
        return this.name;
    }

    String getCryptoBase() {
        return this.cryptoBase;
    }

    String getCryptoMode() {
        return this.cryptoMode;
    }

    int getGenerateKeyLen() {
        return this.generateKeyLen == -1 ? this.keyLen : this.generateKeyLen;
    }

    private boolean isStreamCipher() {
        return this.ciph.getBlockSize() == 0;
    }

    private static RaiseException newCipherError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::Cipher::CipherError", message2);
    }

    public static class Algorithm {
        private static final Set<String> BLOCK_MODES = new HashSet<String>();

        public static String jsseToOssl(String inName, int keyLen) {
            String cryptoBase = null;
            String cryptoVersion = null;
            String cryptoMode = null;
            String[] parts = inName.split("/");
            if (parts.length != 1 && parts.length != 3) {
                return null;
            }
            cryptoBase = parts[0];
            if (parts.length > 2) {
                cryptoMode = parts[1];
            }
            if (!BLOCK_MODES.contains(cryptoMode)) {
                cryptoVersion = cryptoMode;
                cryptoMode = "CBC";
            }
            if (cryptoMode == null) {
                cryptoMode = "CBC";
            }
            if (cryptoBase.equals("DESede")) {
                cryptoBase = "DES";
                cryptoVersion = "EDE3";
            } else if (cryptoBase.equals("Blowfish")) {
                cryptoBase = "BF";
            }
            if (cryptoVersion == null) {
                cryptoVersion = String.valueOf(keyLen);
            }
            return cryptoBase + "-" + cryptoVersion + "-" + cryptoMode;
        }

        public static String[] osslToJsse(String inName) {
            return Algorithm.osslToJsse(inName, null);
        }

        public static String[] osslToJsse(String inName, String padding) {
            String[] split2 = inName.split("-");
            String cryptoBase = split2[0];
            String cryptoVersion = null;
            String cryptoMode = null;
            String realName = null;
            String paddingType = padding == null || padding.equalsIgnoreCase("PKCS5Padding") ? "PKCS5Padding" : (padding.equals("0") || padding.equalsIgnoreCase("NoPadding") ? "NoPadding" : (padding.equalsIgnoreCase("ISO10126Padding") ? "ISO10126Padding" : "PKCS5Padding"));
            if ("bf".equalsIgnoreCase(cryptoBase)) {
                cryptoBase = "Blowfish";
            }
            if (split2.length == 3) {
                cryptoVersion = split2[1];
                cryptoMode = split2[2];
            } else {
                cryptoMode = split2.length == 2 ? split2[1] : "CBC";
            }
            realName = cryptoBase.equalsIgnoreCase("CAST") ? "CAST5" : (cryptoBase.equalsIgnoreCase("DES") && "EDE3".equalsIgnoreCase(cryptoVersion) ? "DESede" : cryptoBase);
            if (!BLOCK_MODES.contains(cryptoMode.toUpperCase())) {
                cryptoVersion = cryptoMode;
                cryptoMode = "CBC";
            } else if (cryptoMode.equalsIgnoreCase("CFB1")) {
                cryptoMode = "CFB";
            }
            if (realName.equalsIgnoreCase("RC4")) {
                realName = "RC4";
                cryptoMode = "NONE";
                paddingType = "NoPadding";
            } else {
                realName = realName + "/" + cryptoMode + "/" + paddingType;
            }
            return new String[]{cryptoBase, cryptoVersion, cryptoMode, realName, paddingType};
        }

        static {
            BLOCK_MODES.add("CBC");
            BLOCK_MODES.add("CFB");
            BLOCK_MODES.add("CFB1");
            BLOCK_MODES.add("CFB8");
            BLOCK_MODES.add("ECB");
            BLOCK_MODES.add("OFB");
        }
    }

    @JRubyModule(name={"OpenSSL::Cipher"})
    public static class CipherModule {
        private static boolean initialized = false;
        private static final List<String> CIPHERS = new ArrayList<String>();

        @JRubyMethod(meta=true)
        public static IRubyObject ciphers(IRubyObject recv2) {
            CipherModule.initializeCiphers();
            ArrayList<IRubyObject> result2 = new ArrayList<IRubyObject>();
            for (String cipher2 : CIPHERS) {
                result2.add(recv2.getRuntime().newString(cipher2));
                result2.add(recv2.getRuntime().newString(cipher2.toLowerCase()));
            }
            return recv2.getRuntime().newArray(result2);
        }

        static boolean isSupportedCipher(String name2) {
            CipherModule.initializeCiphers();
            return CIPHERS.indexOf(name2.toUpperCase()) != -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void initializeCiphers() {
            List<String> list2 = CIPHERS;
            synchronized (list2) {
                int i2;
                if (initialized) {
                    return;
                }
                String[] other = new String[]{"AES128", "AES192", "AES256", "BLOWFISH", "RC2-40-CBC", "RC2-64-CBC", "RC4", "RC4-40", "CAST", "CAST-CBC"};
                String[] bases = new String[]{"AES-128", "AES-192", "AES-256", "BF", "DES", "DES-EDE", "DES-EDE3", "RC2", "CAST5"};
                String[] suffixes = new String[]{"", "-CBC", "-CFB", "-CFB1", "-CFB8", "-ECB", "-OFB"};
                int j = bases.length;
                for (i2 = 0; i2 < j; ++i2) {
                    int l = suffixes.length;
                    for (int k = 0; k < l; ++k) {
                        String val = bases[i2] + suffixes[k];
                        if (!Cipher.tryCipher(val)) continue;
                        CIPHERS.add(val.toUpperCase());
                    }
                }
                j = other.length;
                for (i2 = 0; i2 < j; ++i2) {
                    if (!Cipher.tryCipher(other[i2])) continue;
                    CIPHERS.add(other[i2].toUpperCase());
                }
                initialized = true;
            }
        }
    }
}

