/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.net.protocol;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.SelectorFactory;
import org.jruby.util.io.Stream;

@JRubyClass(name={"Net::BufferedIO"})
public class NetProtocolBufferedIO {
    public static void create(Ruby runtime) {
        RubyModule mNet = runtime.getModule("Net");
        RubyClass cBufferedIO = (RubyClass)mNet.getConstant("BufferedIO");
        cBufferedIO.defineAnnotatedMethods(NetProtocolBufferedIO.class);
        RubyModule mNativeImpl = cBufferedIO.defineModuleUnder("NativeImplementation");
        mNativeImpl.defineAnnotatedMethods(NativeImpl.class);
    }

    @JRubyMethod(required=1)
    public static IRubyObject initialize(IRubyObject recv2, IRubyObject io2) {
        try {
            ChannelStream cStream;
            RubyIO rubyIO;
            OpenFile of;
            Stream stream;
            if (io2 instanceof RubyIO && (stream = (of = (rubyIO = (RubyIO)io2).getOpenFile()).getMainStreamSafe()) instanceof ChannelStream && (cStream = (ChannelStream)stream).getDescriptor().getChannel() instanceof SelectableChannel) {
                SelectableChannel selChannel = (SelectableChannel)cStream.getDescriptor().getChannel();
                ((RubyObject)recv2).extend(new IRubyObject[]{((RubyModule)recv2.getRuntime().getModule("Net").getConstant("BufferedIO")).getConstant("NativeImplementation")});
                SelectableChannel sc = selChannel;
                recv2.dataWrapStruct(new NativeImpl(sc));
            }
            recv2.getInstanceVariables().setInstanceVariable("@io", io2);
            recv2.getInstanceVariables().setInstanceVariable("@read_timeout", recv2.getRuntime().newFixnum(60));
            recv2.getInstanceVariables().setInstanceVariable("@debug_output", recv2.getRuntime().getNil());
            recv2.getInstanceVariables().setInstanceVariable("@rbuf", RubyString.newEmptyString(recv2.getRuntime()));
            return recv2;
        }
        catch (BadDescriptorException e) {
            throw recv2.getRuntime().newErrnoEBADFError();
        }
    }

    @JRubyModule(name={"Net::BufferedIO::NativeImplementation"})
    public static class NativeImpl {
        private SelectableChannel channel;

        public NativeImpl(SelectableChannel channel) {
            this.channel = channel;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @JRubyMethod
        public static IRubyObject rbuf_fill(IRubyObject recv) {
            buf = (RubyString)recv.getInstanceVariables().getInstanceVariable("@rbuf");
            io = (RubyIO)recv.getInstanceVariables().getInstanceVariable("@io");
            timeout = RubyNumeric.fix2int(recv.getInstanceVariables().getInstanceVariable("@read_timeout")) * 1000;
            nim = (NativeImpl)recv.dataGetStruct();
            selector = null;
            var6_6 = nim.channel.blockingLock();
            synchronized (var6_6) {
                block17: {
                    block14: {
                        oldBlocking = nim.channel.isBlocking();
                        try {
                            try {
                                selector = SelectorFactory.openWithRetryFrom(recv.getRuntime(), SelectorProvider.provider());
                                nim.channel.configureBlocking(false);
                                key = nim.channel.register(selector, 1);
                                n = selector.select(timeout);
                                if (n <= 0) {
                                    exc = (RubyClass)recv.getRuntime().getModule("Timeout").getConstant("Error");
                                    throw new RaiseException(RubyException.newException(recv.getRuntime(), exc, "execution expired"), false);
                                }
                                readItems = io.read(new IRubyObject[]{recv.getRuntime().newFixnum(16384)});
                                var11_13 = buf.concat(readItems);
                                var13_14 = null;
                                if (selector == null) break block14;
                            }
                            catch (IOException exception) {
                                throw recv.getRuntime().newIOErrorFromException(exception);
                            }
                        }
                        catch (Throwable var12_18) {
                            var13_15 = null;
                            if (selector != null) {
                                try {
                                    selector.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            try {
                                nim.channel.configureBlocking(oldBlocking);
                                throw var12_18;
                            }
                            catch (IOException ioe) {
                                throw var12_18;
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [4 : 259->267)] { 
lbl45:
                        // 1 sources

                        selector.close();
                        break block14;
lbl47:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [5 : 269->283)] { 
lbl51:
                    // 1 sources

                    nim.channel.configureBlocking(oldBlocking);
                    break block17;
lbl54:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                return var11_13;
            }
        }
    }
}

