/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import org.jruby.Ruby;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubyString;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyObjectAdapter;
import org.jruby.embed.InvokeFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.EmbedRubyRuntimeAdapterImpl;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.InstanceVariable;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbedRubyObjectAdapterImpl
implements EmbedRubyObjectAdapter {
    private RubyObjectAdapter adapter = JavaEmbedUtils.newObjectAdapter();
    private ScriptingContainer container;

    public EmbedRubyObjectAdapterImpl(ScriptingContainer container) {
        this.container = container;
    }

    @Override
    public boolean isKindOf(IRubyObject value2, RubyModule rubyModule) {
        return this.adapter.isKindOf(value2, rubyModule);
    }

    @Override
    public IRubyObject[] convertToJavaArray(IRubyObject array) {
        return this.adapter.convertToJavaArray(array);
    }

    @Override
    public RubyInteger convertToRubyInteger(IRubyObject obj) {
        return this.adapter.convertToRubyInteger(obj);
    }

    @Override
    public RubyString convertToRubyString(IRubyObject obj) {
        return this.adapter.convertToRubyString(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject setInstanceVariable(IRubyObject obj, String variableName, IRubyObject value2) {
        BiVariableMap map;
        BiVariableMap biVariableMap = map = this.container.getVarMap();
        synchronized (biVariableMap) {
            if (map.containsKey(variableName)) {
                BiVariable bv = map.getVariable((RubyObject)this.container.getProvider().getRuntime().getTopSelf(), variableName);
                bv.setRubyObject(value2);
            } else {
                InstanceVariable iv = new InstanceVariable(obj, variableName, value2);
                map.update(variableName, iv);
            }
        }
        return obj.getInstanceVariables().setInstanceVariable(variableName, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject getInstanceVariable(IRubyObject obj, String variableName) {
        BiVariableMap map;
        BiVariableMap biVariableMap = map = this.container.getVarMap();
        synchronized (biVariableMap) {
            if (map.containsKey(variableName)) {
                BiVariable bv = map.getVariable((RubyObject)this.container.getProvider().getRuntime().getTopSelf(), variableName);
                return bv.getRubyObject();
            }
        }
        return null;
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName) {
        return this.adapter.callMethod(receiver2, methodName);
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject singleArg) {
        return this.adapter.callMethod(receiver2, methodName, singleArg);
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject[] args2) {
        return this.adapter.callMethod(receiver2, methodName, args2);
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject[] args2, Block block) {
        return this.adapter.callMethod(receiver2, methodName, args2, block);
    }

    @Override
    public IRubyObject callSuper(IRubyObject receiver2, IRubyObject[] args2) {
        return this.adapter.callSuper(receiver2, args2);
    }

    @Override
    public IRubyObject callSuper(IRubyObject receiver2, IRubyObject[] args2, Block block) {
        return this.adapter.callSuper(receiver2, args2, block);
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Class<T> returnType) {
        try {
            return this.call(MethodType.CALLMETHOD_NOARG, returnType, receiver2, methodName, null, null, new Object[0]);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object singleArg, Class<T> returnType) {
        try {
            return this.call(MethodType.CALLMETHOD, returnType, receiver2, methodName, null, null, singleArg);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Class<T> returnType) {
        try {
            return this.call(MethodType.CALLMETHOD, returnType, receiver2, methodName, null, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Block block, Class<T> returnType) {
        try {
            return this.call(MethodType.CALLMETHOD_WITHBLOCK, returnType, receiver2, methodName, block, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Class<T> returnType, EmbedEvalUnit unit) {
        try {
            return this.call(MethodType.CALLMETHOD_NOARG, returnType, receiver2, methodName, null, unit, new Object[0]);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Class<T> returnType, EmbedEvalUnit unit) {
        try {
            return this.call(MethodType.CALLMETHOD, returnType, receiver2, methodName, null, unit, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Block block, Class<T> returnType, EmbedEvalUnit unit) {
        try {
            return this.call(MethodType.CALLMETHOD_WITHBLOCK, returnType, receiver2, methodName, block, unit, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callSuper(Object receiver2, Object[] args2, Class<T> returnType) {
        try {
            return this.call(MethodType.CALLSUPER, returnType, receiver2, null, null, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callSuper(Object receiver2, Object[] args2, Block block, Class<T> returnType) {
        try {
            return this.call(MethodType.CALLSUPER_WITHBLOCK, returnType, receiver2, null, block, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public Object callMethod(Object receiver2, String methodName, Object ... args2) {
        try {
            if (args2.length == 0) {
                return this.call(MethodType.CALLMETHOD_NOARG, Object.class, receiver2, methodName, null, null, new Object[0]);
            }
            return this.call(MethodType.CALLMETHOD, Object.class, receiver2, methodName, null, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public Object callMethod(Object receiver2, String methodName, Block block, Object ... args2) {
        try {
            if (args2.length == 0) {
                throw new IllegalArgumentException("needs at least one argument in a method");
            }
            return this.call(MethodType.CALLMETHOD_WITHBLOCK, Object.class, receiver2, methodName, block, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T call(MethodType type2, Class<T> returnType, Object receiver2, String methodName, Block block, EmbedEvalUnit unit, Object ... args2) {
        T t;
        boolean sharing_variables;
        Ruby runtime;
        block12: {
            if (methodName == null) return null;
            if (methodName.length() == 0) {
                return null;
            }
            runtime = this.container.getProvider().getRuntime();
            RubyObject rubyReceiver = this.getReceiverObject(runtime, receiver2);
            sharing_variables = true;
            Object obj = this.container.getAttribute((Object)AttributeName.SHARING_VARIABLES);
            if (obj != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
                sharing_variables = false;
            }
            try {
                T t2;
                block11: {
                    try {
                        if (sharing_variables) {
                            ManyVarsDynamicScope scope = unit != null && unit.getScope() != null ? unit.getScope() : EmbedRubyRuntimeAdapterImpl.getManyVarsDynamicScope(this.container, 0);
                            this.container.getVarMap().inject(scope, 0, rubyReceiver);
                            runtime.getCurrentContext().pushScope(scope);
                        }
                        IRubyObject result2 = this.callEachType(type2, rubyReceiver, methodName, block, args2);
                        if (sharing_variables) {
                            this.container.getVarMap().retrieve(rubyReceiver);
                        }
                        if (!(result2 instanceof RubyNil) && returnType != null) {
                            Object ret = JavaEmbedUtils.rubyToJava(runtime, result2, returnType);
                            t2 = ret != null ? (T)returnType.cast(ret) : null;
                            Object var16_18 = null;
                            if (!sharing_variables) return t2;
                            break block11;
                        }
                        t = null;
                        break block12;
                    }
                    catch (RaiseException e) {
                        runtime.printError(e.getException());
                        throw new InvokeFailedException(e.getMessage(), e);
                    }
                    catch (Throwable e) {
                        throw new InvokeFailedException(e);
                    }
                }
                runtime.getCurrentContext().popScope();
                return t2;
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                if (!sharing_variables) throw throwable;
                runtime.getCurrentContext().popScope();
                throw throwable;
            }
        }
        Object var16_19 = null;
        if (!sharing_variables) return t;
        runtime.getCurrentContext().popScope();
        return t;
    }

    private RubyObject getReceiverObject(Ruby runtime, Object receiver2) {
        if (receiver2 == null || !(receiver2 instanceof IRubyObject) || receiver2 instanceof RubyNil) {
            return (RubyObject)runtime.getTopSelf();
        }
        if (receiver2 instanceof RubyObject) {
            return (RubyObject)receiver2;
        }
        return (RubyObject)((IRubyObject)receiver2).getRuntime().getTopSelf();
    }

    private IRubyObject callEachType(MethodType type2, IRubyObject rubyReceiver, String methodName, Block block, Object ... args2) {
        Ruby runtime = rubyReceiver.getRuntime();
        IRubyObject[] rubyArgs = null;
        if (args2 != null && args2.length > 0) {
            rubyArgs = JavaUtil.convertJavaArrayToRuby(runtime, args2);
            for (int i2 = 0; i2 < rubyArgs.length; ++i2) {
                IRubyObject obj = rubyArgs[i2];
                if (!(obj instanceof JavaObject)) continue;
                rubyArgs[i2] = Java.wrap(runtime, obj);
            }
        }
        ThreadContext context = runtime.getCurrentContext();
        switch (type2) {
            case CALLMETHOD_NOARG: {
                return RuntimeHelpers.invoke(context, rubyReceiver, methodName);
            }
            case CALLMETHOD: {
                return RuntimeHelpers.invoke(context, rubyReceiver, methodName, rubyArgs);
            }
            case CALLMETHOD_WITHBLOCK: {
                return RuntimeHelpers.invoke(context, rubyReceiver, methodName, rubyArgs, block);
            }
            case CALLSUPER: {
                return RuntimeHelpers.invokeSuper(context, rubyReceiver, rubyArgs, Block.NULL_BLOCK);
            }
            case CALLSUPER_WITHBLOCK: {
                return RuntimeHelpers.invokeSuper(context, rubyReceiver, rubyArgs, block);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodType {
        CALLMETHOD_NOARG,
        CALLMETHOD,
        CALLMETHOD_WITHBLOCK,
        CALLSUPER,
        CALLSUPER_WITHBLOCK;

    }
}

