/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import java.net.SocketAddress;
import jnr.unixsocket.Native;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocket;
import jnr.unixsocket.UnixSocketAddress;

public class UnixServerSocket {
    final UnixServerSocketChannel channel;
    final int fd;

    public UnixServerSocket() throws IOException {
        this.channel = new UnixServerSocketChannel(this);
        this.fd = this.channel.getFD();
    }

    UnixServerSocket(UnixServerSocketChannel unixServerSocketChannel) {
        this.channel = unixServerSocketChannel;
        this.fd = unixServerSocketChannel.getFD();
    }

    public UnixSocket accept() throws IOException {
        return new UnixSocket(this.channel.accept());
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 128);
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        if (!(socketAddress instanceof UnixSocketAddress)) {
            throw new IOException("Invalid address");
        }
        UnixSocketAddress unixSocketAddress = (UnixSocketAddress)socketAddress;
        if (Native.bind(this.fd, unixSocketAddress.getStruct(), unixSocketAddress.length()) < 0) {
            throw new IOException("bind failed: " + Native.getLastErrorString());
        }
        if (Native.listen(this.fd, n) < 0) {
            throw new IOException("listen failed: " + Native.getLastErrorString());
        }
    }
}

