/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import com.kenai.constantine.platform.ProtocolFamily;
import jnr.ffi.Platform;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;

abstract class SockAddrUnix
extends Struct {
    public static final int ADDR_LENGTH = 108;

    protected abstract Struct.UTF8String getPathField();

    protected abstract Struct.NumberField getFamilyField();

    public SockAddrUnix() {
        super(Runtime.getSystemRuntime());
    }

    public final void setFamily(ProtocolFamily protocolFamily) {
        this.getFamilyField().set(protocolFamily.value());
    }

    public final ProtocolFamily getFamily() {
        return ProtocolFamily.valueOf(this.getFamilyField().intValue());
    }

    public final void setPath(String string2) {
        this.getPathField().set(string2);
    }

    public final String getPath() {
        return this.getPathField().get();
    }

    public int getMaximumLength() {
        return 2 + this.getPathField().length();
    }

    public int length() {
        return 2 + SockAddrUnix.strlen(this.getPathField());
    }

    static SockAddrUnix create() {
        return Platform.getPlatform().isBSD() ? new BSDSockAddrUnix() : new DefaultSockAddrUnix();
    }

    private static final int strlen(Struct.UTF8String uTF8String) {
        int n = uTF8String.getMemory().indexOf(uTF8String.offset(), (byte)0);
        return n >= 0 ? n : uTF8String.length();
    }

    static final class DefaultSockAddrUnix
    extends SockAddrUnix {
        public final Struct.Unsigned16 sun_family = new Struct.Unsigned16();
        public final Struct.UTF8String sun_addr = (Struct)this.new Struct.UTF8String(108);

        DefaultSockAddrUnix() {
        }

        @Override
        protected final Struct.UTF8String getPathField() {
            return this.sun_addr;
        }

        @Override
        protected final Struct.NumberField getFamilyField() {
            return this.sun_family;
        }
    }

    static final class BSDSockAddrUnix
    extends SockAddrUnix {
        public final Struct.Unsigned8 sun_len = new Struct.Unsigned8();
        public final Struct.Unsigned8 sun_family = new Struct.Unsigned8();
        public final Struct.UTF8String sun_addr = (Struct)this.new Struct.UTF8String(108);

        BSDSockAddrUnix() {
        }

        @Override
        protected final Struct.UTF8String getPathField() {
            return this.sun_addr;
        }

        @Override
        protected final Struct.NumberField getFamilyField() {
            return this.sun_family;
        }
    }
}

