/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.KeyValuePair;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hash
extends Operand {
    public final List<KeyValuePair> pairs;

    public Hash(List<KeyValuePair> pairs) {
        this.pairs = pairs;
    }

    public boolean isBlank() {
        return this.pairs == null || this.pairs.isEmpty();
    }

    @Override
    public boolean hasKnownValue() {
        for (KeyValuePair pair : this.pairs) {
            if (pair.getKey().hasKnownValue() && pair.getValue().hasKnownValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        ArrayList<KeyValuePair> newPairs = new ArrayList<KeyValuePair>();
        for (KeyValuePair pair : this.pairs) {
            newPairs.add(new KeyValuePair(pair.getKey().getSimplifiedOperand(valueMap, force), pair.getValue().getSimplifiedOperand(valueMap, force)));
        }
        return new Hash(newPairs);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (KeyValuePair pair : this.pairs) {
            pair.getKey().addUsedVariables(l);
            pair.getValue().addUsedVariables(l);
        }
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        if (this.hasKnownValue()) {
            return this;
        }
        ArrayList<KeyValuePair> newPairs = new ArrayList<KeyValuePair>();
        for (KeyValuePair pair : this.pairs) {
            newPairs.add(new KeyValuePair(pair.getKey().cloneForInlining(ii), pair.getValue().cloneForInlining(ii)));
        }
        return new Hash(newPairs);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        Ruby runtime = context.runtime;
        RubyHash hash2 = RubyHash.newHash(runtime);
        for (KeyValuePair pair : this.pairs) {
            IRubyObject key2 = (IRubyObject)pair.getKey().retrieve(context, self, currDynScope, temp);
            IRubyObject value2 = (IRubyObject)pair.getValue().retrieve(context, self, currDynScope, temp);
            hash2.fastASetCheckString(runtime, key2, value2);
        }
        return hash2;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Hash(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (!this.isBlank()) {
            int pairCount = this.pairs.size();
            for (int i2 = 0; i2 < pairCount; ++i2) {
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(this.pairs.get(i2));
            }
        }
        builder.append("}");
        return builder.toString();
    }
}

